/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.screenflow;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.bpm.designer.screenflow.InputField;
import oracle.bpm.designer.screenflow.InputOptionsDialog;
import oracle.bpm.designer.screenflow.Model;
import oracle.bpm.designer.screenflow.TypeComboBox;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeHolder;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.editors.TableCellEditor;

class TypeCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private TypeComboBox editor;
    private Map<String, List<TypeHolder>> lists;

    TypeCellEditor(Map<String, List<TypeHolder>> lists) {
        this.lists = lists;
    }

    public UiComponent getTableCellEditor(Table table, Object value, boolean isSelected, int row, int column) {
        final Panel mainPanel = new Panel((UiContainer)table);
        RelativeLayout layout = new RelativeLayout();
        mainPanel.setLayout((Layout)layout);
        mainPanel.setOpaque(false);
        mainPanel.setBorder(null);
        this.editor = (TypeComboBox)this.createEditor((UiContainer)mainPanel, value);
        Model model = (Model)table.getModel();
        final InputField field = (InputField)model.getRow(row);
        TypeHolder target = field.getTarget();
        InputField.Type type = (InputField.Type)value;
        if (target != null) {
            this.editor.setType(target.getType());
        }
        if (type != null && this.editor.containsItem(type)) {
            this.editor.setSelectedItem(type);
        } else if (this.editor.getItemCount() > 0) {
            this.editor.setSelectedIndex(0);
        }
        Button triggerButton = new Button((UiContainer)mainPanel);
        triggerButton.setAction(new BaseAction(UIMsg.TO_MSG((String)"...")){

            public void run() {
                TypeCellEditor.this.stopCellEditing();
                TypeCellEditor.this.openAdvancedDialog((UiComponent)mainPanel, field);
            }
        });
        triggerButton.setEnabled(target != null && !target.getType().isEnum());
        triggerButton.setDefaultCapable(false);
        triggerButton.setFocusPainted(false);
        mainPanel.add((UiComponent)this.editor, (Object)"field");
        mainPanel.add((UiComponent)triggerButton, (Object)"button");
        this.layoutComponents(layout);
        return mainPanel;
    }

    public UiComponent createEditor(UiContainer parent, Object value) {
        this.editor = new TypeComboBox(parent);
        return this.editor;
    }

    public Object getCellEditorValue() {
        return this.editor.getSelectedItem();
    }

    private void openAdvancedDialog(UiComponent parent, InputField field) {
        InputOptionsDialog dialog = new InputOptionsDialog(parent.getOwnerWindow(), field, this.getTypeHolderList(field.getTarget().getType()));
        dialog.setVisible(true);
    }

    private List<TypeHolder> getTypeHolderList(TypeDescription fieldType) {
        List<TypeHolder> list = this.lists.get(fieldType.getName());
        if (list == null) {
            list = new ArrayList<TypeHolder>();
        }
        return list;
    }

    private void layoutComponents(RelativeLayout layout) {
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"button", (AttributeType)AttributeType.RIGHT);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"button", (AttributeType)AttributeType.TOP);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"button", (AttributeType)AttributeType.BOTTOM);
        layout.addConstraint("button", AttributeType.WIDTH, (Constraint)new AttributeConstraint("_container", AttributeType.HEIGHT));
        layout.addConstraint("field", AttributeType.RIGHT, (Constraint)new AttributeConstraint("button", AttributeType.LEFT, -1));
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"field", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"button");
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"field", (AttributeType)AttributeType.LEFT, (int)1);
    }
}

