/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.reports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.bpm.lang.Id;
import oracle.bpm.lang.Literals;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReportHTMLGenerator {
    private File htmlFile;
    private File resourcesDir;
    private File xdocFile;
    private String xslResource;
    private static final String DEFAULT_XSL_RESOURCE = "/fuego/designer/reports/xdoc2html.xsl";

    private ReportHTMLGenerator(String xslResource, File xdocFile, File htmlFile, File resourcesDir) {
        this.xslResource = xslResource == null ? DEFAULT_XSL_RESOURCE : xslResource;
        this.xdocFile = xdocFile;
        this.htmlFile = htmlFile;
        this.resourcesDir = resourcesDir;
    }

    public static File convertReport(File outputDir, String baseName) throws SAXException, ParserConfigurationException, IOException, TransformerException {
        File resourcesDir = new File(outputDir, baseName + "_files");
        File xdocFile = new File(resourcesDir, baseName + ".xdoc");
        File htmlFile = new File(outputDir, baseName + ".html");
        ReportHTMLGenerator rhg = new ReportHTMLGenerator(null, xdocFile, htmlFile, resourcesDir);
        rhg.saveBaseReportFiles();
        rhg.applyTransformer();
        return htmlFile;
    }

    private void applyTransformer() throws ParserConfigurationException, TransformerException, IOException, SAXException {
        InputStream is = this.getClass().getResourceAsStream(this.xslResource);
        assert (is != null);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(this.xdocFile.toURL().openStream()));
        DOMSource domSource = new DOMSource(document);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Templates templates = transformerFactory.newTemplates(new StreamSource(is));
        Transformer transformer = templates.newTransformer();
        transformer.setOutputProperty("encoding", Literals.DEFAULT_ENCODING);
        transformer.setParameter("version", Id.getAbsoluteVersion());
        transformer.setParameter("resources-dir", this.resourcesDir.getName());
        transformer.setParameter("resources-path", this.resourcesDir.getPath());
        StreamResult streamResult = new StreamResult(new FileOutputStream(this.htmlFile));
        transformer.transform(domSource, streamResult);
    }

    private void saveBaseReportFiles() throws IOException {
    }
}

