/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.renderers;

import oracle.bpm.designer.renderers.CatalogTypeRenderer;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.extensionpoint.metadata.ProjectObjectRendererMetadata;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.view.project.view.renderer.DefaultProjectObjectRenderer;
import oracle.bpm.ui.Image;

@ProjectObjectRendererMetadata(objectClass=DataDeclaration.class)
public class DataDeclarationRenderer
extends DefaultProjectObjectRenderer<DataDeclaration> {
    private static CatalogTypeRenderer catalogTypeRendererInstance;

    public String getLabel(DataDeclaration dataDeclaration) {
        String result = dataDeclaration.getName();
        if (dataDeclaration.getType().isArray()) {
            result = result + "[]";
        }
        return result;
    }

    public Image getIcon(DataDeclaration dataDeclaration) {
        ProjectDataObject pdo;
        CatalogType type = dataDeclaration.getType();
        Image resultImage = this.getCatalogTypeRendererInstance().getIcon(type);
        if (dataDeclaration instanceof ProjectDataObject && (pdo = (ProjectDataObject)dataDeclaration).isBusiness()) {
            resultImage = IconFactory.createBusinessIndicator(resultImage);
        }
        if (resultImage != null && dataDeclaration.isReadOnly()) {
            resultImage = IconFactory.createReadOnly(resultImage);
        }
        return resultImage;
    }

    private CatalogTypeRenderer getCatalogTypeRendererInstance() {
        if (catalogTypeRendererInstance == null) {
            catalogTypeRendererInstance = new CatalogTypeRenderer();
        }
        return catalogTypeRendererInstance;
    }
}

