/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.properties.variables;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.prop.Status;
import oracle.bpm.ui.prop.impl.IdentifierTextProperty;
import oracle.bpm.util.Identifier;

public class MethodNameProperty
extends IdentifierTextProperty {
    private MethodTypeDescription method;

    public MethodNameProperty(Msg name, MethodTypeDescription method) {
        super(name, method.getName());
        this.method = method;
    }

    public void dispose() {
        this.method = null;
    }

    protected Status isValidValue(Object newValue) {
        AttributeTypeDescription member;
        TypeDescription parent;
        String newVariableName = newValue.toString();
        if (newVariableName.length() == 0) {
            return Status.ERROR_STATUS((Msg)DesignerMsg.VALUE_IS_EMPTY);
        }
        if (this.method.getName().equals(newVariableName)) {
            return Status.OK_STATUS();
        }
        char ch = newVariableName.charAt(0);
        if (Character.isUpperCase(ch)) {
            return Status.ERROR_STATUS((Msg)DesignerMsg.VARIABLE_CANNOT_START_WITH_UPPER);
        }
        if (!Identifier.isValid(newVariableName)) {
            return Status.ERROR_STATUS((Msg)DesignerMsg.INVALID_IDENTIFIER);
        }
        FuegoProject project = FuegoProject.getFrom((TypeRef)this.method);
        if (project != null && (parent = this.method.getParent()) != null && (member = parent.findAttribute(newVariableName)) != null && !this.method.getName().equals(newVariableName)) {
            return Status.ERROR_STATUS((Msg)DesignerMsg.VARIABLE_ALREADY_DEFINED(newVariableName));
        }
        return Status.OK_STATUS();
    }
}

