/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.properties.variables;

import java.beans.PropertyChangeEvent;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.designer.cileditor.StorageTypeProperty;
import oracle.bpm.designer.cileditor.TypeProperty;
import oracle.bpm.designer.properties.variables.MethodNameProperty;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.EditorFactory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.PropertyRenderer;

public class InstanceVariableProperty
extends PropertyGroup {
    private StorageTypeProperty category;
    private AbstractProperty desc;
    private MethodTypeDescription method;
    private AbstractProperty name;
    private ObjectPropertyListener objectPropertyListener;
    private AbstractProperty type;
    private static InstanceVariablePropertyRenderer renderer = new InstanceVariablePropertyRenderer();

    public InstanceVariableProperty(DataObject dataObject) {
        this(dataObject.asAttributeTypeDescription(), true);
    }

    public InstanceVariableProperty(MethodTypeDescription variable, boolean isEditable) {
        super(variable.getName());
        this.method = variable;
        this.objectPropertyListener = new ObjectPropertyListener(){

            @Override
            public void propertyChanged(Object object, String propertyName) {
                String newName = ((MethodTypeDescription)object).getName();
                InstanceVariableProperty.this.setKey(newName);
                InstanceVariableProperty.this.name.setValue((Object)newName);
            }
        };
        this.method.addPropertyObserver("name", this.objectPropertyListener);
        this.setValue(variable);
        this.name = new MethodNameProperty(ProjectDrawMsg.NAME, variable);
        this.name.addStatusListener((AbstractProperty.StatusListener)this.name.getPropertyEditor());
        this.add((Property)this.name);
        this.type = new TypeProperty(CoreMsg.TYPE, variable, false);
        this.add((Property)this.type);
        this.setPropertyRenderer(renderer);
        this.setPropertyEditor(EditorFactory.TEXT_EDITOR);
    }

    public Object getDefaultEditable() {
        return this.name;
    }

    public void dispose() {
        super.dispose();
        this.name.removerStatusListener((AbstractProperty.StatusListener)this.name.getPropertyEditor());
        if (this.method != null) {
            this.method.removePropertyObserver("name", this.objectPropertyListener);
        } else {
            this.method = null;
        }
        this.objectPropertyListener = null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.name) {
            if (!this.name.getStatus().isError()) {
                MethodTypeDescription variable = (MethodTypeDescription)this.getValue();
                String newVariableName = evt.getNewValue().toString();
                this.setKey(newVariableName);
                variable.setName(newVariableName);
                this.markModified();
            }
        } else if (evt.getSource() == this.type) {
            this.markModified();
        } else if (evt.getSource() == this.desc) {
            MethodTypeDescription variable = (MethodTypeDescription)this.getValue();
            if (variable.getDescription() != null && variable.getDescription().equals(evt.getNewValue().toString()) || variable.getDescription() == null && "".equals(evt.getNewValue().toString())) {
                return;
            }
            variable.setDescription(evt.getNewValue().toString());
            this.markModified();
        }
        super.propertyChange(evt);
    }

    private void markModified() {
    }

    private static class InstanceVariablePropertyRenderer
    implements PropertyRenderer {
        private InstanceVariablePropertyRenderer() {
        }

        public String getRenderer(Property property) {
            return InstanceVariablePropertyRenderer.renderProperty(property);
        }

        public String getToolTip(Property property) {
            return InstanceVariablePropertyRenderer.renderProperty(property);
        }

        protected TypeRenderer getTypeRenderer() {
            return EditorPreferences.getInstance().getTypeRenderer();
        }

        private static String renderProperty(Property property) {
            MethodTypeDescription variable = (MethodTypeDescription)property.getValue();
            if (variable == null) {
                return null;
            }
            TypeRenderer renderer = EditorPreferences.getInstance().getTypeRenderer();
            String text = renderer.render((TypeRef)variable.getResultType(), 4);
            return text;
        }
    }
}

