/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.bpm.designer.cileditor.MethodTypeProperty;
import oracle.bpm.designer.cileditor.TypePropertyHolder;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.HiddenMessagesPreferences;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.PropertyTablePanel;
import oracle.bpm.ui.prop.impl.BooleanProperty;
import oracle.bpm.ui.prop.impl.TextProperty;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;

public class MethodPropertyTablePanel
extends PropertyTablePanel {
    private MethodTypeDescription member;

    public MethodPropertyTablePanel(UiContainer parent, MethodTypeDescription member) {
        super(parent, DesignerMsg.METHOD_PROPERTIES);
        this.member = member;
        this.createContent();
    }

    private static void setFOAbstract(ObjectTypeDescription fo) {
        DesignerPreferences preferences;
        boolean makeFOAbs;
        if (!fo.isAbstract() && (makeFOAbs = DialogFactory.showConfirmDialog((HiddenMessagesPreferences)(preferences = DesignerPreferences.getPreferences()), (Msg)DesignerMsg.MAKE_FO_ABSTRACT, (Msg)DesignerMsg.MAKE_FO_ABSTRACT_CONFIRMATION, (Msg)DesignerMsg.MAKE_FO_ABSTRACT_MSG))) {
            fo.addModifier(512L);
        }
    }

    private void createContent() {
        BooleanProperty abstractProperty;
        BooleanProperty cachedProperty;
        boolean isComponentContext;
        TypeDescription parent = this.member.getParent();
        boolean isInherited = Modifier.isInherited(this.member.getModifiers());
        PropertyGroup propertyGroup = this.getGroup();
        TextProperty nameProperty = Factory.createText((Msg)ProjectDrawMsg.NAME, (String)this.member.getName());
        nameProperty.setEditable(false);
        propertyGroup.add((Property)nameProperty);
        BooleanProperty staticProperty = Factory.createBoolean((Msg)DesignerMsg.STATIC, (boolean)this.member.isStatic());
        if (!parent.isInnerType()) {
            propertyGroup.add((Property)staticProperty);
        }
        boolean bl = isComponentContext = parent.isBpmObject() && parent.getParent() != null || parent.isInnerType();
        if (isComponentContext) {
            cachedProperty = Factory.createBoolean((Msg)DesignerMsg.CACHED, (boolean)this.member.hasModifiers(0x10000000000L));
            abstractProperty = Factory.createBoolean((Msg)DesignerMsg.ABSTRACT, (boolean)this.member.isAbstract());
            propertyGroup.add((Property)cachedProperty);
            propertyGroup.add((Property)abstractProperty);
        } else {
            cachedProperty = null;
            abstractProperty = null;
        }
        PropertyChangeListener listener = this.createListener((Property)staticProperty, (Property)cachedProperty, isComponentContext);
        if (isComponentContext) {
            cachedProperty.addPropertyChangeListener(listener);
            MethodTypeProperty returnType = new MethodTypeProperty(DesignerMsg.RETURNS, this.member);
            returnType.addPropertyChangeListener(listener);
            boolean serverSideValue = Modifier.isServer(this.member.getModifiers());
            BooleanProperty serverSide = Factory.createBoolean((Msg)DesignerMsg.SERVER, (boolean)serverSideValue);
            serverSide.addPropertyChangeListener(listener);
            boolean editable = !isInherited && !this.member.isSynthesized() && XObjectTypeDescriptionHelper.areEditableMethodproperties((MethodTypeDescription)this.member);
            returnType.setEditable(editable);
            serverSide.setEditable(editable);
            propertyGroup.add((Property)returnType);
            propertyGroup.add((Property)serverSide);
            if (serverSideValue) {
                XObjectTypeDescriptionHelper.setStatic((MethodTypeDescription)this.member, (boolean)false);
                staticProperty.setValue((Object)Boolean.FALSE);
                staticProperty.setEditable(false);
            } else {
                staticProperty.setEditable(editable);
            }
            boolean staticMethod = (Boolean)staticProperty.getValue();
            if (!staticMethod) {
                XObjectTypeDescriptionHelper.setCached((MethodTypeDescription)this.member, (boolean)false);
                cachedProperty.setValue((Object)Boolean.FALSE);
                cachedProperty.setEditable(false);
            }
        }
        staticProperty.addPropertyChangeListener(listener);
        if (abstractProperty != null) {
            abstractProperty.addPropertyChangeListener(listener);
        }
    }

    private PropertyChangeListener createListener(final Property staticProperty, final Property cachedProperty, final boolean componentContext) {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                Object value = evt.getNewValue();
                if (name.equals(DesignerMsg.STATIC.getCode())) {
                    boolean isStatic = (Boolean)value;
                    XObjectTypeDescriptionHelper.setStatic((MethodTypeDescription)MethodPropertyTablePanel.this.member, (boolean)isStatic);
                    if (componentContext) {
                        cachedProperty.setEditable(isStatic);
                        if (!isStatic) {
                            cachedProperty.setValue((Object)Boolean.FALSE);
                            cachedProperty.valueChanged();
                        }
                    }
                } else if (name.equals(DesignerMsg.SERVER.getCode())) {
                    boolean isServerSide = (Boolean)value;
                    XObjectTypeDescriptionHelper.setServerSide((MethodTypeDescription)MethodPropertyTablePanel.this.member, (boolean)isServerSide);
                    if (componentContext) {
                        staticProperty.setEditable(!isServerSide);
                        if (isServerSide) {
                            staticProperty.setValue((Object)Boolean.FALSE);
                            staticProperty.valueChanged();
                        }
                    }
                } else if (name.equals(DesignerMsg.RETURNS.getCode())) {
                    XObjectTypeDescriptionHelper.setResultType((MethodTypeDescription)MethodPropertyTablePanel.this.member, (TypeRef)((TypePropertyHolder)value).getType());
                } else if (name.equals(DesignerMsg.CACHED.getCode())) {
                    boolean isCached = (Boolean)value;
                    if (isCached) {
                        MethodPropertyTablePanel.this.member.addModifiers(0x10000000000L);
                    } else {
                        MethodPropertyTablePanel.this.member.clearModifier(0x10000000000L);
                    }
                } else if (name.equals(DesignerMsg.ABSTRACT.getCode())) {
                    boolean isAbstract = (Boolean)value;
                    if (isAbstract) {
                        MethodPropertyTablePanel.this.member.addModifiers(512L);
                        MethodPropertyTablePanel.setFOAbstract(MethodPropertyTablePanel.this.member.getParent().asObject());
                        boolean clearMethodBody = DialogFactory.showConfirmDialog((Msg)DesignerMsg.CLEAR_ABSTRACT_METHOD_BODY, (Msg)DesignerMsg.CLEAR_ABSTRACT_METHOD_BODY);
                        if (clearMethodBody) {
                            MethodPropertyTablePanel.this.member.setCode(null);
                        }
                    } else {
                        MethodPropertyTablePanel.this.member.clearModifier(512L);
                    }
                }
            }
        };
        return listener;
    }
}

