/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.project.ui;

import java.util.Comparator;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.Nullable;

public class ProjectVariablesComboBox
extends ComboBox<ProjectDataObject> {
    private Project project;

    public ProjectVariablesComboBox(UiContainer parent, Project project) {
        this(parent, project, null);
    }

    public ProjectVariablesComboBox(UiContainer parent, Project project, ProjectDataObject defaultSelection) {
        super(parent, false);
        this.project = project;
        this.init(defaultSelection);
    }

    private Project getProject() {
        return this.project;
    }

    private void init(@Nullable ProjectDataObject defaultSelection) {
        Sequence dataObjects = this.getProject().getProjectDataObjects();
        CollectionUtils.sort(dataObjects, new Comparator<ProjectDataObject>(){

            @Override
            public int compare(ProjectDataObject v1, ProjectDataObject v2) {
                return v1.getDefaultLabel().compareToIgnoreCase(v2.getDefaultLabel());
            }
        });
        for (ProjectDataObject dataObject : dataObjects) {
            this.addItem(dataObject);
        }
        if (this.getItemCount() > 0) {
            if (defaultSelection != null) {
                this.setSelectedItem(defaultSelection);
            } else {
                this.setSelectedIndex(0);
            }
        }
        this.setLabelProvider((LabelProvider)ProjectVariableLabelProvider.INSTANCE);
    }

    private static class ProjectVariableLabelProvider
    extends LabelProvider.Default<ProjectDataObject> {
        private TypeRenderer renderer = EditorPreferences.getInstance().getTypeRenderer();
        public static ProjectVariableLabelProvider INSTANCE = new ProjectVariableLabelProvider();

        private ProjectVariableLabelProvider() {
        }

        public String getText(ProjectDataObject dataObject) {
            return dataObject.getDefaultLabel() + this.getType(dataObject);
        }

        private String getType(ProjectDataObject dataObject) {
            return " (" + this.renderer.render((TypeRef)dataObject.getType().getDelegate(), 4) + ")";
        }
    }
}

