/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.processdesigner.states;

import oracle.bpm.designer.capability.add.ContainerAddingSequenceFlowCapability;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableConnection;
import oracle.bpm.diagram.draw.DrawableConnectionImpl;
import oracle.bpm.diagram.editor.ConnectionControllerImpl;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.SpecifiedResult;
import oracle.bpm.diagram.editor.state.AddingState;
import oracle.bpm.execution.Executable;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.ui.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddingSequenceFlowState
extends AddingState {
    private AddingSequenceFlowState(@NotNull ControllerConnectionFeedback controller) {
        super(CapabilityType.ADD_CONNECTION, (Controller)controller);
    }

    public static AddingSequenceFlowState create(@NotNull NodeContainerController<?> container, @Nullable FlowNode from, @NotNull TransitionType type) {
        return AddingSequenceFlowState.create(container, from, type, null);
    }

    public static AddingSequenceFlowState create(@NotNull NodeContainerController<?> container, @Nullable FlowNode from, @NotNull TransitionType type, final Executable callBack) {
        SequenceFlow flow = container.getModelObject().createSequenceFlow();
        if (type.isConditional()) {
            flow.toConditionalFlow();
        }
        DrawableConnectionFeedback drawable = new DrawableConnectionFeedback((Drawable)container.getDrawableObject(), flow);
        if (from != null) {
            drawable.setDrawableSource((Drawable)container.getDrawableObject().asDrawable((FlowElement)from));
        }
        ControllerConnectionFeedback controller = new ControllerConnectionFeedback(container, drawable);
        return new AddingSequenceFlowState(controller){

            protected void stateFinished() {
                if (callBack != null) {
                    callBack.execute();
                }
                super.stateFinished();
            }
        };
    }

    public void mouseReleased(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        if (this.adding != null && !this.getDrawableConnectionFeedback().isSourceDefined()) {
            this.keepAdding(mouse, unscaled);
        } else {
            super.mouseReleased(mouse, unscaled);
        }
    }

    public void mouseDragged(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        if (this.adding != null && !this.getDrawableConnectionFeedback().isSourceDefined()) {
            this.keepAdding(mouse, unscaled);
        } else {
            super.mouseDragged(mouse, unscaled);
        }
    }

    private DrawableConnectionFeedback getDrawableConnectionFeedback() {
        ControllerConnectionFeedback controller = (ControllerConnectionFeedback)this.adding.getAdding();
        return controller.getDrawableObject();
    }

    private void keepAdding(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        Controller controller = this.findAnyController(unscaled);
        CapabilityEvent event = CapabilityEvent.create((SpecifiedResult)this.adding, (Point)unscaled, (MouseEvent)mouse);
        event.setTarget(controller);
        if (this.adding.getCapability() instanceof ContainerAddingSequenceFlowCapability) {
            ContainerAddingSequenceFlowCapability capability = (ContainerAddingSequenceFlowCapability)this.adding.getCapability();
            capability.updateSource(event);
        }
        super.mouseMoved(mouse, unscaled);
    }

    public static class DrawableConnectionFeedback
    extends DrawableConnectionImpl<Object> {
        public DrawableConnectionFeedback(@NotNull Drawable container, @NotNull SequenceFlow connection) {
            super(container, (Object)connection, DesignerLayer.CAPABILITY);
        }

        public void draw() {
            if (this.isSourceDefined()) {
                super.draw();
            }
        }

        public boolean intersects(@NotNull Rectangle rectangle) {
            boolean result = false;
            if (this.isSourceDefined()) {
                result = super.intersects(rectangle);
            }
            return result;
        }

        public boolean contains(int x, int y) {
            boolean result = false;
            if (this.isSourceDefined()) {
                result = super.contains(x, y);
            }
            return result;
        }

        private boolean isSourceDefined() {
            return this.getDrawableSource() != null;
        }
    }

    public static class ControllerConnectionFeedback
    extends ConnectionControllerImpl<Object> {
        protected ControllerConnectionFeedback(Controller container, @NotNull DrawableConnectionFeedback drawable) {
            super(container, (DrawableConnection)drawable);
        }

        @NotNull
        public DrawableConnectionFeedback getDrawableObject() {
            return (DrawableConnectionFeedback)super.getDrawableObject();
        }
    }
}

