/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.process.wizard;

import java.util.LinkedList;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.designer.action.provider.SequenceFlowActions;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.process.wizard.FinalStep;
import oracle.bpm.designer.process.wizard.InitialStep;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import org.jetbrains.annotations.NotNull;

public class NewBPMProcessWizard
extends Wizard {
    private FolderContainer container;
    private Process process;
    private String processDescription;
    private LocaleStringMap processDescriptionMap;
    private String processLabel;
    private LocaleStringMap processLabelMap;
    private String processName;
    private Project project;

    public NewBPMProcessWizard(@NotNull Project project) {
        this(project, project.getModelsRoot());
    }

    public NewBPMProcessWizard(@NotNull Project project, @NotNull FolderContainer folder) {
        this.project = project;
        this.container = folder;
        this.getSteps().add(new FinalStep(this));
        this.updateTitle(null);
        this.setIcon(Image.create((Msg)DesignerMsg.PROCESS_BIG));
    }

    public void updateTitle(WizardStep step) {
        Msg oldMsg = this.getMsg();
        LinkedList steps = this.getSteps();
        int currentStep = step == null || steps == null ? 0 : steps.indexOf(step);
        this.setMsg(DesignerMsg.CREATE_PROCESS_STEPPED(currentStep + 1, 2));
        if (oldMsg != null) {
            this.getSupport().refreshTitle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doFinish() {
        try {
            Sequence sequence = this.process.getLanes();
            Organization organization = this.project.getOrganization();
            Role newRole = null;
            for (Lane lane : sequence) {
                Role role1;
                if (lane.isAutomatic() || (role1 = organization.findRoleById(lane.getRole())) != null) continue;
                String name = lane.getDefaultLabel();
                String id = ModelUtils.generateRoleId((Organization)organization, (String)name);
                newRole = organization.createRole(id, name);
            }
            for (SequenceFlow sequenceFlow : this.process.getSequenceFlows()) {
                SequenceFlowActions.getMakeOrthogonalCommand(sequenceFlow).execute();
            }
            Transactable txn = (Transactable)this.container;
            try {
                txn.beginTransaction();
                this.container.addChild((ProjectObject)this.process);
                if (newRole != null) {
                    organization.addChild(newRole);
                    organization.replace((ProjectObject)organization);
                }
            }
            finally {
                txn.endTransaction();
            }
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
            return false;
        }
        return true;
    }

    public Process getProcess() {
        return this.process;
    }

    public FolderContainer getContainer() {
        return this.container;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setProcessDescription(String processDescription) {
        this.processDescription = processDescription;
    }

    public void setProcessLabel(String processLabel) {
        this.processLabel = processLabel;
    }

    public void setProcessLabelMap(LocaleStringMap processLabelMap) {
        this.processLabelMap = processLabelMap;
    }

    public void setProcessDescriptionMap(LocaleStringMap processDescriptionMap) {
        this.processDescriptionMap = processDescriptionMap;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getProcessDescription() {
        return this.processDescription;
    }

    public String getProcessLabel() {
        return this.processLabel;
    }

    public LocaleStringMap getProcessLabelMap() {
        return this.processLabelMap;
    }

    public LocaleStringMap getProcessDescriptionMap() {
        return this.processDescriptionMap;
    }

    public Dimension getProperSize() {
        return Dimension.valueOf(650, 620);
    }

    protected WizardStep getInitialStep() {
        return new InitialStep(this);
    }
}

