/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.process.wizard;

import java.util.ArrayList;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.designer.DesignerResources;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.process.AsynchronousProcessTemplate;
import oracle.bpm.designer.process.CallableProcessTemplate;
import oracle.bpm.designer.process.ManualProcessTemplate;
import oracle.bpm.designer.process.ProcessCreationTemplate;
import oracle.bpm.designer.process.SynchronousProcessTemplate;
import oracle.bpm.designer.process.wizard.NewBPMProcessWizard;
import oracle.bpm.draw.Color;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Gallery;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MirrorTextArea;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;
import oracle.bpm.util.Identifier;

public class InitialStep
extends WizardStep {
    private InitialStepPanel initialStepPanel;
    private Process selectedProcess;
    private ArrayList<ProcessCreationTemplate> templates;
    private static final String PROCESS_TEMPLATE = "PROCESS_TEMPLATE";

    protected InitialStep(NewBPMProcessWizard owner) {
        super((Wizard)owner);
    }

    public NewBPMProcessWizard getWizard() {
        return (NewBPMProcessWizard)super.getWizard();
    }

    public boolean doProcess() {
        this.initialStepPanel.panelToObject();
        this.updateData();
        return true;
    }

    public void undoProcess() {
    }

    public boolean isFinishable() {
        return true;
    }

    protected WizardStepPanel getPanelFor(UiContainer parent) {
        this.initialStepPanel = new InitialStepPanel(parent, this);
        this.initialStepPanel.setPageTitle(DesignerMsg.BPMN_PROCESS.toString());
        this.initialStepPanel.setPageDesc(DesignerMsg.BPMN_PROCESS_WIZARD);
        return this.initialStepPanel;
    }

    private void updateData() {
        Process process = this.getWizard().getProcess();
        process.setLabelMap(this.getWizard().getProcessLabelMap());
        process.setDescription(this.getWizard().getProcessDescriptionMap());
        process.setId(this.getWizard().getProcessName());
        process.setDefaultLabel(this.getWizard().getProcessLabel());
        process.setDefaultDescription(this.getWizard().getProcessDescription());
    }

    private class InitialStepPanel
    extends WizardStepPanel {
        private AsynchronousProcessTemplate defaultTemplate;
        private MirrorTextArea description;
        private LocaleStringMap descriptionMap;
        private Gallery<TemplateItem> gallery;
        private TextField label;
        private LocaleStringMap labelMap;
        private ProcessCreationTemplate selectedProcessTemplate;

        public InitialStepPanel(UiContainer parent, WizardStep wizardStep) {
            super(parent, wizardStep);
            Project project = InitialStep.this.getWizard().getProject();
            FolderContainer container = InitialStep.this.getWizard().getContainer();
            this.defaultTemplate = new AsynchronousProcessTemplate(project, container);
            InitialStep.this.templates = new ArrayList();
            InitialStep.this.templates.add(this.defaultTemplate);
            InitialStep.this.templates.add(new SynchronousProcessTemplate(project, container));
            InitialStep.this.templates.add(new ManualProcessTemplate(project, container));
            InitialStep.this.templates.add(new CallableProcessTemplate(project, container));
        }

        public String getProcessName() {
            FuegoProject project = (FuegoProject)this.getDefaultProcess().getProject();
            String cut = Identifier.classname(ModelUtils.nextNameForModel((Project)project, (String)this.label.getText()), false);
            if (cut != null && cut.length() > 128) {
                cut = cut.substring(0, 128);
            }
            if (cut == null || cut.isEmpty()) {
                cut = this.getDefaultProcessName(project);
            }
            return cut;
        }

        public boolean validateInput() {
            return true;
        }

        public Process getSelectedProcess() {
            TemplateItem selection = (TemplateItem)this.gallery.getSelection();
            return selection == null ? this.getDefaultProcess() : selection.getProcess();
        }

        public void panelToObject() {
            InitialStep.this.getWizard().setProcess(this.getSelectedProcess());
            InitialStep.this.getWizard().setProcessName(this.getProcessName());
            InitialStep.this.getWizard().setProcessDescription(this.description.getText());
            InitialStep.this.getWizard().setProcessLabel(this.label.getText());
            InitialStep.this.getWizard().setProcessLabelMap(this.labelMap);
            InitialStep.this.getWizard().setProcessDescriptionMap(this.descriptionMap);
            InitialStep.this.getWizard().setProperty(InitialStep.PROCESS_TEMPLATE, this.gallery.getSelection());
        }

        protected UiComponent createCenterPage(UiContainer parent) {
            Panel content = new Panel(parent);
            content.setLayout((Layout)new BorderLayout());
            Panel panel = new Panel((UiContainer)content);
            content.add((UiComponent)panel, (Object)"North");
            String cols = "10px, pref, 8px, pref,8px,pref,10px,pref,8px,pref:grow,8px, pref,10px";
            String rows = "16px, top:pref,6px, top:pref:grow,0px,top:pref, 16px:grow";
            FormLayout formLayout = new FormLayout(cols, rows);
            panel.setLayout((Layout)formLayout);
            CellConstraints cc = formLayout.createCellConstraints();
            ArrayList<TemplateItem> list = new ArrayList<TemplateItem>();
            for (ProcessCreationTemplate processCreationTemplate : InitialStep.this.templates) {
                list.add(new TemplateItem(processCreationTemplate));
            }
            this.gallery = new Gallery((UiContainer)content, list, DesignerMsg.TYPE);
            this.gallery.setBorder(BorderFactory.createLoweredBevelBorder());
            content.add(this.gallery, (Object)"Center");
            content.add(Box.createHorizontalStrut((UiContainer)content, (int)10), (Object)"West");
            content.add(Box.createHorizontalStrut((UiContainer)content, (int)10), (Object)"East");
            content.add(Box.createVerticalStrut((UiContainer)content, (int)16), (Object)"South");
            this.label = new TextField(parent, 30);
            this.description = new MirrorTextArea(parent, (TextComponent)this.label);
            this.description.setLineWrap(true);
            this.description.setColumns(30);
            this.description.setRows(5);
            this.description.setWrapStyleWord(true);
            this.labelMap = LocaleStringMap.create();
            this.descriptionMap = LocaleStringMap.create();
            Project project = (InitialStep.this.selectedProcess == null ? this.getDefaultProcess() : InitialStep.this.selectedProcess).getProject();
            panel.add((UiComponent)Label.create((UiContainer)parent, (Msg)CoreMsg.NAME), (Object)cc.xy(2, 2));
            panel.add((UiComponent)this.label, (Object)cc.xyw(4, 2, 7));
            panel.add((UiComponent)DesignerResources.buildLocalizationButton(project, parent, this.labelMap, (TextComponent)this.label, DesignerMsg.LOCALIZE_LABEL.getString()), (Object)cc.xy(12, 2));
            panel.add((UiComponent)Label.create((UiContainer)parent, (Msg)DesignerMsg.DESCRIPTION), (Object)cc.xy(2, 4));
            panel.add((UiComponent)this.description, (Object)cc.xyw(4, 4, 7));
            panel.add((UiComponent)DesignerResources.buildLocalizationButton(project, parent, this.descriptionMap, (TextComponent)this.description, DesignerMsg.LOCALIZE_LABEL.getString(), true), (Object)cc.xy(12, 4));
            this.initValues();
            this.label.addModificationListener(new ModificationListener(){

                public void objectModified(ModificationEvent modificationEvent) {
                    InitialStep.this.getNextButton().setEnabled(!Str.isEmpty(InitialStepPanel.this.label.getText()));
                    InitialStep.this.getFinishButton().setEnabled(!Str.isEmpty(InitialStepPanel.this.label.getText()));
                }
            });
            return content;
        }

        private String getDefaultProcessName(FuegoProject project) {
            SchemaType schemaType = SchemaType.PROCESS;
            String cut = ModelUtils.nextNameForModel((Project)project, (String)schemaType.toString());
            cut = Identifier.classname(cut.toLowerCase());
            return cut;
        }

        private Process getDefaultProcess() {
            return this.defaultTemplate.getProcess();
        }

        private void initValues() {
            TemplateItem template;
            String processLabel = InitialStep.this.getWizard().getProcessLabel();
            String processDescription = InitialStep.this.getWizard().getProcessDescription();
            this.description.setText(processDescription);
            this.label.setText(processLabel);
            LocaleStringMap loadedMap = InitialStep.this.getWizard().getProcessLabelMap();
            if (loadedMap != null) {
                this.labelMap = loadedMap;
            }
            if ((loadedMap = InitialStep.this.getWizard().getProcessDescriptionMap()) != null) {
                this.descriptionMap = loadedMap;
            }
            if ((template = (TemplateItem)InitialStep.this.getWizard().getProperty(InitialStep.PROCESS_TEMPLATE)) == null) {
                template = new TemplateItem(this.defaultTemplate);
            }
            this.gallery.setSelection((Gallery.GalleryElement)template);
            if (processLabel == null || processLabel.trim().equals("")) {
                String defaultProcessName = this.getDefaultProcessName((FuegoProject)this.getDefaultProcess().getProject());
                this.label.setText(defaultProcessName);
                if (processDescription == null || processDescription.trim().equals("")) {
                    this.description.setText(defaultProcessName);
                }
            }
        }

        private class TemplateItem
        implements Gallery.GalleryElement {
            private ProcessCreationTemplate processCreationTemplate;

            public TemplateItem(ProcessCreationTemplate processCreationTemplate) {
                this.processCreationTemplate = processCreationTemplate;
            }

            public boolean equals(Object obj) {
                return obj instanceof TemplateItem && ((TemplateItem)obj).processCreationTemplate.getLabel().equals(this.processCreationTemplate.getLabel());
            }

            public String toString() {
                return this.processCreationTemplate.getLabel().toString();
            }

            public Process getProcess() {
                return this.processCreationTemplate.getProcess();
            }

            public Msg getDescriptionMsg() {
                return this.processCreationTemplate.getLabel();
            }

            public Msg getDescriptionIcon() {
                return this.getIconMsg();
            }

            public Msg getIcon() {
                return DesignerMsg.PROCESS_CALL;
            }

            public Msg getDisabledIcon() {
                return this.getIcon();
            }

            public Msg getShortLabel() {
                return this.processCreationTemplate.getLabel();
            }

            public boolean isAvailable() {
                return true;
            }

            public UiComponent getContent(UiContainer parent) {
                Label iconLabel = Label.create((UiContainer)parent, (Msg)this.getIconMsg());
                iconLabel.setOptions(2);
                iconLabel.setOpaque(true);
                iconLabel.setBackground(Color.WHITE);
                iconLabel.setBorder(BorderFactory.createLineBorder((Color)Color.DARK_GRAY));
                return iconLabel;
            }

            private Msg getIconMsg() {
                if (!this.processCreationTemplate.getLabel().hasImage()) {
                    return DesignerMsg.DEFAULT_PROCESS_TEMPLATE;
                }
                return this.processCreationTemplate.getLabel();
            }
        }
    }
}

