/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.process.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.extensionpoint.metadata.OutlineRootNode;
import oracle.bpm.project.ProcessObjectImpl;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.VirtualContainer;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.virtual.MeasurementMarksVirtualContainer;
import oracle.bpm.project.virtual.VirtualActivities;
import oracle.bpm.project.virtual.VirtualBusinessIndicatorsContainer;
import oracle.bpm.project.virtual.VirtualConversationsContainer;
import oracle.bpm.project.virtual.VirtualCorrelationKeysContainer;
import oracle.bpm.project.virtual.VirtualCorrelationsContainer;
import oracle.bpm.project.virtual.VirtualDataObjectsContainer;
import oracle.bpm.project.virtual.VirtualProjectDataObjectsContainer;
import org.jetbrains.annotations.NotNull;

@OutlineRootNode(objectClass=Process.class)
public class ProcessStructureTreeNode
extends ProjectObjectTreeNode<Process> {
    public ProcessStructureTreeNode(Process process) {
        super((ProjectObject)process);
        this.setMsg(DesignerMsg.PROCESS);
    }

    @Override
    protected void onLoading() {
        this.setFilter(new ProcessStructureNavigator());
        super.onLoading();
    }

    private static class ProcessStructureNavigator
    implements ProjectFilter {
        private Map<NodeContainer, VirtualActivities> activitiesContainerMap = new HashMap<NodeContainer, VirtualActivities>();
        private VirtualBusinessIndicatorsContainer businessIndicatorsContainer;
        private Map<NodeContainer, VirtualConversationsContainer> conversationsContainerMap = new HashMap<NodeContainer, VirtualConversationsContainer>();
        private Map<NodeContainer, VirtualCorrelationKeysContainer> correlationKeysContainerMap = new HashMap<NodeContainer, VirtualCorrelationKeysContainer>();
        private VirtualCorrelationsContainer correlationsContainer;
        private Map<NodeContainer, VirtualContainer> dataObjectsContainerMap = new HashMap<NodeContainer, VirtualContainer>();
        private Map<NodeContainer, MeasurementMarksVirtualContainer> measurementMarksContainerMap = new HashMap<NodeContainer, MeasurementMarksVirtualContainer>();
        private VirtualDataObjectsContainer projectDataObjectsContainer;

        private ProcessStructureNavigator() {
        }

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer projectObject) {
            Sequence<Object> result;
            if (projectObject instanceof NodeContainer) {
                ArrayList<Object> children = new ArrayList<Object>();
                NodeContainer nodeContainer = (NodeContainer)projectObject;
                if (nodeContainer instanceof Process) {
                    Process process = (Process)nodeContainer;
                    Project project = nodeContainer.getProject();
                    Process defaultProcess = project.getProjectModel();
                    children.add(this.getProjectDataObjectsNodeContainer((ProjectObjectContainer)nodeContainer, (NodeContainer)defaultProcess));
                    children.add(this.getBusinessIndicatorsNodeContainer((ProjectObjectContainer)nodeContainer, (NodeContainer)defaultProcess));
                    children.add(this.getCorrelationsContainer((ProjectObjectContainer)nodeContainer, process));
                    if (process.isCallableSubprocess()) {
                        children.add(process.getInputArgumentsContainer());
                        children.add(process.getOutputArgumentsContainer());
                    }
                    children.add(this.getVirtualConversationsContainer(nodeContainer, (ConversationContainer)process));
                } else if (nodeContainer instanceof Subprocess) {
                    Subprocess subprocess = (Subprocess)nodeContainer;
                    children.add(this.getCorrelationKeysContainer(nodeContainer, (CorrelationKeyContainer)subprocess));
                    children.add(this.getVirtualConversationsContainer(nodeContainer, (ConversationContainer)subprocess));
                }
                children.add(this.getVirtualNodeContainer(nodeContainer));
                children.add(this.getVirtualActivities(nodeContainer));
                children.add(this.getVirtualMeasurementMarksContainer(nodeContainer));
                result = CollectionUtils.asSequence(children);
            } else if (projectObject instanceof FlowNode) {
                FlowNode node = (FlowNode)projectObject;
                Sequence conditionalSequence = node.getOutgoingConditionalFlows();
                Sequence flowSequence = node.getOutgoingSequenceFlows();
                SequenceBuilder builder = SequenceBuilder.create(conditionalSequence, flowSequence);
                result = builder.build();
            } else {
                result = projectObject.getChildren();
            }
            return result;
        }

        public ProjectObjectContainer getParent(ProjectObject projectObject) {
            Object result = null;
            if (projectObject instanceof SequenceFlow) {
                SequenceFlow flowElement = (SequenceFlow)projectObject;
                result = flowElement.getSource();
            } else if (projectObject instanceof FlowNode) {
                FlowNode flowNode = (FlowNode)projectObject;
                NodeContainer nodeContainer = flowNode.getParentObject();
                VirtualActivities virtualActivities = this.getVirtualActivities(nodeContainer);
                result = flowNode.isActivity() ? virtualActivities.getVirtualActivitiesContainer() : (flowNode.isEvent() ? virtualActivities.getVirtualEventsContainer() : virtualActivities.getVirtualGatewaysContainer());
            } else if (projectObject instanceof Measurement) {
                Measurement measurement = (Measurement)projectObject;
                NodeContainer nodeContainer = measurement.getParentObject();
                result = (ProjectObjectContainer)this.measurementMarksContainerMap.get(nodeContainer);
            } else if (projectObject instanceof DataObject) {
                if (projectObject instanceof ProjectDataObject) {
                    ProjectDataObject projectDataObject = (ProjectDataObject)projectObject;
                    result = !projectDataObject.isBusiness() ? this.projectDataObjectsContainer : (projectDataObject.getBusinessVariableType().isDimension() ? this.businessIndicatorsContainer.getDimensionVirtualContainer() : (projectDataObject.getBusinessVariableType().isMeasure() ? this.businessIndicatorsContainer.getMeasureVirtualContainer() : (projectDataObject.getBusinessVariableType().isAttribute() ? this.businessIndicatorsContainer.getAttributeVirtualContainer() : this.businessIndicatorsContainer.getCounterVirtualContainer())));
                } else {
                    DataObject dataObject = (DataObject)projectObject;
                    NodeContainer nodeContainer = (NodeContainer)dataObject.getParentObject();
                    result = (ProjectObjectContainer)this.dataObjectsContainerMap.get(nodeContainer);
                }
            } else if (projectObject instanceof CorrelationProperty) {
                result = this.correlationsContainer.getVirtualCorrelationPropertiesContainer();
            } else if (projectObject instanceof CorrelationKey) {
                CorrelationKey correlationKey = (CorrelationKey)projectObject;
                CorrelationKeyContainer correlationKeyContainer = correlationKey.getParentObject();
                if (correlationKeyContainer.equals(this.correlationsContainer.getRealParent())) {
                    result = this.correlationsContainer.getVirtualCorrelationKeysContainer();
                } else {
                    NodeContainer nodeContainer = (NodeContainer)correlationKeyContainer;
                    result = (ProjectObjectContainer)this.correlationKeysContainerMap.get(nodeContainer);
                }
            } else if (projectObject instanceof Conversation) {
                Conversation conversation = (Conversation)projectObject;
                if (!conversation.isDefaultConversation()) {
                    NodeContainer nodeContainer = (NodeContainer)conversation.getParentObject();
                    result = this.getVirtualConversationsContainer(nodeContainer, (ConversationContainer)nodeContainer);
                }
            } else if (!(projectObject instanceof ProcessObjectImpl)) {
                result = (ProjectObjectContainer)projectObject.getParentObject();
            }
            return result;
        }

        private ProjectObject getProjectDataObjectsNodeContainer(ProjectObjectContainer parent, NodeContainer realParent) {
            if (this.projectDataObjectsContainer == null) {
                this.projectDataObjectsContainer = new VirtualProjectDataObjectsContainer(parent, realParent);
            }
            return this.projectDataObjectsContainer;
        }

        private ProjectObject getBusinessIndicatorsNodeContainer(ProjectObjectContainer parent, NodeContainer realParent) {
            if (this.businessIndicatorsContainer == null) {
                this.businessIndicatorsContainer = new VirtualBusinessIndicatorsContainer(parent, realParent);
            }
            return this.businessIndicatorsContainer;
        }

        private VirtualContainer getVirtualNodeContainer(NodeContainer parent) {
            VirtualContainer virtualContainer = this.dataObjectsContainerMap.get(parent);
            if (virtualContainer == null) {
                virtualContainer = new VirtualDataObjectsContainer(parent);
                this.dataObjectsContainerMap.put(parent, virtualContainer);
            }
            return virtualContainer;
        }

        private VirtualActivities getVirtualActivities(NodeContainer nodeContainer) {
            VirtualActivities virtualActivities = this.activitiesContainerMap.get(nodeContainer);
            if (virtualActivities == null) {
                virtualActivities = new VirtualActivities(nodeContainer);
                this.activitiesContainerMap.put(nodeContainer, virtualActivities);
            }
            return virtualActivities;
        }

        private MeasurementMarksVirtualContainer getVirtualMeasurementMarksContainer(NodeContainer nodeContainer) {
            MeasurementMarksVirtualContainer virtualMeasurementMarksContainer = this.measurementMarksContainerMap.get(nodeContainer);
            if (virtualMeasurementMarksContainer == null) {
                virtualMeasurementMarksContainer = new MeasurementMarksVirtualContainer(nodeContainer);
                this.measurementMarksContainerMap.put(nodeContainer, virtualMeasurementMarksContainer);
            }
            return virtualMeasurementMarksContainer;
        }

        private VirtualCorrelationsContainer getCorrelationsContainer(ProjectObjectContainer parent, Process realParent) {
            if (this.correlationsContainer == null) {
                this.correlationsContainer = new VirtualCorrelationsContainer(parent, realParent);
            }
            return this.correlationsContainer;
        }

        private VirtualCorrelationKeysContainer getCorrelationKeysContainer(NodeContainer parent, CorrelationKeyContainer realParent) {
            VirtualCorrelationKeysContainer keysContainer = this.correlationKeysContainerMap.get(parent);
            if (keysContainer == null) {
                keysContainer = new VirtualCorrelationKeysContainer((ProjectObjectContainer)parent, realParent);
                this.correlationKeysContainerMap.put(parent, keysContainer);
            }
            return keysContainer;
        }

        private VirtualConversationsContainer getVirtualConversationsContainer(NodeContainer parent, ConversationContainer container) {
            VirtualConversationsContainer conversationsContainer = this.conversationsContainerMap.get(parent);
            if (conversationsContainer == null) {
                conversationsContainer = new VirtualConversationsContainer(parent, container);
                this.conversationsContainerMap.put(parent, conversationsContainer);
            }
            return conversationsContainer;
        }
    }
}

