/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.process.tree;

import oracle.bpm.designer.Context;
import oracle.bpm.designer.DesignerActions;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.action.FlowNodeActions;
import oracle.bpm.designer.action.RemoveActivityAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.extensionpoint.metadata.TreeNodeMetadata;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import org.jetbrains.annotations.NotNull;

@TreeNodeMetadata(objectType=FlowNode.class)
public class ActivityTreeNode
extends ProjectObjectTreeNode<FlowNode> {
    public ObjectPropertyListener themeListener = new ObjectPropertyListener(){

        @Override
        public void propertyChanged(Object object, String propertyName) {
            ActivityTreeNode.this.nodeChanged();
        }
    };

    public ActivityTreeNode(FlowNode node) {
        super((ProjectObject)node);
        DesignerPreferences.getPreferences().addPropertyObserver("selectedDesignerTheme", this.themeListener);
    }

    @Override
    public BaseAction getActionForId(int actionId) {
        switch (actionId) {
            case 1: {
                if (!ModelUtils.canDelete((FlowElement)((FlowElement)this.getProjectObject()))) {
                    return null;
                }
                return new RemoveActivityAction((FlowNode)this.getProjectObject());
            }
        }
        return null;
    }

    @Override
    public Image resolveIcon() {
        return DefaultTheme.getDefault().getImageFor((FlowElement)this.getProjectObject(), ImageType.MINI_ICON);
    }

    @Override
    public ActionGroup createActions() {
        ActionGroup result = null;
        if (this.isEditorOpened()) {
            FlowNode flowNode = (FlowNode)this.getProjectObject();
            result = ActionGroup.create((Object)flowNode, (Class)flowNode.getRawClass());
            this.appendSequenceFlowActions(result);
        }
        return result;
    }

    public boolean delete() {
        if (ModelUtils.canDelete((FlowElement)((FlowElement)this.getProjectObject()))) {
            DesignerActions.cutAction.actionPerformed(null);
            return true;
        }
        MessageDialog.showError((Msg)DesignerMsg.CANNOT_REMOVE_OBJECT(((FlowNode)this.getProjectObject()).getId()));
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ActivityTreeNode) {
            ActivityTreeNode other = (ActivityTreeNode)((Object)obj);
            return this.getProjectObject() == other.getProjectObject();
        }
        return false;
    }

    public int hashCode() {
        return ((FlowNode)this.getProjectObject()).hashCode();
    }

    @Override
    public String toString() {
        return ((FlowNode)this.getProjectObject()).getDefaultLabel();
    }

    public Selection getSelection() {
        return DefaultSelection.createSingle((Object)ModelObjectSelection.create((FlowElement[])new FlowElement[]{(FlowElement)this.getProjectObject()}));
    }

    protected void removeListeners() {
        super.removeListeners();
        DesignerPreferences.getPreferences().removePropertyObserver("selectedDesignerTheme", this.themeListener);
    }

    @Override
    protected int getMultipleActionsMask() {
        return 1;
    }

    protected void addCommonActions() {
        super.addCommonActions();
        if (ModelUtils.canDelete((FlowElement)((FlowElement)this.getProjectObject()))) {
            this.getCommonActionsMap().put("delete-action", DesignerActions.cutAction);
        }
    }

    private void appendSequenceFlowActions(@NotNull ActionGroup result) {
        ActionGroup group;
        FlowNode flowNode = (FlowNode)this.getProjectObject();
        TransitionType type = null;
        if (flowNode.getOutgoingSequenceFlows().isEmpty()) {
            type = TransitionType.UNCONDITIONAL;
        }
        if (ModelUtils.canHaveOutgoingConditionalFlows((FlowNode)flowNode) && FlowNodeActions.checkValidTargets(flowNode, TransitionType.CONDITIONAL)) {
            type = TransitionType.CONDITIONAL;
        }
        if (type != null && (group = FlowNodeActions.buildTransitionTargetAction(flowNode, type)) != null) {
            result.add((BaseAction)group);
        }
    }

    private boolean isEditorOpened() {
        return Context.getDomainFor(((FlowNode)this.getProjectObject()).getProcess()) != null;
    }
}

