/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.process.tree;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.extensionpoint.metadata.OutlineRootNode;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.virtual.VirtualMilestonesContainer;
import org.jetbrains.annotations.NotNull;

@OutlineRootNode(objectClass=ActivityGuide.class)
public class ActivityGuideStructureTreeNode
extends ProjectObjectTreeNode<ActivityGuide> {
    public ActivityGuideStructureTreeNode(ActivityGuide activityGuide) {
        super((ProjectObject)activityGuide);
        this.setMsg(ProjectMsg.ACTIVITY_GUIDES);
    }

    @Override
    protected void onLoading() {
        this.setFilter(new ActivityGuideStructureNavigator());
        super.onLoading();
    }

    private static class ActivityGuideStructureNavigator
    implements ProjectFilter {
        private VirtualMilestonesContainer milestonesContainer;

        private ActivityGuideStructureNavigator() {
        }

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer projectObject) {
            Sequence result;
            if (projectObject instanceof ActivityGuide) {
                ArrayList<ProjectObject> children = new ArrayList<ProjectObject>();
                children.add(this.getMilestonesContainer((ActivityGuide)projectObject));
                result = CollectionUtils.asSequence(children);
            } else {
                result = projectObject.getChildren();
            }
            return result;
        }

        public ProjectObjectContainer getParent(ProjectObject projectObject) {
            if (projectObject instanceof Milestone) {
                return this.milestonesContainer;
            }
            return (ProjectObjectContainer)projectObject.getParentObject();
        }

        private ProjectObject getMilestonesContainer(ActivityGuide aGuide) {
            if (this.milestonesContainer == null) {
                this.milestonesContainer = new VirtualMilestonesContainer(aGuide);
            }
            return this.milestonesContainer;
        }
    }
}

