/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.process;

import oracle.bpm.designer.action.ModelActions;
import oracle.bpm.lang.Id;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.features.FileRevisionFeature;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.RadioButton;

public abstract class ProcessCreationTemplate {
    protected FolderContainer container;
    protected Project project;
    private RadioButton button;

    protected ProcessCreationTemplate() {
    }

    protected ProcessCreationTemplate(Project project, FolderContainer container) {
        this.project = project;
        this.container = container;
    }

    public abstract Msg getLabel();

    public final Process getProcess() {
        Process process = this.createProcess(ModelUtils.validIdForProcess((Project)this.project, (String)LibMsg.PROCESS.getString()));
        if (process != null) {
            ModelActions.getLayoutCommand(process, false).execute();
            FileRevisionFeature revisionFeature = (FileRevisionFeature)process.getFeature(FileRevisionFeature.class);
            revisionFeature.setVersion(Id.getAbsoluteVersion());
            revisionFeature.setRevision(Integer.valueOf("20120217").intValue());
        }
        return process;
    }

    public RadioButton getButton() {
        return this.button;
    }

    public Process getProcess(FuegoProject project) {
        this.project = project;
        return this.getProcess();
    }

    protected abstract Process createProcess(String var1);
}

