/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.print;

import java.util.List;
import oracle.bpm.designer.print.DomainPrintable;
import oracle.bpm.diagram.draw.ChildrenPopulator;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableFactory;
import oracle.bpm.draw.BpmnDrawableFactory;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableChildPopulator;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.DrawableSingleProcessRoot;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.project.model.features.ViewScaleFeature;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.UiUtilities;
import org.jetbrains.annotations.NotNull;

public class ProcessPrintable
extends DomainPrintable {
    private static final int PROCESS_HEADER_HEIGHT = 20;
    private static final Font PROCESS_HEADER_FONT = Font.SANS_SERIF.bold();

    public ProcessPrintable(@NotNull Process process) {
        DrawableProcess drawable = this.createDrawableProcess(process);
        this.setDrawable((Drawable)drawable);
        this.setBounds(drawable.getBounds());
        this.setContext(drawable.getContext());
    }

    @Override
    protected int printHeader(int pageIndex, int width, int height) {
        Graphics graphics = this.getPrintingContext().getGraphics();
        graphics.setFont(this.getProcessHeaderFont());
        String text = ProjectDrawMsg.PROCESS.withColon().getString() + " " + ((Process)this.getDrawable().getModelObject()).getDefaultLabel();
        int textWidth = UiUtilities.computeStringWidth((FontMetrics)graphics.getFontMetrics(), (String)text);
        int textHeight = graphics.getFontMetrics().getHeight();
        graphics.setForeground(Color.BLACK);
        graphics.drawString(text, width / 2 - textWidth / 2, (int)((double)textHeight * 0.75));
        return super.printHeader(pageIndex, width, height);
    }

    protected DrawableProcess getDrawable() {
        return (DrawableProcess)super.getDrawable();
    }

    @Override
    protected int getPrintingHeaderHeight() {
        return 20;
    }

    private DrawableProcess createDrawableProcess(@NotNull Process process) {
        DrawContext context = this.createPrintableContext();
        DrawableSingleProcessRoot root = DrawableSingleProcessRoot.create(null, (DiagramContext)context);
        BpmnDrawablePrintingFactory factory = BpmnDrawablePrintingFactory.getInstance();
        DrawableChildPopulator.populateChild((DrawableFactory)factory, (Drawable)root, (Object)process);
        context.setScale(((Float)process.getFeatureValue(ViewScaleFeature.class)).floatValue());
        return root.getSingleProcess();
    }

    private Font getProcessHeaderFont() {
        return PROCESS_HEADER_FONT;
    }

    private static class BpmnDrawablePrintingFactory
    extends BpmnDrawableFactory {
        private static BpmnDrawablePrintingFactory instance;

        private BpmnDrawablePrintingFactory() {
        }

        public static BpmnDrawablePrintingFactory getInstance() {
            if (instance == null) {
                instance = new BpmnDrawablePrintingFactory();
            }
            return instance;
        }

        protected ChildrenPopulator processPopulator() {
            return new BpmnDrawableFactory.NodeContainerPopulator<Process>(Process.class){

                protected void append(@NotNull List<Object> result, @NotNull Process process) {
                    for (Lane lane : process.getLanes()) {
                        result.add(lane);
                    }
                }
            };
        }
    }
}

