/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.print;

import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.print.PageFormat;
import oracle.bpm.print.Printable;
import oracle.bpm.print.PrinterException;
import oracle.bpm.ui.UiUtilities;
import org.jetbrains.annotations.NotNull;

public class DomainPrintable
implements Printable {
    private Rectangle bounds;
    private DrawContext context;
    private Drawable drawable;
    private static final int PAGE_NUMBER_HEIGHT = 12;
    private static final Font PAGE_NUMBER_FONT = Font.SANS_SERIF.resize(8);

    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        DrawContext context = this.getPrintingContext();
        context.setGraphics(g);
        Dimension pages = this.getPages(pf);
        int x = (int)pf.getImageableX();
        int y = (int)pf.getImageableY();
        int width = (int)pf.getImageableWidth();
        int height = (int)pf.getImageableHeight();
        g.translate(x, y);
        this.printBackground(width, height);
        int header = this.printHeader(pageIndex, width, height);
        int currentPrintingX = pageIndex % pages.getWidth() * width;
        int currentPrintingY = pageIndex / pages.getWidth() * (height - header);
        context.setStartX(currentPrintingX);
        context.setStartY(currentPrintingY);
        g.translate(-currentPrintingX, -currentPrintingY);
        this.getDrawable().draw();
        g.translate(currentPrintingX, currentPrintingY);
        g.translate(0, -header);
        return pageIndex < pages.getWidth() * pages.getHeight() ? 0 : 1;
    }

    protected void setBounds(@NotNull Rectangle bounds) {
        this.bounds = bounds;
    }

    protected void setContext(@NotNull DrawContext context) {
        this.context = context;
    }

    protected void setDrawable(@NotNull Drawable drawable) {
        this.drawable = drawable;
    }

    protected void printBackground(int width, int height) {
        Graphics graphics = this.getPrintingContext().getGraphics();
        graphics.setClip(0, 0, width, height);
        graphics.setForeground(Color.WHITE);
        graphics.fillRect(0, 0, width, height);
    }

    protected int printHeader(int pageIndex, int width, int height) {
        Graphics graphics = this.getPrintingContext().getGraphics();
        int headerHeight = this.getPrintingHeaderHeight();
        Font font = this.getPrintingPageNumberFont();
        int textHeight = graphics.getFontMetrics(graphics.getFont()).getHeight();
        String text = ProjectDrawMsg.PAGE.getString() + " " + String.valueOf(pageIndex + 1);
        int textWidth = UiUtilities.computeStringWidth((FontMetrics)graphics.getFontMetrics(font), (String)text);
        graphics.setForeground(Color.DARK_GRAY);
        graphics.setFont(font);
        graphics.drawString(text, width - (textWidth + 1), (int)((double)textHeight * 0.75));
        graphics.setForeground(Color.BLACK);
        graphics.setClip(0, headerHeight, width, height - headerHeight);
        graphics.translate(0, headerHeight);
        return headerHeight;
    }

    protected DrawContext createPrintableContext() {
        DrawContext context = new DrawContext();
        context.setPrinting(true);
        context.setScale(1.0f);
        context.setShowGrid(false);
        return context;
    }

    protected DrawContext getPrintingContext() {
        return this.context;
    }

    protected Drawable getDrawable() {
        return this.drawable;
    }

    protected int getPrintingHeaderHeight() {
        return 12;
    }

    protected Font getPrintingPageNumberFont() {
        return PAGE_NUMBER_FONT;
    }

    private Dimension getPages(@NotNull PageFormat pageFormat) {
        Dimension dimension = this.bounds.getSize();
        int width = dimension.getWidth();
        int height = dimension.getHeight();
        DrawContext context = this.getPrintingContext();
        int printWidth = Math.round((float)width * context.getScale());
        int printHeight = Math.round((float)height * context.getScale());
        float pagesWidth = (float)printWidth / (float)pageFormat.getImageableWidth();
        float pagesHeight = (float)printHeight / (float)(pageFormat.getImageableHeight() - (double)this.getPrintingHeaderHeight());
        int xPages = (int)Math.ceil(pagesWidth);
        int yPages = (int)Math.ceil(pagesHeight);
        return Dimension.valueOf(xPages == 0 ? 1 : xPages, yPages == 0 ? 1 : yPages);
    }
}

