/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.bpm.designer.preferences.ProcessLocationData;
import oracle.bpm.project.io.fs.AbstractPreferencesLoader;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.util.FileUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DesignerProjectPreferences {
    private String[][] lastExpandedProjectPaths;
    private String[][] lastFocusedContext = null;
    private List<List<String[]>> lastOpenedContexts = new ArrayList<List<String[]>>();
    private HashMap<Path, ProcessLocationData> lastOpenedProcesses = new HashMap();
    private String[][] lastSelectedProjectPaths;
    private final Project project;
    private boolean rememberProjectTreeView = true;

    private DesignerProjectPreferences(Project project) {
        this.project = project;
    }

    public static DesignerProjectPreferences createDefault(Project project) {
        return new DesignerProjectPreferences(project);
    }

    public static DesignerProjectPreferences load(Project project, File file) throws ProjectException {
        DesignerProjectPreferences result = DesignerProjectPreferences.createDefault(project);
        result.load(file);
        return result;
    }

    public void setLastExpandedProjectPaths(String[][] lastExpandedProjectPaths) {
        this.lastExpandedProjectPaths = lastExpandedProjectPaths;
    }

    public String[][] getLastExpandedProjectPaths() {
        return this.lastExpandedProjectPaths;
    }

    public void setLastFocusedContexts(String[][] contextPath) {
        this.lastFocusedContext = contextPath;
    }

    public String[][] getLastFocusedContexts() {
        return this.lastFocusedContext;
    }

    public List getLastOpenedContexts() {
        return this.lastOpenedContexts;
    }

    public Map<Path, ProcessLocationData> getLastOpenedProcesses() {
        return this.lastOpenedProcesses;
    }

    public void setLastSelectedPath(String[][] lastSelectedProjectPaths) {
        this.lastSelectedProjectPaths = lastSelectedProjectPaths;
    }

    public String[][] getLastSelectedPaths() {
        return this.lastSelectedProjectPaths;
    }

    public ProcessLocationData getProcessData(Path physLocation) {
        return this.getLastOpenedProcesses().get(physLocation);
    }

    public void setRememberProjectTreeView(boolean rememberProjectTreeView) {
        this.rememberProjectTreeView = rememberProjectTreeView;
    }

    public boolean isRememberProjectTreeView() {
        return this.rememberProjectTreeView;
    }

    public void addOpenedContexts(String[] parentContext, String[] context) {
        ArrayList<String[]> t = new ArrayList<String[]>();
        if (parentContext != null) {
            t.add(parentContext);
        }
        t.add(context);
        this.lastOpenedContexts.add(t);
    }

    private void load(File file) throws ProjectException {
        Loader loader = new Loader(file);
        loader.load(this.project);
    }

    class Loader
    extends AbstractPreferencesLoader {
        private List expandedPathList;
        private List focusContextList;
        private List openedContextList;
        private int openedFocusContext;
        private List selectedPathList;

        public Loader(File file) {
            super(file);
            this.openedFocusContext = 0;
        }

        public void addOpenedContexts(String[] parentContext, String[] context) {
            ArrayList<String[]> t = new ArrayList<String[]>();
            if (parentContext != null) {
                t.add(parentContext);
            }
            t.add(context);
            DesignerProjectPreferences.this.lastOpenedContexts.add(t);
        }

        public void endElement(String uri, String local, String name) throws SAXException {
            if (name.equals("lastView")) {
                String[][] selected = (String[][])this.selectedPathList.toArray((T[])new String[0][0]);
                String[][] expanded = (String[][])this.expandedPathList.toArray((T[])new String[0][0]);
                DesignerProjectPreferences.this.setLastExpandedProjectPaths(expanded);
                DesignerProjectPreferences.this.setLastSelectedPath(selected);
            }
            if (name.equals("openedContext") && this.openedContextList.size() > 0) {
                this.openedContextList.remove(this.openedContextList.size() - 1);
            }
            if (name.equals("focusContext")) {
                --this.openedFocusContext;
                if (this.openedFocusContext <= 0) {
                    DesignerProjectPreferences.this.setLastFocusedContexts((String[][])this.focusContextList.toArray((T[])new String[0][0]));
                }
            }
        }

        public void startElement(String uri, String local, String name, Attributes amap) throws SAXException {
            if (name.equals("processes")) {
                this.manageProcessesInfo(amap);
            } else if (name.equals("lastView")) {
                this.selectedPathList = new ArrayList();
                this.expandedPathList = new ArrayList();
            } else if (name.equals("lastExpandedPath")) {
                this.manageExpandedViewInfo(amap);
            } else if (name.equals("lastSelectedPath")) {
                this.manageSelectedViewInfo(amap);
            } else if (name.equals("openedContext")) {
                this.manageOpenContext(amap);
            } else if (name.equals("focusContext")) {
                this.manageFocusContext(amap);
            }
        }

        private String arrayToString(String[] array) {
            String path = "";
            for (int j = 0; j < array.length; ++j) {
                path = path + array[j] + ";";
            }
            path = path.substring(0, path.lastIndexOf(";"));
            return path;
        }

        private void manageExpandedViewInfo(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (!attname.equals("expandedPath")) continue;
                StringTokenizer st = new StringTokenizer(value, ";");
                int size = st.countTokens();
                String[] path = new String[size];
                int pathI = 0;
                while (st.hasMoreTokens()) {
                    path[pathI++] = st.nextToken();
                }
                this.expandedPathList.add(path);
            }
        }

        private void manageFocusContext(Attributes amap) {
            ++this.openedFocusContext;
            if (this.focusContextList == null) {
                this.focusContextList = new ArrayList();
            }
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (!attname.equals("context")) continue;
                String[] path = this.stringToArray(value);
                this.focusContextList.add(path);
            }
        }

        private void manageOpenContext(Attributes amap) {
            if (this.openedContextList == null) {
                this.openedContextList = new ArrayList();
            }
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (!attname.equals("context")) continue;
                String[] path = this.stringToArray(value);
                String[] parentContext = null;
                if (this.openedContextList.size() > 0) {
                    parentContext = (String[])this.openedContextList.get(this.openedContextList.size() - 1);
                }
                this.addOpenedContexts(parentContext, path);
                this.openedContextList.add(path);
            }
        }

        private void manageProcessesInfo(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (!attname.equals("lastOpenedProcesses")) continue;
                StringTokenizer st = new StringTokenizer(value, ";");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    ProcessLocationData data = this.parseProcessData(s);
                    if (data == null) continue;
                    DesignerProjectPreferences.this.getLastOpenedProcesses().put(data.getLocation(), data);
                }
            }
        }

        private void manageSelectedViewInfo(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (!attname.equals("selectedPath")) continue;
                String[] path = this.stringToArray(value);
                this.selectedPathList.add(path);
            }
        }

        private ProcessLocationData parseProcessData(String parseableString) {
            Process process;
            ProcessLocationData data = new ProcessLocationData();
            StringTokenizer st = new StringTokenizer(parseableString, ",");
            if (st.hasMoreTokens()) {
                data.setLocation(Path.PROCESSES.create(st.nextToken()));
            }
            if (st.hasMoreTokens()) {
                data.setScale(Float.valueOf(st.nextToken()).floatValue());
            }
            return (process = DesignerProjectPreferences.this.project.findProcess(FileUtils.removeExtension(data.getLocation().getName()))) != null ? data : null;
        }

        private String[] stringToArray(String value) {
            StringTokenizer st = new StringTokenizer(value, ";");
            int size = st.countTokens();
            String[] path = new String[size];
            int pathI = 0;
            while (st.hasMoreTokens()) {
                path[pathI++] = st.nextToken();
            }
            return path;
        }
    }
}

