/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.preferences;

import java.io.File;
import java.io.FileInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.preferences.ToolBarMode;
import oracle.bpm.designer.preferences.ToolBarOrientation;
import oracle.bpm.draw.ActivityTitle;
import oracle.bpm.draw.TransitionMessageType;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.preferences.ReportPreferencesConstants;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.log.Log;
import oracle.bpm.project.importer.ImportRuleSet;
import oracle.bpm.project.model.LaneOrientation;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DesignerPreferencesLoader
implements ContentHandler,
ReportPreferencesConstants {
    private DesignerPreferences designerPreferences;
    private File file;
    private ImportRuleSet importRuleSet;
    private boolean isImportDrawing = false;
    private boolean isImportRules = false;
    private boolean isMessages = false;

    public DesignerPreferencesLoader(File f, DesignerPreferences pref) {
        this.file = f;
        this.designerPreferences = pref;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String local, String name) throws SAXException {
        if (this.isMessages && name.equals("messages")) {
            this.isMessages = false;
        }
        if (this.isImportRules && "importRules".equals(name)) {
            this.isImportRules = false;
        }
        if (this.isImportDrawing && "importDrawingSettings".equals(name)) {
            this.isImportDrawing = false;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int start, int end) throws SAXException {
    }

    public void load() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader parser = sp.getXMLReader();
            parser.setContentHandler(this);
            parser.parse(new InputSource(new FileInputStream(this.file)));
        }
        catch (Exception e) {
            Log.logWarning(e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String local, String name, Attributes amap) throws SAXException {
        if ("general".equals(name)) {
            this.manageGeneralInfo(amap);
            return;
        }
        if ("view".equals(name)) {
            this.manageViewInfo(amap);
            return;
        }
        if (name.equals("messages")) {
            this.isMessages = true;
            this.manageMessagesInfo(amap);
        }
        if (this.isMessages && name.equals("hiddenMessage")) {
            this.manageHiddenMessageInfo(amap);
            return;
        }
        if ("file".equals(name)) {
            this.manageFileInfo(amap);
            return;
        }
        if ("activity".equals(name)) {
            this.manageActivityInfo(amap);
            return;
        }
        if ("group".equals(name)) {
            this.manageGroupInfo(amap);
            return;
        }
        if ("ribbon".equals(name)) {
            this.manageRibbonInfo(amap);
            return;
        }
        if ("transition".equals(name)) {
            this.manageTransitionInfo(amap);
            return;
        }
        if ("exception".equals(name)) {
            this.manageExceptionInfo(amap);
            return;
        }
        if ("print".equals(name)) {
            this.managePrintInfo(amap);
            return;
        }
        if ("report".equals(name)) {
            this.manageReportInfo(amap);
            return;
        }
        if ("theme".equals(name)) {
            this.manageThemeInfo(amap);
            return;
        }
        if ("presentation".equals(name)) {
            this.managePresentation(amap);
            return;
        }
        if ("documentation".equals(name)) {
            this.manageDocumentation(amap);
            return;
        }
        if ("toolbar".equals(name)) {
            this.manageToolBar(amap);
            return;
        }
        if ("runtime".equals(name)) {
            this.manageRuntime(amap);
            return;
        }
        if ("expression".equals(name)) {
            this.manageExpression(amap);
            return;
        }
        if ("cileditor".equals(name)) {
            this.manageCilEditorInfo(amap);
            return;
        }
        if ("importDrawing".equals(name) || "importDrawingSettings".equals(name)) {
            this.isImportDrawing = true;
            this.manageImportDrawing(amap);
            return;
        }
        if (this.isImportDrawing && "importRules".equals(name)) {
            this.isImportRules = true;
            this.manageImportRules(amap);
            return;
        }
        if (this.isImportRules && "rule".equals(name)) {
            this.importRuleSet.addRule(amap);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    protected void manageGeneralAttribute(String attname, String value) {
        if ("showDesignerIsAlreadyRunning".equals(attname)) {
            this.designerPreferences.setShowDesignerIsRunning(true);
        } else if ("lastWordsSearched".equals(attname)) {
            StringTokenizer st = new StringTokenizer(value, ";");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.trim().length() <= 0) continue;
                this.designerPreferences.getLastWordsFoundList().add(s);
            }
        } else if ("enableAutoRecovery".equals(attname)) {
            this.designerPreferences.setAutoSaveEnabled(true);
        } else if ("exceptionHandlingSelected".equals(attname)) {
            this.designerPreferences.setExceptionHandlingSelected(Boolean.valueOf(value));
        } else if (!"language".equals(attname)) {
            if (attname.equals("overwriteLogFileOnStartup")) {
                this.designerPreferences.setOverwriteLogFileOnStartup(Boolean.valueOf(value));
            } else if (attname.equals("showHiddenComponents")) {
                this.designerPreferences.setShowHiddenComponents(Boolean.valueOf(value));
            }
        }
    }

    private void manageActivityInfo(Attributes amap) {
        boolean viewSubProcess = false;
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if ("showPropertiesWhenAdding".equals(attname)) {
                this.designerPreferences.showPropertiesAutomaticallyWhenAddingActivity(Boolean.valueOf(value));
                continue;
            }
            if ("keepAddingMode".equals(attname)) {
                this.designerPreferences.setAddingActivityMode(Boolean.valueOf(value));
                continue;
            }
            if ("doubleClickShows".equals(attname)) {
                this.designerPreferences.setActivityDoubleClick(value);
                continue;
            }
            if ("messageType".equals(attname)) {
                ActivityTitle title = "name".equals(value) ? ActivityTitle.NAME_AS_TITLE : ("description".equals(value) ? ActivityTitle.DESC_AS_TITLE : ActivityTitle.valueOf((String)value));
                this.designerPreferences.setActivityTitleType(title);
                continue;
            }
            if ("showGrab".equals(attname)) {
                this.designerPreferences.setShowGrabActivities(Boolean.valueOf(value));
                continue;
            }
            if (!"viewSubProcess".equals(attname)) continue;
            viewSubProcess = Boolean.valueOf(value);
        }
        this.designerPreferences.setViewSubProcess(viewSubProcess);
    }

    private void manageCilEditorInfo(Attributes amap) {
        boolean autoPasteTemplates = false;
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if ("autoPasteTemplates".equals(attname)) {
                autoPasteTemplates = Boolean.valueOf(value);
            } else if ("bottomSplitSize".equals(attname)) {
                this.designerPreferences.getCilPreferences().setBottomSplitSize(Integer.valueOf(value).intValue());
            } else if ("lastBottomSplitSize".equals(attname)) {
                this.designerPreferences.getCilPreferences().setLastBottomSplitSize(Integer.valueOf(value).intValue());
            } else if ("topSplitSize".equals(attname)) {
                this.designerPreferences.getCilPreferences().setTopSplitSize(Integer.valueOf(value).intValue());
            } else if ("lastTopSplitSize".equals(attname)) {
                this.designerPreferences.getCilPreferences().setLastTopSplitSize(Integer.valueOf(value).intValue());
            } else if ("mainSplitSize".equals(attname)) {
                this.designerPreferences.getCilPreferences().setMainSplitSize(Integer.valueOf(value).intValue());
            } else if ("lastMainSplitSize".equals(attname)) {
                this.designerPreferences.getCilPreferences().setLastMainSplitSize(Integer.valueOf(value).intValue());
            } else if ("saveAndRestoreSplitPositions".equals(attname)) {
                this.designerPreferences.getCilPreferences().setSaveAndRestoreSplitPositions(Boolean.valueOf(value).booleanValue());
            } else if ("windowSize".equals(attname)) {
                StringTokenizer st = new StringTokenizer(value, ",");
                this.designerPreferences.getCilPreferences().setWinSize(Dimension.valueOf(Integer.parseInt(st.nextToken().trim()), Integer.parseInt(st.nextToken().trim())));
            } else if ("isArgumentEnabled".equals(attname)) {
                this.designerPreferences.getCilPreferences().setArgumentEnabled(Boolean.valueOf(value).booleanValue());
            } else if ("isLocalEnabled".equals(attname)) {
                this.designerPreferences.getCilPreferences().setLocalEnabled(Boolean.valueOf(value).booleanValue());
            } else if ("isPredefinedEnabled".equals(attname)) {
                this.designerPreferences.getCilPreferences().setPredefinedEnabled(Boolean.valueOf(value).booleanValue());
            } else if ("isProcessEnabled".equals(attname)) {
                this.designerPreferences.getCilPreferences().setProcessEnabled(Boolean.valueOf(value).booleanValue());
            }
            this.designerPreferences.getCilPreferences().setAutoPasteTemplates(autoPasteTemplates);
        }
    }

    private void manageDocumentation(Attributes amap) {
        String lastUsedDirectory = amap.getValue("lastUsedDirectory");
        if (lastUsedDirectory != null) {
            this.designerPreferences.setLastUsedDocumentationDir(new File(lastUsedDirectory));
        }
    }

    private void manageExceptionInfo(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if (!"showExceptions".equals(attname)) continue;
            this.designerPreferences.setShowExceptionTransitions(Boolean.valueOf(value));
        }
    }

    private void manageFileInfo(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if ("autorecoveryDelay".equals(attname)) {
                this.designerPreferences.setSaveDelay(Long.valueOf(value));
                continue;
            }
            if ("openLastProject".equals(attname) || !"defaultProjectHome".equals(attname)) continue;
            this.designerPreferences.setDefaultProjectHome(value);
        }
    }

    private void manageGeneralInfo(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            this.manageGeneralAttribute(attname, value);
        }
    }

    private void manageGroupInfo(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
        }
    }

    private void manageRibbonInfo(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if ("showLabelPref".equals(attname)) {
                this.designerPreferences.setShowLabelPref(Boolean.valueOf(value));
                continue;
            }
            if ("lastActivityRibbonSection".equals(attname)) {
                this.designerPreferences.setLastActivityRibbonSection(FlowFigureType.valueOf((String)value));
                continue;
            }
            if ("lastInteractiveRibbonSection".equals(attname)) {
                this.designerPreferences.setLastInteractiveRibbonSection(FlowFigureType.valueOf((String)value));
                continue;
            }
            if ("lastNotificationRibbonSection".equals(attname)) {
                this.designerPreferences.setLastNotificationRibbonSection(FlowFigureType.valueOf((String)value));
                continue;
            }
            if ("lastCatchRibbonSection".equals(attname)) {
                this.designerPreferences.setLastCatchRibbonSection(FlowFigureType.valueOf((String)value));
                continue;
            }
            if ("lastThrowRibbonSection".equals(attname)) {
                this.designerPreferences.setLastThrowRibbonSection(FlowFigureType.valueOf((String)value));
                continue;
            }
            if ("lastGatewayRibbonSection".equals(attname)) {
                this.designerPreferences.setLastGatewayRibbonSection(FlowFigureType.valueOf((String)value));
                continue;
            }
            if (!"lastArtifactsRibbonSection".equals(attname)) continue;
            this.designerPreferences.setLastArtifactsRibbonSection(value);
        }
    }

    private void manageHiddenMessageInfo(Attributes amap) {
        String msg = "";
        String msgValue = "";
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if (attname.equals("messageKey")) {
                msg = value;
                continue;
            }
            if (!attname.equals("messageValue")) continue;
            msgValue = value;
        }
        this.designerPreferences.addMessageHidden(msg, msgValue);
    }

    private void manageImportDrawing(Attributes amap) {
        String lastUsedPath = amap.getValue("lastUsedPath");
        this.designerPreferences.setImportDrawingLastUsedPath(new File(lastUsedPath));
    }

    private void manageImportRules(Attributes amap) {
        String source = amap.getValue("source");
        this.importRuleSet = ImportRuleSet.create();
        this.designerPreferences.setImportRules(source, this.importRuleSet);
    }

    private void manageMessagesInfo(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            boolean confirm = Boolean.valueOf(value);
            if ("showConfirmWhenDeletingCil".equals(attname)) {
                this.designerPreferences.setShowConfirmWhenDeletingCil(confirm);
                continue;
            }
            if ("showConfirmWhenDeletingProcess".equals(attname)) {
                this.designerPreferences.setShowConfirmationWhenDeletingProcess(confirm);
                continue;
            }
            if ("showConfirmWhenDeletingFolder".equals(attname)) {
                this.designerPreferences.setShowConfirmationWhenDeletingFolder(confirm);
                continue;
            }
            if ("confirmExternalResourceDeletion".equals(attname)) {
                this.designerPreferences.setConfirmExternalResourceDeletion(confirm);
                continue;
            }
            if ("showConfirmWhenReplacingActivityImplementation".equals(attname)) {
                this.designerPreferences.setShowConfirmWhenReplacingActivityImplementation(confirm);
                continue;
            }
            if ("confirmVariableDeletion".equals(attname)) {
                this.designerPreferences.setConfirmVariableDeletion(confirm);
                continue;
            }
            if (!"optimizeLanesOnAutolayout".equals(attname)) continue;
            this.designerPreferences.setOptimizeLanesOnAutoLayout(confirm);
        }
    }

    private void managePresentation(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if ("showImage".equals(attname)) {
                this.designerPreferences.setPresentationShowImage(Boolean.valueOf(value));
                continue;
            }
            if ("showGrid".equals(attname)) {
                this.designerPreferences.setPresentationShowGrid(Boolean.valueOf(value));
                continue;
            }
            if ("addUseOptions".equals(attname)) {
                this.designerPreferences.setPresentationAddUseOption(Boolean.valueOf(value));
                continue;
            }
            if ("presentationDroppableBgColor".equals(attname)) {
                this.designerPreferences.setPresentationDroppableBgColor(value);
                continue;
            }
            if ("presentationDroppableBorderColor".equals(attname)) {
                this.designerPreferences.setPresentationDroppableBorderColor(value);
                continue;
            }
            if ("presentationDropOverBgColor".equals(attname)) {
                this.designerPreferences.setPresentationDropOverBgColor(value);
                continue;
            }
            if ("presentationFocusableBorderColor".equals(attname)) {
                this.designerPreferences.setPresentationFocusableBorderColor(value);
                continue;
            }
            if ("presentationEditorCellSpacing".equals(attname)) {
                this.designerPreferences.setPresentationEditorCellSpacing(Integer.valueOf(value));
                continue;
            }
            if (!"presentationEditorCellPadding".equals(attname)) continue;
            this.designerPreferences.setPresentationEditorCellPadding(Integer.valueOf(value));
        }
    }

    private void managePrintInfo(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if ("pageSize".equals(attname)) {
                StringTokenizer st = new StringTokenizer(value, ",");
                double width = Double.parseDouble(st.nextToken().trim());
                double height = Double.parseDouble(st.nextToken().trim());
                this.designerPreferences.getDesignerPageFormat().setWidth(width);
                this.designerPreferences.getDesignerPageFormat().setHeight(height);
                continue;
            }
            if ("imageableX".equals(attname)) {
                this.designerPreferences.getDesignerPageFormat().setImageableX(Double.valueOf(value).doubleValue());
                continue;
            }
            if ("imageableY".equals(attname)) {
                this.designerPreferences.getDesignerPageFormat().setImageableY(Double.valueOf(value).doubleValue());
                continue;
            }
            if ("imageableWidth".equals(attname)) {
                this.designerPreferences.getDesignerPageFormat().setImageableWidth(Double.valueOf(value).doubleValue());
                continue;
            }
            if ("imageableHeight".equals(attname)) {
                this.designerPreferences.getDesignerPageFormat().setImageableHeight(Double.valueOf(value).doubleValue());
                continue;
            }
            if ("orientation".equals(attname)) {
                this.designerPreferences.getDesignerPageFormat().setOrientation(value);
                continue;
            }
            if ("printTransitionPage".equals(attname)) {
                this.designerPreferences.setPrintTransitionPage(Boolean.valueOf(value));
                continue;
            }
            if (!"completePageWithLastRole".equals(attname)) continue;
            this.designerPreferences.setCompletePageWithLastRole(Boolean.valueOf(value));
        }
    }

    private void manageReportInfo(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if (attname.equals("allwaysAskBeforeReport")) {
                this.designerPreferences.setReportShowOptionsBeforeGenerate(Boolean.valueOf(value));
                continue;
            }
            if (attname.equals("includeCilsInReport")) {
                this.designerPreferences.setIncludeCilsInReport(Boolean.valueOf(value));
                continue;
            }
            if (attname.equals("confirmOverwriteReports")) {
                this.designerPreferences.setConfirmBeforeOverwriteReports(Boolean.valueOf(value));
                continue;
            }
            if (attname.equals("includeVariablesInReport")) {
                this.designerPreferences.setIncludeVariablesInReport(Boolean.valueOf(value));
                continue;
            }
            if (!attname.equals("includeUseCaseDocumentationInReport")) continue;
            this.designerPreferences.setIncludeUseCaseDocumentationInReport(Boolean.valueOf(value));
        }
    }

    private void manageRuntime(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if (attname.equals("showEngineOptions")) {
                this.designerPreferences.setShowEngineOptionsBeforeStart(Boolean.valueOf(value));
                continue;
            }
            if (attname.equals("showEngineConfim")) {
                this.designerPreferences.setShowEngineConfirmBeforeStart(Boolean.valueOf(value));
                continue;
            }
            if (attname.equals("automaticallyApplyEngineChanges")) {
                this.designerPreferences.setAutomaticallyApplyEngineChanges(Boolean.valueOf(value));
                continue;
            }
            if (attname.equals("showApplyEngineChanges")) {
                this.designerPreferences.setShowApplyEngineChanges(Boolean.valueOf(value));
                continue;
            }
            if ("removeInstancesWhenStartingEngine".equals(attname)) {
                this.designerPreferences.setRemoveInstancesWhenStartingEngine(Boolean.valueOf(value));
                continue;
            }
            if ("removeLogFilesWhenStartingEngine".equals(attname)) {
                this.designerPreferences.setRemoveLogFilesWhenStartingEngine(Boolean.valueOf(value));
                continue;
            }
            if ("removeProcessesWhenPublishing".equals(attname)) {
                this.designerPreferences.setRemoveProcessesWhenPublishing(Boolean.valueOf(value));
                continue;
            }
            if (!"enableAsserts".equals(attname)) continue;
            this.designerPreferences.setEnableAsserts(Boolean.valueOf(value));
        }
    }

    private void manageExpression(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if (!attname.equals("expressionModeInDataAssociation")) continue;
            this.designerPreferences.setExpressionMode(ExpressionMode.fromId(value));
        }
    }

    private void manageThemeInfo(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if (!attname.equals("selectedDesignerTheme")) continue;
            this.designerPreferences.setTheme(DefaultTheme.getDefault());
        }
    }

    private void manageToolBar(Attributes amap) {
        String value = amap.getValue("actions");
        if (value != null && !"".equals(value)) {
            this.designerPreferences.setCustomToolBarActions(value.split(","));
        }
    }

    private void manageTransitionInfo(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if ("showPropertiesWhenAdding".equals(attname)) {
                this.designerPreferences.showPropertiesAutomaticallyWhenAddingTransition(Boolean.valueOf(value));
                continue;
            }
            if ("transitionMessageType".equals(attname)) {
                TransitionMessageType type;
                try {
                    type = TransitionMessageType.valueOf((String)value);
                }
                catch (IllegalArgumentException e) {
                    type = TransitionMessageType.CONDITION;
                }
                this.designerPreferences.setTransitionMessageType(type);
                continue;
            }
            if ("showGrab".equals(attname)) {
                this.designerPreferences.setShowGrabTransitions(Boolean.valueOf(value));
                continue;
            }
            if (!"ignoreShowPropertiesForUnconditional".equals(attname)) continue;
            this.designerPreferences.ignoreShowPropertiesForUnconditionalTransitions(Boolean.valueOf(value));
        }
    }

    private void manageViewInfo(Attributes amap) {
        Dimension d = Dimension.valueOf(-1, -1);
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if ("scale".equals(attname)) {
                this.designerPreferences.setScale(Float.valueOf(value).floatValue());
                if (!(this.designerPreferences.getScale() > 200.0f)) continue;
                this.designerPreferences.setScale(200.0f);
                continue;
            }
            if ("showGrid".equals(attname)) {
                this.designerPreferences.setShowGrid(Boolean.valueOf(value));
                continue;
            }
            if ("gridSize".equals(attname)) {
                int gridSize = Integer.parseInt(value);
                this.designerPreferences.setGridSize(gridSize);
                continue;
            }
            if ("snapToGrid".equals(attname)) {
                this.designerPreferences.setSnapToGrid(Boolean.valueOf(value));
                continue;
            }
            if ("showNotes".equals(attname)) {
                this.designerPreferences.setShowNotes(Boolean.valueOf(value));
                continue;
            }
            if ("openMemberEditor".equals(attname)) {
                this.designerPreferences.setOpenMemberEditor(Boolean.valueOf(value));
                continue;
            }
            if (attname.equals("defaultLanesOrientation")) {
                this.designerPreferences.setDefaultLanesOrientation(LaneOrientation.valueOf((String)value));
                continue;
            }
            if ("windowSizeHeight".equals(attname)) {
                int height = Integer.valueOf(value);
                d = Dimension.valueOf(d.getWidth(), height);
                continue;
            }
            if ("windowSizeWidth".equals(attname)) {
                int width = Integer.valueOf(value);
                d = Dimension.valueOf(width, d.getHeight());
                continue;
            }
            if ("windowLocationX".equals(attname) || "windowLocationY".equals(attname)) continue;
            if ("showGrabTransitions".equals(attname)) {
                this.designerPreferences.setShowGrabTransitions(Boolean.valueOf(value));
                continue;
            }
            if ("showConditionalTransitions".equals(attname)) {
                this.designerPreferences.setShowConditionalTransitions(Boolean.valueOf(value));
                continue;
            }
            if ("showUnconditionalTransitions".equals(attname)) {
                this.designerPreferences.setShowUnconditionalTransitions(Boolean.valueOf(value));
                continue;
            }
            if ("showDueTransitions".equals(attname)) {
                this.designerPreferences.setShowDueTransitions(Boolean.valueOf(value));
                continue;
            }
            if ("showTooltipsOnActivities".equals(attname)) {
                this.designerPreferences.setShowTooltipsOnActivities(Boolean.valueOf(value));
                continue;
            }
            if ("groupInheritedMembers".equals(attname)) {
                this.designerPreferences.setGroupInherited(Boolean.valueOf(value));
                continue;
            }
            if ("toolbarOrientation".equals(attname)) {
                ToolBarOrientation orientation;
                try {
                    orientation = ToolBarOrientation.valueOf(value);
                }
                catch (IllegalArgumentException e) {
                    orientation = ToolBarOrientation.RIGHT;
                }
                this.designerPreferences.setToolBarOrientation(orientation);
                continue;
            }
            if ("toolbarMode".equals(attname)) {
                this.designerPreferences.setToolBarMode(ToolBarMode.valueOf(value));
                continue;
            }
            if (attname.equals("autoLayout")) {
                this.designerPreferences.setAutoLayout(Boolean.valueOf(value));
                continue;
            }
            if (!attname.equals("routingType")) continue;
            this.designerPreferences.setTransitionDefaultRoutingMode(RoutingMode.valueOf((String)value));
        }
    }
}

