/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.preferences;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.designer.AppInfo;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.StudioApplicationInfo;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferencesLoader;
import oracle.bpm.designer.preferences.HighlightLevel;
import oracle.bpm.designer.preferences.ToolBarMode;
import oracle.bpm.designer.preferences.ToolBarOrientation;
import oracle.bpm.draw.ActivityTitle;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.TransitionMessageType;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.preferences.DesignerPageFormat;
import oracle.bpm.draw.preferences.ReportPreferencesConstants;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.editor.CodePreferences;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.Ref;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.log.Log;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.observers.ObjectRelationListener;
import oracle.bpm.observers.ObservableObject;
import oracle.bpm.print.PageFormat;
import oracle.bpm.print.PaperModel;
import oracle.bpm.project.importer.ImportRuleActivity;
import oracle.bpm.project.importer.ImportRuleSet;
import oracle.bpm.project.model.LaneOrientation;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.ui.HiddenMessagesPreferences;
import oracle.bpm.ui.Ui;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.xml.XmlWriter;
import org.jetbrains.annotations.NotNull;

public class DesignerPreferences
implements HiddenMessagesPreferences,
ReportPreferencesConstants,
ObservableObject {
    protected DesignerPageFormat dpf_d;
    private int activityDoubleClick_d = 1;
    private ActivityTitle activityTitleType = ActivityTitle.NAME_AS_TITLE;
    private boolean addingActivityMode_d;
    private boolean autoLayout;
    private boolean automaticallyApplyEngineChanges = false;
    private CodePreferences cilpref = new CodePreferences();
    private boolean completePageWithLastRole = false;
    private boolean confirmBeforeOverwriteReports = true;
    private boolean confirmExternalResourceDeletion = true;
    private boolean confirmVariableDeletion = true;
    private String[] customToolBarActions;
    private LaneOrientation defaultLanesOrientation = LaneOrientation.HORIZONTAL;
    private String defaultProjectHome;
    private HashSet<String> deferredProperties;
    private DefaultTheme designerTheme_d = null;
    private boolean enableAsserts = true;
    private boolean exceptionHandlingSelected;
    private ExpressionMode expressionMode = ExpressionMode.SIMPLE;
    private Ref<Integer> gridSize = Ref.createRef(10);
    private boolean groupInheritedMembers = true;
    private Map<String, String> hiddenMessages;
    private HighlightLevel highlight = HighlightLevel.getDefault();
    private boolean ignoreShowPropertiesForUnconditionalTransitions = true;
    private File importDrawingLastUsedPath_d;
    private Map<String, ImportRuleSet> importRulesForSource = new TreeMap<String, ImportRuleSet>();
    private boolean includeCilsInReport_d = true;
    private boolean includeUseCaseDocumentationInReport_d = true;
    private boolean includeVariablesInReport_d = true;
    private boolean isAutoSaveEnabled_d = false;
    private FlowFigureType lastActivityRibbonSection;
    private String lastArtifactsRibbonSection;
    private FlowFigureType lastCatchRibbonSection;
    private FlowFigureType lastGatewayRibbonSection;
    private FlowFigureType lastInteractiveRibbonSection;
    private FlowFigureType lastNotificationRibbonSection;
    private FlowFigureType lastThrowRibbonSection;
    private File lastUsedDocumentationDir;
    private List<String> lastWordsFoundList_d;
    private Map<String, List<ObjectPropertyListener>> observers = CollectionFactory.createMap();
    private boolean offerFlashInstallation = true;
    private boolean openMemberEditor = true;
    private boolean optimizeLanesOnAutoLayout = false;
    private boolean overwriteLogFileOnStartup = true;
    private boolean presentationAddUseOptions = false;
    private String presentationDropOverBgColor = "#52A4F4";
    private String presentationDroppableBgColor = "#C2FFBF";
    private String presentationDroppableBorderColor = "#0F6AD9";
    private int presentationEditorCellPadding = 4;
    private int presentationEditorCellSpacing = 4;
    private String presentationFocusableBorderColor = null;
    private boolean presentationShowGrid = true;
    private boolean presentationShowImage = false;
    private int printPreviewScale = 100;
    private boolean printTransitionPage_d = true;
    private Map<String, List<ObjectRelationListener>> relationObservers = CollectionFactory.createMap();
    private boolean removeInstancesWhenStartingEngine;
    private boolean removeLogFilesWhenStartingEngine;
    private boolean removeProcessesWhenPublishing;
    private boolean reportShowOptionsBeforeGenerate = true;
    private long saveDelay_d = 300000L;
    private float scale_d = 1.0f;
    private boolean showApplyEngineChanges = true;
    private boolean showConditionalTransitions_d = true;
    private boolean showConfirmationWhenDeletingFolder = true;
    private boolean showConfirmationWhenDeletingProcess_d = true;
    private boolean showConfirmWhenDeletingCil_d = true;
    private boolean showConfirmWhenReplacingActivityImplementation = true;
    private boolean showDesignerIsRunning_d = false;
    private boolean showDueTransitions_d = true;
    private boolean showEngineConfirmBeforeStart = true;
    private boolean showEngineOptionsBeforeStart = true;
    private boolean showEnginePropertiesWarning = true;
    private boolean showExceptionTransitions = true;
    private boolean showGrabActivities_d = true;
    private boolean showGrabTransitions_d = true;
    private boolean showGrid_d = false;
    private boolean showHiddenComponents = false;
    private boolean showLabelPref = true;
    private boolean showMeasurementMarks = true;
    private boolean showNotes = true;
    private boolean showPropertiesWhenAddingActivity_d = true;
    private boolean showPropertiesWhenAddingTransition_d = true;
    private boolean showTooltipsOnActivities = true;
    private boolean showUnconditionalTransitions_d = true;
    private ToolBarMode toolBarMode = ToolBarMode.ICON_AND_TEXT;
    private ToolBarOrientation toolbarOrientation = ToolBarOrientation.RIGHT;
    private RoutingMode transitionDefaultRoutingMode = RoutingMode.ORTHOGONAL;
    private TransitionMessageType transitionMessageType = TransitionMessageType.NAME;
    private boolean viewSubProcess_d = true;
    public static final int PROPERTIES_ON_DOUBLE_CLICK = 0;
    public static final int CILS_ON_DOUBLE_CLICK = 1;
    protected static final String MESSAGE_KEY = "messageKey";
    protected static final String MESSAGE_VALUE = "messageValue";
    public static final String OVERWRITE_LOG = "overwriteLogFileOnStartup";
    static final String SHOW_HIDDEN_COMPONENTS = "showHiddenComponents";
    private static DesignerPreferences designerPreferences;

    private DesignerPreferences() {
        if (!DesignerMode.isValid(2)) {
            this.setTransitionMessageType(TransitionMessageType.NAME);
        }
    }

    public static DesignerPreferences getPreferences() {
        if (designerPreferences == null) {
            designerPreferences = new DesignerPreferences();
            designerPreferences.load();
        }
        return designerPreferences;
    }

    public static void setPreferences(DesignerPreferences preferences) {
        designerPreferences = preferences;
    }

    public void setTransitionDefaultRoutingMode(RoutingMode transitionDefaultRoutingMode) {
        this.transitionDefaultRoutingMode = transitionDefaultRoutingMode;
    }

    public RoutingMode getTransitionDefaultRoutingMode() {
        return this.transitionDefaultRoutingMode;
    }

    public void setOptimizeLanesOnAutoLayout(boolean optimizeLanesOnAutolayout) {
        this.optimizeLanesOnAutoLayout = optimizeLanesOnAutolayout;
    }

    public boolean isAutoLayout() {
        return this.autoLayout;
    }

    public void setAutoLayout(boolean autoLayout) {
        this.autoLayout = autoLayout;
    }

    public ToolBarOrientation getToolbarOrientation() {
        return this.toolbarOrientation;
    }

    public HighlightLevel getHighlight() {
        return this.highlight;
    }

    public ExpressionMode getExpressionMode() {
        return this.expressionMode;
    }

    public void addImportRules(String source, ImportRuleSet importRules) {
        ImportRuleSet existenRules = this.getImportRules(source);
        if (existenRules != null) {
            existenRules.addAll(importRules);
            this.setImportRules(source, existenRules);
        } else {
            this.setImportRules(source, importRules);
        }
    }

    public void addMessageHidden(String messageCode, String newValue) {
        if (this.hiddenMessages == null) {
            this.hiddenMessages = new TreeMap<String, String>();
        }
        this.hiddenMessages.put(messageCode, newValue);
    }

    public boolean automaticallyApplyEngineChanges() {
        return this.automaticallyApplyEngineChanges;
    }

    public boolean enableAsserts() {
        return this.enableAsserts;
    }

    public int getActivityDoubleClick() {
        return this.activityDoubleClick_d;
    }

    public String getActivityDoubleClickString() {
        switch (this.activityDoubleClick_d) {
            case 0: {
                return "properties";
            }
        }
        return "cils";
    }

    public ActivityTitle getActivityTitleType() {
        return this.activityTitleType;
    }

    public String getActivityTitleTypeString() {
        return this.activityTitleType.getString();
    }

    public boolean getAddingActivityMode() {
        return this.addingActivityMode_d;
    }

    public EditorPreferences getCilEditorPreferences() {
        return EditorPreferences.getInstance();
    }

    public CodePreferences getCilPreferences() {
        return this.cilpref;
    }

    public boolean getConfirmExternalResourceDeletion() {
        return this.confirmExternalResourceDeletion;
    }

    public boolean getConfirmVariableDeletion() {
        return this.confirmVariableDeletion;
    }

    public boolean getOfferFlashInstallation() {
        return this.offerFlashInstallation;
    }

    public String[] getCustomToolBarActions() {
        if (this.customToolBarActions == null) {
            this.customToolBarActions = new String[0];
        }
        return this.customToolBarActions;
    }

    public String getDefaultProjectHome() {
        return this.defaultProjectHome;
    }

    public DesignerPageFormat getDesignerPageFormat() {
        if (this.dpf_d == null) {
            this.dpf_d = new DesignerPageFormat();
        }
        return this.dpf_d;
    }

    public LaneOrientation getDefaultLanesOrientation() {
        return this.defaultLanesOrientation;
    }

    public boolean isHorizontalOrientation() {
        return this.defaultLanesOrientation.equals((Object)LaneOrientation.HORIZONTAL);
    }

    public Ref<Integer> getGridSize() {
        return this.gridSize;
    }

    public boolean getGroupInherited() {
        return this.groupInheritedMembers;
    }

    public Iterator<String> getHiddenMessages() {
        if (this.hiddenMessages == null) {
            this.hiddenMessages = new TreeMap<String, String>();
        }
        return this.hiddenMessages.keySet().iterator();
    }

    public File getImportDrawingLastUsedPath() {
        return this.importDrawingLastUsedPath_d;
    }

    public ImportRuleSet getImportRules(String source) {
        return this.importRulesForSource.get(source);
    }

    public Iterator<String> getImportRulesKeys() {
        return this.importRulesForSource.keySet().iterator();
    }

    public boolean getIncludeCilsInReport() {
        return this.includeCilsInReport_d;
    }

    public boolean getIncludeUseCasesInReport() {
        return this.includeUseCaseDocumentationInReport_d;
    }

    public boolean getIncludeVariablesInReport() {
        return this.includeVariablesInReport_d;
    }

    public File getLastUsedDocumentationDir() {
        return this.lastUsedDocumentationDir;
    }

    public List<String> getLastWordsFoundList() {
        if (this.lastWordsFoundList_d == null) {
            this.lastWordsFoundList_d = new ArrayList<String>();
            this.lastWordsFoundList_d.add("");
        }
        return this.lastWordsFoundList_d;
    }

    public String getMessageValue(String messageCode) {
        if (this.hiddenMessages == null) {
            return null;
        }
        return this.hiddenMessages.get(messageCode);
    }

    public PageFormat getPageFormat(PageFormat pf) {
        if (this.dpf_d == null) {
            return pf;
        }
        pf.setOrientation(this.dpf_d.getOrientation());
        PaperModel p = new PaperModel();
        p.setSize(this.dpf_d.getWidth(), this.dpf_d.getHeight());
        p.setImageableArea(this.dpf_d.getImageableX(), this.dpf_d.getImageableY(), this.dpf_d.getImageableWidth(), this.dpf_d.getImageableHeight());
        pf.setPaper(p);
        return pf;
    }

    public int getPrintPreviewScale() {
        return this.printPreviewScale;
    }

    public boolean getPrintTransitionPage() {
        return this.printTransitionPage_d;
    }

    public boolean getReportShowOptionsBeforeGenerate() {
        return this.reportShowOptionsBeforeGenerate;
    }

    public long getSaveDelay() {
        return this.saveDelay_d;
    }

    public float getScale() {
        return this.scale_d;
    }

    public boolean getShowConditionalTransitions() {
        return this.showConditionalTransitions_d;
    }

    public boolean getShowConfirmationWhenDeletingFolder() {
        return this.showConfirmationWhenDeletingFolder;
    }

    public boolean getShowConfirmationWhenDeletingProcess() {
        return this.showConfirmationWhenDeletingProcess_d;
    }

    public boolean getShowConfirmWhenDeletingCil() {
        return this.showConfirmWhenDeletingCil_d;
    }

    public boolean getShowConfirmWhenReplacingActivityImplementation() {
        return this.showConfirmWhenReplacingActivityImplementation;
    }

    public boolean getShowDesignerIsRunning() {
        return this.showDesignerIsRunning_d;
    }

    public boolean getShowDueTransitions() {
        return this.showDueTransitions_d;
    }

    public boolean getShowExceptionTransitions() {
        return this.showExceptionTransitions;
    }

    public boolean getShowGrabActivities() {
        return this.showGrabActivities_d;
    }

    public boolean getShowGrabTransitions() {
        return this.showGrabTransitions_d;
    }

    public boolean getShowGrid() {
        return this.showGrid_d;
    }

    public boolean getShowNotes() {
        return this.showNotes;
    }

    public boolean getOpenMemberEditor() {
        return this.openMemberEditor;
    }

    public boolean getShowTooltipsOnActivities() {
        return this.showTooltipsOnActivities;
    }

    public boolean getShowUnconditionalTransitions() {
        return this.showUnconditionalTransitions_d;
    }

    public boolean getSnapToGrid() {
        return true;
    }

    public DefaultTheme getTheme() {
        return this.designerTheme_d == null ? DefaultTheme.getDefault() : this.designerTheme_d;
    }

    public TransitionMessageType getTransitionMessageType() {
        return this.transitionMessageType;
    }

    public boolean getViewSubProcess() {
        return this.viewSubProcess_d;
    }

    public boolean ignoreShowPropertiesForUnconditionalTransitions() {
        return this.ignoreShowPropertiesForUnconditionalTransitions;
    }

    public void ignoreShowPropertiesForUnconditionalTransitions(boolean selected) {
        this.ignoreShowPropertiesForUnconditionalTransitions = selected;
    }

    public boolean isAutoSaveEnabled() {
        return this.isAutoSaveEnabled_d;
    }

    public boolean isCompletePageWithLastRole() {
        return this.completePageWithLastRole;
    }

    public boolean isConfirmBeforeOverwriteReports() {
        return this.confirmBeforeOverwriteReports;
    }

    public boolean isExceptionHandlingSelected() {
        return this.exceptionHandlingSelected;
    }

    public boolean isMessageHidden(String messageCode) {
        return this.hiddenMessages != null && this.hiddenMessages.get(messageCode) != null;
    }

    public boolean isOverwriteLogFileOnStartup() {
        return this.overwriteLogFileOnStartup;
    }

    public boolean isPresentationAddUseOptions() {
        return this.presentationAddUseOptions;
    }

    public boolean isPresentationShowGrid() {
        return this.presentationShowGrid;
    }

    public boolean isPresentationShowImage() {
        return this.presentationShowImage;
    }

    public String getPresentationDroppableBgColor() {
        return this.presentationDroppableBgColor;
    }

    public String getPresentationDroppableBorderColor() {
        return this.presentationDroppableBorderColor;
    }

    public String getPresentationDropOverBgColor() {
        return this.presentationDropOverBgColor;
    }

    public String getPresentationFocusableBorderColor() {
        return this.presentationFocusableBorderColor;
    }

    public int getPresentationEditorCellSpacing() {
        return this.presentationEditorCellSpacing;
    }

    public void setPresentationEditorCellSpacing(int presentationEditorCellSpacing) {
        if (this.presentationEditorCellSpacing != presentationEditorCellSpacing) {
            this.presentationEditorCellSpacing = presentationEditorCellSpacing;
            this.deferredPropertyChanged("presentationEditorOptions");
        }
    }

    public int getPresentationEditorCellPadding() {
        return this.presentationEditorCellPadding;
    }

    public void setPresentationEditorCellPadding(int presentationEditorCellPadding) {
        if (this.presentationEditorCellPadding != presentationEditorCellPadding) {
            this.presentationEditorCellPadding = presentationEditorCellPadding;
            this.deferredPropertyChanged("presentationEditorOptions");
        }
    }

    public void setPresentationFocusableBorderColor(String presentationFocusableBorderColor) {
        if (!Any.equals(this.presentationFocusableBorderColor, presentationFocusableBorderColor)) {
            this.presentationFocusableBorderColor = presentationFocusableBorderColor;
            this.deferredPropertyChanged("presentationEditorOptions");
        }
    }

    public void setPresentationDropOverBgColor(String presentationDropOverBgColor) {
        if (!Any.equals(this.presentationDropOverBgColor, presentationDropOverBgColor)) {
            this.presentationDropOverBgColor = presentationDropOverBgColor;
            this.deferredPropertyChanged("presentationEditorOptions");
        }
    }

    public void setPresentationDroppableBorderColor(String presentationDroppableBorderColor) {
        if (!Any.equals(this.presentationDroppableBorderColor, presentationDroppableBorderColor)) {
            this.presentationDroppableBorderColor = presentationDroppableBorderColor;
            this.deferredPropertyChanged("presentationEditorOptions");
        }
    }

    public void setPresentationDroppableBgColor(String presentationDroppableBgColor) {
        if (!Any.equals(this.presentationDroppableBgColor, presentationDroppableBgColor)) {
            this.presentationDroppableBgColor = presentationDroppableBgColor;
            this.deferredPropertyChanged("presentationEditorOptions");
        }
    }

    public boolean isShowHiddenComponents() {
        return this.showHiddenComponents;
    }

    public boolean isShowMeasurementMarks() {
        return this.showMeasurementMarks;
    }

    public synchronized void load() {
        File f = DesignerPreferences.getPreferencesFileName();
        if (f.exists()) {
            new DesignerPreferencesLoader(f, this).load();
        } else {
            File oldFile = FuegoDirectories.homeRelativeFile("designerPreferences");
            if (oldFile.exists()) {
                new DesignerPreferencesLoader(oldFile, this).load();
            }
        }
    }

    public boolean removeHiddenMessage(String messageCode) {
        return this.hiddenMessages != null && messageCode != null && this.hiddenMessages.remove(messageCode) != null;
    }

    public boolean removeInstancesWhenStartingEngine() {
        return this.removeInstancesWhenStartingEngine;
    }

    public boolean removeLogFilesWhenStartingEngine() {
        return this.removeLogFilesWhenStartingEngine;
    }

    public boolean removeProcessesWhenPublishing() {
        return this.removeProcessesWhenPublishing;
    }

    public void setActivityDoubleClick(int what) {
        this.activityDoubleClick_d = what;
    }

    public void setActivityDoubleClick(String what) {
        if ("properties".equals(what)) {
            this.setActivityDoubleClick(0);
        } else if ("cils".equals(what)) {
            this.setActivityDoubleClick(1);
        } else {
            this.setActivityDoubleClick(0);
        }
    }

    public void setActivityTitleType(ActivityTitle type) {
        this.activityTitleType = type;
    }

    public void setAddingActivityMode(boolean b) {
        this.addingActivityMode_d = b;
    }

    public void setAutomaticallyApplyEngineChanges(boolean automaticallyApplyEngineChanges) {
        this.automaticallyApplyEngineChanges = automaticallyApplyEngineChanges;
    }

    public void setAutoSaveEnabled(boolean b) {
        this.isAutoSaveEnabled_d = b;
    }

    public void setCompletePageWithLastRole(boolean completePageWithLastRole) {
        this.completePageWithLastRole = completePageWithLastRole;
    }

    public void setConfirmBeforeOverwriteReports(boolean confirmBeforeOverwriteReports) {
        this.confirmBeforeOverwriteReports = confirmBeforeOverwriteReports;
    }

    public void setConfirmExternalResourceDeletion(boolean confirm) {
        this.confirmExternalResourceDeletion = confirm;
    }

    public void setConfirmVariableDeletion(boolean confirm) {
        this.confirmVariableDeletion = confirm;
    }

    public void setOfferFlashInstallation(boolean confirm) {
        this.offerFlashInstallation = confirm;
    }

    public void setCustomToolBarActions(String[] customToolBarActions) {
        this.customToolBarActions = customToolBarActions;
    }

    public void setDefaultProjectHome(String defaultProjectHome) {
        this.defaultProjectHome = defaultProjectHome;
    }

    public void setDefaultLanesOrientation(LaneOrientation defaultLanesOrientation) {
        if (!this.defaultLanesOrientation.equals((Object)defaultLanesOrientation)) {
            this.defaultLanesOrientation = defaultLanesOrientation;
            this.firePropertyChanged("defaultLanesOrientation");
        }
    }

    public void setEnableAsserts(boolean enableAsserts) {
        this.enableAsserts = enableAsserts;
    }

    public void setExceptionHandlingSelected(boolean exceptionHandlingSelected) {
        this.exceptionHandlingSelected = exceptionHandlingSelected;
    }

    public void setGridSize(int value) {
        this.gridSize.set(Math.min(48, Math.max(12, value)));
    }

    public void setGroupInherited(boolean doGroup) {
        this.groupInheritedMembers = doGroup;
    }

    public void setImportDrawingLastUsedPath(File path) {
        this.importDrawingLastUsedPath_d = path;
    }

    public void setImportRules(String source, ImportRuleSet importRules) {
        this.importRulesForSource.put(source, importRules);
    }

    public void setIncludeCilsInReport(boolean includeCilsInReport) {
        this.includeCilsInReport_d = includeCilsInReport;
    }

    public void setIncludeUseCaseDocumentationInReport(boolean val) {
        this.includeUseCaseDocumentationInReport_d = val;
    }

    public void setIncludeVariablesInReport(boolean includeVariablesInReport) {
        this.includeVariablesInReport_d = includeVariablesInReport;
    }

    public void setLastUsedDocumentationDir(File documentationOutputDirectory) {
        this.lastUsedDocumentationDir = documentationOutputDirectory;
    }

    public void setOverwriteLogFileOnStartup(boolean overwriteLogFileOnStartup) {
        this.overwriteLogFileOnStartup = overwriteLogFileOnStartup;
    }

    public void setPageFormat(PageFormat pf) {
        if (this.dpf_d == null) {
            this.dpf_d = new DesignerPageFormat();
        }
        this.dpf_d.setOrientation(pf.getOrientation());
        this.dpf_d.setWidth(pf.getPaper().getWidth());
        this.dpf_d.setHeight(pf.getPaper().getHeight());
        this.dpf_d.setImageableX(pf.getPaper().getImageableX());
        this.dpf_d.setImageableY(pf.getPaper().getImageableY());
        this.dpf_d.setImageableWidth(pf.getPaper().getImageableWidth());
        this.dpf_d.setImageableHeight(pf.getPaper().getImageableHeight());
    }

    public void setPresentationAddUseOption(boolean presentationAddUseOptions) {
        this.presentationAddUseOptions = presentationAddUseOptions;
    }

    public void setPresentationShowGrid(boolean presentationShowGrid) {
        this.presentationShowGrid = presentationShowGrid;
    }

    public void setPresentationShowImage(boolean presentationShowImage) {
        this.presentationShowImage = presentationShowImage;
    }

    public void setPrintPreviewScale(int printPreviewScale) {
        this.printPreviewScale = printPreviewScale;
    }

    public void setPrintTransitionPage(boolean printTransitionPage) {
        this.printTransitionPage_d = printTransitionPage;
    }

    public void setRemoveInstancesWhenStartingEngine(boolean removeInstancesWhenStartingEngine) {
        this.removeInstancesWhenStartingEngine = removeInstancesWhenStartingEngine;
    }

    public void setRemoveLogFilesWhenStartingEngine(boolean removeLogFilesWhenStartingEngine) {
        this.removeLogFilesWhenStartingEngine = removeLogFilesWhenStartingEngine;
    }

    public void setRemoveProcessesWhenPublishing(boolean removeProcessesWhenPublishing) {
        this.removeProcessesWhenPublishing = removeProcessesWhenPublishing;
    }

    public void setReportShowOptionsBeforeGenerate(boolean value) {
        this.reportShowOptionsBeforeGenerate = value;
    }

    public void setSaveDelay(long millis) {
        this.saveDelay_d = millis;
    }

    public void setScale(float scale) {
        this.scale_d = scale;
    }

    public void setShowApplyEngineChanges(boolean showApplyEngineChanges) {
        this.showApplyEngineChanges = showApplyEngineChanges;
    }

    public void setShowEnginePropertiesWarning(boolean showEnginePropertiesWarning) {
        this.showEnginePropertiesWarning = showEnginePropertiesWarning;
    }

    public void setShowConditionalTransitions(boolean showCond) {
        this.showConditionalTransitions_d = showCond;
    }

    public void setShowConfirmationWhenDeletingFolder(boolean b) {
        this.showConfirmationWhenDeletingFolder = b;
    }

    public void setShowConfirmationWhenDeletingProcess(boolean b) {
        this.showConfirmationWhenDeletingProcess_d = b;
    }

    public void setShowConfirmWhenDeletingCil(boolean showConfirmWhenDeletingCil) {
        this.showConfirmWhenDeletingCil_d = showConfirmWhenDeletingCil;
    }

    public void setShowConfirmWhenReplacingActivityImplementation(boolean showConfirmWhenReplacingActivityImplementation) {
        this.showConfirmWhenReplacingActivityImplementation = showConfirmWhenReplacingActivityImplementation;
    }

    public void setShowDesignerIsRunning(boolean b) {
        this.showDesignerIsRunning_d = b;
    }

    public void setShowDueTransitions(boolean showDue) {
        this.showDueTransitions_d = showDue;
    }

    public void setShowEngineConfirmBeforeStart(boolean show) {
        this.showEngineConfirmBeforeStart = show;
    }

    public void setShowEngineOptionsBeforeStart(boolean show) {
        this.showEngineOptionsBeforeStart = show;
    }

    public void setShowExceptionTransitions(boolean b) {
        this.showExceptionTransitions = b;
    }

    public void setShowGrabActivities(boolean showGrab) {
        this.showGrabActivities_d = showGrab;
    }

    public void setShowGrabTransitions(boolean showGrab) {
        this.showGrabTransitions_d = showGrab;
    }

    public void setShowGrid(boolean b) {
        this.showGrid_d = b;
        this.deferredPropertyChanged(DesignerMsg.SHOWGRID.getString());
    }

    public void setShowHiddenComponents(boolean showHiddenComponents) {
        this.showHiddenComponents = showHiddenComponents;
    }

    public void setShowMeasurementMarks(boolean showMeasurementMarks) {
        this.showMeasurementMarks = showMeasurementMarks;
    }

    public void setShowNotes(boolean showNotes) {
        this.showNotes = showNotes;
    }

    public void setOpenMemberEditor(boolean openMemberEditor) {
        this.openMemberEditor = openMemberEditor;
    }

    public void setShowTooltipsOnActivities(boolean showTooltipsOnActivities) {
        this.showTooltipsOnActivities = showTooltipsOnActivities;
    }

    public void setShowUnconditionalTransitions(boolean showUncond) {
        this.showUnconditionalTransitions_d = showUncond;
    }

    public void setSnapToGrid(boolean b) {
    }

    public void setTheme(DefaultTheme theme) {
        boolean changed = !Any.equals(this.designerTheme_d, theme);
        DefaultTheme defaultTheme = this.designerTheme_d = theme == null ? DefaultTheme.getDefault() : theme;
        if (changed) {
            this.firePropertyChanged("selectedDesignerTheme");
        }
    }

    public void setTransitionMessageType(TransitionMessageType transitionMessageType) {
        this.transitionMessageType = transitionMessageType;
    }

    public void setViewSubProcess(boolean b) {
        this.viewSubProcess_d = b;
    }

    public boolean showApplyEngineChanges() {
        return this.showApplyEngineChanges;
    }

    public boolean showEnginePropertiesWarning() {
        return this.showEnginePropertiesWarning;
    }

    public boolean showEngineConfirmBeforeStart() {
        return this.showEngineConfirmBeforeStart;
    }

    public boolean showEngineOptionsBeforeStart() {
        return this.showEngineOptionsBeforeStart;
    }

    public boolean showPropertiesAutomaticallyWhenAddingActivity() {
        return this.showPropertiesWhenAddingActivity_d;
    }

    public void showPropertiesAutomaticallyWhenAddingActivity(boolean show) {
        this.showPropertiesWhenAddingActivity_d = show;
    }

    public boolean showPropertiesAutomaticallyWhenAddingTransition() {
        return this.showPropertiesWhenAddingTransition_d;
    }

    public void showPropertiesAutomaticallyWhenAddingTransition(boolean show) {
        this.showPropertiesWhenAddingTransition_d = show;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store() {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(DesignerPreferences.getPreferencesFileName());
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, Literals.DEFAULT_ENCODING);
            this.writeXML(writer);
            writer.flush();
        }
        catch (IOException e) {
            Log.logWarning(e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ignore) {
                    Log.logWarning(ignore);
                }
            }
        }
        this.getCilEditorPreferences().store();
        this.fireDeferredProperties();
    }

    public void updateContext(DrawContext drawContext) {
        drawContext.setShowConditionalTransitions(this.getShowConditionalTransitions());
        drawContext.setShowUnconditionalTransitions(this.getShowUnconditionalTransitions());
        drawContext.setShowDueTransitions(this.getShowDueTransitions());
        drawContext.setShowGrabActivities(this.getShowGrabActivities());
        drawContext.setShowGrabTransitions(this.getShowGrabTransitions());
        drawContext.setShowGrid(this.getShowGrid());
        drawContext.setShowNotes(this.getShowNotes());
        drawContext.setShowExceptionTransitions(this.getShowExceptionTransitions());
        drawContext.setShowMeasurementMarks(this.isShowMeasurementMarks());
        drawContext.setPageFormat(this.getPageFormat(new PageFormat()));
        drawContext.setCompletePageWithLastRole(this.isCompletePageWithLastRole());
        drawContext.setGroupInherited(this.getGroupInherited());
        drawContext.setTransitionMessageType(this.getTransitionMessageType());
        drawContext.setActivityTitleType(this.getActivityTitleType());
        drawContext.setTheme(this.getTheme());
    }

    public void writeXML(Writer writer) throws IOException {
        XmlWriter xmlWriter = new XmlWriter(writer, Literals.DEFAULT_ENCODING);
        xmlWriter.startDocument();
        xmlWriter.startElement("DesignerPreferences");
        xmlWriter.startElement("general");
        xmlWriter.printAttribute("enableAutoRecovery", this.isAutoSaveEnabled());
        xmlWriter.printAttribute("showDesignerIsAlreadyRunning", this.getShowDesignerIsRunning());
        xmlWriter.printAttribute("exceptionHandlingSelected", this.isExceptionHandlingSelected());
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute(OVERWRITE_LOG, this.isOverwriteLogFileOnStartup());
        xmlWriter.printAttribute(SHOW_HIDDEN_COMPONENTS, this.isShowHiddenComponents());
        xmlWriter.setIgnoreEmpty(true);
        String words = "";
        Iterator<String> wIt = this.getLastWordsFoundList().iterator();
        if (this.getLastWordsFoundList().size() > 1) {
            int endIndex;
            int i = 0;
            while (wIt.hasNext()) {
                String s = wIt.next();
                if ("".equals(s)) continue;
                String replaced = s.replace(';', ' ');
                words = words + replaced + ";";
                if (i++ <= 10) continue;
                break;
            }
            if ((endIndex = words.lastIndexOf(";")) > 0) {
                words = words.substring(0, endIndex);
            }
        }
        if (this.getLastWordsFoundList().size() == 1) {
            words = this.getLastWordsFoundList().get(0);
            words = words.replace(';', ' ');
        }
        xmlWriter.printAttribute("lastWordsSearched", words);
        xmlWriter.endElement();
        xmlWriter.startElement("view");
        xmlWriter.printAttribute("scale", this.getScale());
        xmlWriter.printAttribute("showGrid", this.getShowGrid());
        xmlWriter.printAttribute("gridSize", this.getGridSize().get());
        xmlWriter.printAttribute("snapToGrid", this.getSnapToGrid());
        xmlWriter.printAttribute("defaultLanesOrientation", (Enum)this.getDefaultLanesOrientation());
        xmlWriter.printAttribute("toolbarOrientation", this.getToolbarOrientation());
        xmlWriter.printAttribute("toolbarMode", this.getToolBarMode());
        xmlWriter.printAttribute("showGrabTransitions", this.getShowGrabTransitions());
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("showConditionalTransitions", this.getShowConditionalTransitions());
        xmlWriter.printAttribute("showUnconditionalTransitions", this.getShowUnconditionalTransitions());
        xmlWriter.printAttribute("showDueTransitions", this.getShowDueTransitions());
        xmlWriter.printAttribute("showTooltipsOnActivities", this.getShowTooltipsOnActivities());
        xmlWriter.printAttribute("groupInheritedMembers", this.getGroupInherited());
        xmlWriter.printAttribute("showNotes", this.getShowNotes());
        xmlWriter.printAttribute("openMemberEditor", this.getOpenMemberEditor());
        xmlWriter.printAttribute("autoLayout", this.isAutoLayout());
        xmlWriter.printAttribute("routingType", (Enum)this.getTransitionDefaultRoutingMode());
        xmlWriter.setIgnoreEmpty(true);
        xmlWriter.endElement();
        xmlWriter.startElement("file");
        xmlWriter.printAttribute("defaultProjectHome", this.getDefaultProjectHome());
        xmlWriter.printAttribute("autorecoveryDelay", this.getSaveDelay());
        xmlWriter.endElement();
        xmlWriter.startElement("messages");
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("showConfirmWhenDeletingCil", this.getShowConfirmWhenDeletingCil());
        xmlWriter.printAttribute("showConfirmWhenDeletingProcess", this.getShowConfirmationWhenDeletingProcess());
        xmlWriter.printAttribute("showConfirmWhenDeletingFolder", this.getShowConfirmationWhenDeletingFolder());
        xmlWriter.printAttribute("confirmExternalResourceDeletion", this.getConfirmExternalResourceDeletion());
        xmlWriter.printAttribute("confirmVariableDeletion", this.getConfirmVariableDeletion());
        xmlWriter.printAttribute("showConfirmWhenReplacingActivityImplementation", this.getShowConfirmWhenReplacingActivityImplementation());
        xmlWriter.printAttribute("optimizeLanesOnAutolayout", this.isOptimizeLanesOnAutoLayout());
        Iterator<String> iterator = this.getHiddenMessages();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                String msgKey = iterator.next();
                xmlWriter.startElement("hiddenMessage");
                xmlWriter.printAttribute(MESSAGE_KEY, msgKey);
                xmlWriter.printAttribute(MESSAGE_VALUE, this.getMessageValue(msgKey));
                xmlWriter.endElement();
            }
        }
        xmlWriter.endElement();
        xmlWriter.setIgnoreEmpty(true);
        xmlWriter.startElement("activity");
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("showPropertiesWhenAdding", this.showPropertiesAutomaticallyWhenAddingActivity());
        xmlWriter.printAttribute("ignoreShowPropertiesForUnconditional", this.ignoreShowPropertiesForUnconditionalTransitions());
        xmlWriter.setIgnoreEmpty(true);
        xmlWriter.printAttribute("keepAddingMode", this.getAddingActivityMode());
        xmlWriter.printAttribute("doubleClickShows", this.getActivityDoubleClickString());
        xmlWriter.printAttribute("messageType", (Enum)this.getActivityTitleType());
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("showGrab", this.getShowGrabActivities());
        xmlWriter.printAttribute("viewSubProcess", this.getViewSubProcess());
        xmlWriter.setIgnoreEmpty(true);
        xmlWriter.endElement();
        xmlWriter.startElement("group");
        xmlWriter.endElement();
        xmlWriter.startElement("ribbon");
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("showLabelPref", this.getShowLabelPref());
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("lastActivityRibbonSection", (Enum)this.getLastActivityRibbonSection());
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("lastArtifactsRibbonSection", this.getLastArtifactsRibbonSection());
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("lastCatchRibbonSection", (Enum)this.getLastCatchRibbonSection());
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("lastGatewayRibbonSection", (Enum)this.getLastGatewayRibbonSection());
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("lastInteractiveRibbonSection", (Enum)this.getLastInteractiveRibbonSection());
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("lastNotificationRibbonSection", (Enum)this.getLastNotificationRibbonSection());
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("lastThrowRibbonSection", (Enum)this.getLastThrowRibbonSection());
        xmlWriter.endElement();
        xmlWriter.startElement("transition");
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("showPropertiesWhenAdding", this.showPropertiesAutomaticallyWhenAddingTransition());
        xmlWriter.setIgnoreEmpty(true);
        xmlWriter.printAttribute("transitionMessageType", (Enum)this.getTransitionMessageType());
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("showGrab", this.getShowGrabTransitions());
        xmlWriter.setIgnoreEmpty(true);
        xmlWriter.endElement();
        xmlWriter.startElement("exception");
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("showExceptions", this.getShowExceptionTransitions());
        xmlWriter.setIgnoreEmpty(true);
        xmlWriter.endElement();
        xmlWriter.startElement("cileditor");
        xmlWriter.printAttribute("autoPasteTemplates", this.getCilPreferences().getAutoPasteTemplates());
        xmlWriter.printAttribute("bottomSplitSize", this.getCilPreferences().getBottomSplitSize());
        xmlWriter.printAttribute("lastBottomSplitSize", this.getCilPreferences().getLastBottomSplitSize());
        xmlWriter.printAttribute("topSplitSize", this.getCilPreferences().getTopSplitSize());
        xmlWriter.printAttribute("lastTopSplitSize", this.getCilPreferences().getLastTopSplitSize());
        xmlWriter.printAttribute("mainSplitSize", this.getCilPreferences().getMainSplitSize());
        xmlWriter.printAttribute("lastMainSplitSize", this.getCilPreferences().getLastMainSplitSize());
        xmlWriter.printAttribute("saveAndRestoreSplitPositions", this.getCilPreferences().getSaveAndRestoreSplitPositions());
        if (this.getCilPreferences().getWinSize() != null) {
            String sizeString = "" + this.getCilPreferences().getWinSize().getWidth() + "," + this.getCilPreferences().getWinSize().getHeight();
            xmlWriter.printAttribute("windowSize", sizeString);
        }
        xmlWriter.printAttribute("isArgumentEnabled", this.getCilPreferences().isArgumentEnabled());
        xmlWriter.printAttribute("isLocalEnabled", this.getCilPreferences().isLocalEnabled());
        xmlWriter.printAttribute("isPredefinedEnabled", this.getCilPreferences().isPredefinedEnabled());
        xmlWriter.printAttribute("isProcessEnabled", this.getCilPreferences().isProcessEnabled());
        xmlWriter.endElement();
        xmlWriter.startElement("print");
        String pageSize = this.getDesignerPageFormat().getWidth() + "," + this.getDesignerPageFormat().getHeight();
        xmlWriter.printAttribute("pageSize", pageSize);
        xmlWriter.printAttribute("imageableX", this.getDesignerPageFormat().getImageableX());
        xmlWriter.printAttribute("imageableY", this.getDesignerPageFormat().getImageableY());
        xmlWriter.printAttribute("imageableWidth", this.getDesignerPageFormat().getImageableWidth());
        xmlWriter.printAttribute("imageableHeight", this.getDesignerPageFormat().getImageableHeight());
        xmlWriter.printAttribute("orientation", this.getDesignerPageFormat().getOrientationString());
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("printTransitionPage", this.getPrintTransitionPage());
        xmlWriter.printAttribute("completePageWithLastRole", this.isCompletePageWithLastRole());
        xmlWriter.setIgnoreEmpty(true);
        xmlWriter.endElement();
        xmlWriter.startElement("report");
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("allwaysAskBeforeReport", this.getReportShowOptionsBeforeGenerate());
        xmlWriter.printAttribute("confirmOverwriteReports", this.isConfirmBeforeOverwriteReports());
        xmlWriter.printAttribute("includeCilsInReport", this.getIncludeCilsInReport());
        xmlWriter.printAttribute("includeVariablesInReport", this.getIncludeVariablesInReport());
        xmlWriter.printAttribute("includeUseCaseDocumentationInReport", this.getIncludeUseCasesInReport());
        xmlWriter.setIgnoreEmpty(true);
        xmlWriter.endElement();
        xmlWriter.startElement("theme");
        xmlWriter.printAttribute("selectedDesignerTheme", this.getTheme().getName());
        xmlWriter.endElement();
        Iterator<String> rulesIter = this.getImportRulesKeys();
        if (rulesIter.hasNext()) {
            xmlWriter.startElement("importDrawing");
            if (this.getImportDrawingLastUsedPath() != null) {
                xmlWriter.printAttribute("lastUsedPath", this.getImportDrawingLastUsedPath().getAbsolutePath());
            }
            while (rulesIter.hasNext()) {
                String source = rulesIter.next();
                xmlWriter.startElement("importRules");
                xmlWriter.printAttribute("source", source);
                ImportRuleSet importRules = this.getImportRules(source);
                String[] shapes = importRules.getShapes();
                ImportRuleActivity[] activities = importRules.getActivities();
                for (int i = 0; i < shapes.length; ++i) {
                    String shape = shapes[i];
                    xmlWriter.startElement("rule");
                    xmlWriter.printAttribute("shape", shape);
                    xmlWriter.printAttribute("activityType", activities[i].toString());
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.startElement("presentation");
        xmlWriter.printAttribute("showGrid", this.isPresentationShowGrid());
        xmlWriter.printAttribute("showImage", this.isPresentationShowImage());
        xmlWriter.printAttribute("addUseOptions", this.isPresentationAddUseOptions());
        xmlWriter.setIgnoreEmpty(true);
        xmlWriter.printAttribute("presentationDroppableBgColor", this.getPresentationDroppableBgColor());
        xmlWriter.printAttribute("presentationDroppableBorderColor", this.getPresentationDroppableBorderColor());
        xmlWriter.printAttribute("presentationDropOverBgColor", this.getPresentationDropOverBgColor());
        xmlWriter.printAttribute("presentationFocusableBorderColor", this.getPresentationFocusableBorderColor());
        xmlWriter.printAttribute("presentationEditorCellSpacing", this.getPresentationEditorCellSpacing());
        xmlWriter.printAttribute("presentationEditorCellPadding", this.getPresentationEditorCellPadding());
        xmlWriter.endElement();
        if (this.getLastUsedDocumentationDir() != null) {
            xmlWriter.startElement("documentation");
            xmlWriter.printAttribute("lastUsedDirectory", this.getLastUsedDocumentationDir().getAbsolutePath());
            xmlWriter.endElement();
        }
        xmlWriter.startElement("runtime");
        xmlWriter.printAttribute("removeInstancesWhenStartingEngine", this.removeInstancesWhenStartingEngine());
        xmlWriter.printAttribute("removeLogFilesWhenStartingEngine", this.removeLogFilesWhenStartingEngine());
        xmlWriter.printAttribute("removeProcessesWhenPublishing", this.removeProcessesWhenPublishing());
        xmlWriter.printAttribute("enableAsserts", this.enableAsserts());
        xmlWriter.printAttribute("automaticallyApplyEngineChanges", this.automaticallyApplyEngineChanges());
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("showEngineOptions", this.showEngineOptionsBeforeStart());
        xmlWriter.printAttribute("showApplyEngineChanges", this.showApplyEngineChanges());
        xmlWriter.printAttribute("showEngineConfim", this.showEngineConfirmBeforeStart());
        xmlWriter.printAttribute("showEnginePropertiesWarning", this.showEnginePropertiesWarning());
        xmlWriter.endElement();
        String[] actions = this.getCustomToolBarActions();
        if (actions != null) {
            xmlWriter.startElement("toolbar");
            xmlWriter.printAttribute("actions", actions.length > 0 ? Str.join(actions, ',') : "");
            xmlWriter.endElement();
        }
        xmlWriter.startElement("expression");
        xmlWriter.printAttribute("expressionModeInDataAssociation", this.getExpressionMode().getId());
        xmlWriter.endElement();
        xmlWriter.setIgnoreEmpty(true);
        xmlWriter.endElement();
    }

    public boolean isOptimizeLanesOnAutoLayout() {
        return this.optimizeLanesOnAutoLayout;
    }

    @Override
    public void addPropertyObserver(String propertyName, ObjectPropertyListener observer) {
        this.getPropertyObservers(propertyName).add(observer);
    }

    @Override
    public void removePropertyObserver(String propertyName, ObjectPropertyListener observer) {
        this.getPropertyObservers(propertyName).remove(observer);
    }

    @Override
    public void addRelationObserver(String relationPropertyName, ObjectRelationListener observer) {
        this.getRelationsObservers(relationPropertyName).add(observer);
    }

    @Override
    public void removeRelationObserver(String relationPropertyName, ObjectRelationListener observer) {
        this.getRelationsObservers(relationPropertyName).remove(observer);
    }

    public void setToolBarOrientation(ToolBarOrientation value) {
        this.toolbarOrientation = value;
    }

    public void setHighlight(@NotNull HighlightLevel highlight) {
        this.highlight = highlight;
        this.firePropertyChanged("highLightLevel");
    }

    public void setExpressionMode(@NotNull ExpressionMode expressionMode) {
        this.expressionMode = expressionMode;
    }

    public ToolBarMode getToolBarMode() {
        return this.toolBarMode;
    }

    public void setToolBarMode(ToolBarMode mode) {
        this.toolBarMode = mode;
    }

    public void setLastInteractiveRibbonSection(FlowFigureType lastInteractiveRibbonSection) {
        this.lastInteractiveRibbonSection = lastInteractiveRibbonSection;
    }

    public void setLastActivityRibbonSection(FlowFigureType lastActivityRibbonSection) {
        this.lastActivityRibbonSection = lastActivityRibbonSection;
    }

    public void setLastNotificationRibbonSection(FlowFigureType lastNotificationRibbonSection) {
        this.lastNotificationRibbonSection = lastNotificationRibbonSection;
    }

    public void setLastCatchRibbonSection(FlowFigureType lastCatchRibbonSection) {
        this.lastCatchRibbonSection = lastCatchRibbonSection;
    }

    public void setLastThrowRibbonSection(FlowFigureType lastThrowRibbonSection) {
        this.lastThrowRibbonSection = lastThrowRibbonSection;
    }

    public void setLastGatewayRibbonSection(FlowFigureType lastGatewayRibbonSection) {
        this.lastGatewayRibbonSection = lastGatewayRibbonSection;
    }

    public void setLastArtifactsRibbonSection(String lastArtifactsRibbonSection) {
        this.lastArtifactsRibbonSection = lastArtifactsRibbonSection;
    }

    public String getLastArtifactsRibbonSection() {
        return this.lastArtifactsRibbonSection;
    }

    public FlowFigureType getLastGatewayRibbonSection() {
        return this.lastGatewayRibbonSection;
    }

    public FlowFigureType getLastThrowRibbonSection() {
        return this.lastThrowRibbonSection;
    }

    public FlowFigureType getLastCatchRibbonSection() {
        return this.lastCatchRibbonSection;
    }

    public FlowFigureType getLastNotificationRibbonSection() {
        return this.lastNotificationRibbonSection;
    }

    public FlowFigureType getLastInteractiveRibbonSection() {
        return this.lastInteractiveRibbonSection;
    }

    public FlowFigureType getLastActivityRibbonSection() {
        return this.lastActivityRibbonSection;
    }

    public void setShowLabelPref(boolean b) {
        this.showLabelPref = b;
    }

    public boolean getShowLabelPref() {
        return this.showLabelPref;
    }

    protected void firePropertyChanged(String propertyName) {
        for (ObjectPropertyListener observer : this.getPropertyObservers(propertyName)) {
            observer.propertyChanged(this, propertyName);
        }
    }

    protected void fireRelationAdded(String relationName) {
        for (ObjectRelationListener observer : this.getRelationsObservers(relationName)) {
            observer.relationAdded(this, relationName);
        }
    }

    protected void fireRelationRemoved(String relationName) {
        for (ObjectRelationListener observer : this.getRelationsObservers(relationName)) {
            observer.relationRemoved(this, relationName);
        }
    }

    private static File getPreferencesFileName() {
        String preferencesFile;
        if (!Ui.isHeadless()) {
            if (AppInfo.getCurrent() == null) {
                AppInfo.setCurrent(new StudioApplicationInfo());
            }
            preferencesFile = AppInfo.getCurrent().getPreferencesFile();
        } else {
            preferencesFile = "default.preferences";
        }
        return FuegoDirectories.homeRelativeFile(preferencesFile);
    }

    private void deferredPropertyChanged(String propertyName) {
        if (this.deferredProperties == null) {
            this.deferredProperties = new HashSet();
        }
        this.deferredProperties.add(propertyName);
    }

    private void fireDeferredProperties() {
        if (this.deferredProperties != null) {
            HashSet<String> currentProperties = this.deferredProperties;
            this.deferredProperties = null;
            for (String propertyName : currentProperties) {
                for (ObjectPropertyListener observer : this.getPropertyObservers(propertyName)) {
                    observer.propertyChanged(this, propertyName);
                }
            }
        }
    }

    private List<ObjectPropertyListener> getPropertyObservers(String propertyName) {
        if (!this.observers.containsKey(propertyName)) {
            this.observers.put(propertyName, CollectionFactory.createList());
        }
        return this.observers.get(propertyName);
    }

    private List<ObjectRelationListener> getRelationsObservers(String relationName) {
        if (!this.relationObservers.containsKey(relationName)) {
            this.relationObservers.put(relationName, CollectionFactory.createList());
        }
        return this.relationObservers.get(relationName);
    }
}

