/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.panels.builder;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.designer.panels.builder.EditableComponentPanel;
import oracle.bpm.designer.panels.builder.EditorPanelBuilder;
import oracle.bpm.draw.Color;
import oracle.bpm.lang.Cast;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;

public class RowPanelBuilder<E>
implements EditorPanelBuilder<E> {
    private List rows = new ArrayList();

    public static <E> RowPanelBuilder<E> create() {
        return new RowPanelBuilder<E>();
    }

    @Override
    public EditableComponent build(UiContainer parent, E element) {
        EditableComponentPanel<E> panel = new EditableComponentPanel<E>(parent, element);
        panel.setLayout((Layout)new MigLayout("fillx"));
        for (Object row : this.rows) {
            if (row instanceof Msg) {
                Label title = Label.createWithNoColon(panel, (Msg)((Msg)row));
                title.setForeground(Color.FUEGO_BLUE);
                panel.add((UiComponent)title, "wrap");
                continue;
            }
            RowInfo rowInfo = (RowInfo)row;
            EditableComponent editableComponent = rowInfo.getBuilder().build((UiContainer)panel, element);
            Msg label = rowInfo.getLabel();
            String constraints = "growx, wrap";
            if (label != null) {
                panel.add((UiComponent)Label.create(panel, (Msg)label));
            } else {
                constraints = "growx, span 2, wrap";
            }
            panel.add(editableComponent.getUiComponent(), constraints);
        }
        return panel;
    }

    public <E> RowPanelBuilder<E> addRowBuilder(Msg label, EditorPanelBuilder<E> panelBuilder) {
        return this.addRowBuilder(new RowInfo(label, panelBuilder));
    }

    public <E> RowPanelBuilder<E> addRowBuilder(EditorPanelBuilder<E> panelBuilder) {
        return this.addRowBuilder(null, panelBuilder);
    }

    public RowPanelBuilder addTitle(Msg title) {
        this.rows.add(title);
        return this;
    }

    private <E> RowPanelBuilder<E> addRowBuilder(RowInfo<E> rowInfo) {
        this.rows.add(rowInfo);
        return (RowPanelBuilder)Cast.force(this);
    }

    private static class RowInfo<E> {
        private EditorPanelBuilder<E> builder;
        private Msg label;

        private RowInfo(Msg label, EditorPanelBuilder<E> builder) {
            this.label = label;
            this.builder = builder;
        }

        public Msg getLabel() {
            return this.label;
        }

        public EditorPanelBuilder<E> getBuilder() {
            return this.builder;
        }
    }
}

