/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.panels.builder;

import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class EditableComponentPanel<E>
extends Panel
implements EditableComponent<E> {
    private E element;

    public EditableComponentPanel(@NotNull UiContainer parent, @NotNull E element) {
        this(parent, element, null);
    }

    public EditableComponentPanel(UiContainer parent, E element, Msg title) {
        super(parent, title);
        this.element = element;
    }

    @Override
    public void validateEditor() throws ProjectException {
        for (UiComponent component : this.getChildren()) {
            if (!(component instanceof EditableComponent)) continue;
            ((EditableComponent)component).validateEditor();
        }
    }

    @Override
    public void applyChanges() {
        for (UiComponent component : this.getChildren()) {
            if (!(component instanceof EditableComponent)) continue;
            ((EditableComponent)component).applyChanges();
        }
    }

    @Override
    public boolean isDirty() {
        for (UiComponent component : this.getChildren()) {
            EditableComponent editableComponent;
            if (!(component instanceof EditableComponent) || !(editableComponent = (EditableComponent)component).isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setElement(E element) {
        this.element = element;
        for (UiComponent component : this.getChildren()) {
            if (!(component instanceof EditableComponent)) continue;
            EditableComponent editableComponent = (EditableComponent)component;
            editableComponent.setElement(element);
        }
    }

    @Override
    public void populateValues() {
        for (UiComponent component : this.getChildren()) {
            if (!(component instanceof EditableComponent)) continue;
            EditableComponent editableComponent = (EditableComponent)component;
            editableComponent.populateValues();
        }
    }

    @Override
    public void loadValues() {
        for (UiComponent component : this.getChildren()) {
            if (!(component instanceof EditableComponent)) continue;
            EditableComponent editableComponent = (EditableComponent)component;
            editableComponent.loadValues();
        }
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public E getElement() {
        return this.element;
    }

    @Override
    public String getHelpId() {
        return "";
    }
}

