/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.action.organization.NewOrganizationalRoleAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.OrganizationBaseTablePanel;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.TableModel;

public class RolesTablePanel
extends OrganizationBaseTablePanel {
    private Organization organization;
    private ProjectListener<Role> roleProjectListener;
    private ProviderTableModel<Role> rolesTableModel;
    private static final MsgList COLUMN_IDENTIFIERS = MsgList.create(DesignerMsg.NAME, DesignerMsg.SHARE_ROLE);
    private static final int SHARE_ROLE_COLUMN = 1;

    private RolesTablePanel(UiContainer parent, TableModel model, Organization organization) {
        super(parent, DesignerMsg.ROLES, model);
        this.organization = organization;
        TableColumn shareRoleColumn = this.getTable().getColumn(1);
        shareRoleColumn.setToolTip(DesignerMsg.SHARE_ROLE_TOOL_TIP.getString());
        this.addRoleProjectListener();
    }

    protected void removeProjectListener() {
        this.organization.removeListener(this.roleProjectListener);
    }

    protected void addAction() {
        NewOrganizationalRoleAction newRoleAction = new NewOrganizationalRoleAction(this.organization, false);
        newRoleAction.run();
    }

    protected void selectionChanged(int[] selectedRows) {
        boolean enabled = true;
        for (int row : this.getTable().getSelectedRows()) {
            Role selectedRole = (Role)((RolesTableModel)this.getModel()).getRow(row);
            if (!selectedRole.isProcessOwner()) continue;
            enabled = false;
            break;
        }
        this.getRemoveAction().setEnabled(this.getTable().isEnabled() && selectedRows.length > 0 && enabled);
        this.getEditAction().setEnabled(this.getTable().isEnabled() && selectedRows.length == 1 && enabled);
    }

    private void addRoleProjectListener() {
        this.roleProjectListener = new ProjectListenerAdapter<Role>(Role.class){

            public void postObjectAdded(Role role, ProjectObject parent) {
                RolesTablePanel.this.rolesTableModel.addRow((Object)role);
            }

            public void postObjectRemoved(Role object, ProjectObject parent) {
                int rowIndex = RolesTablePanel.this.rolesTableModel.getRowIndex((Object)object);
                RolesTablePanel.this.rolesTableModel.removeRow(rowIndex);
            }
        };
        this.organization.addListener(this.roleProjectListener);
    }

    private static class RolesTableModel
    extends ProviderTableModel<Role> {
        public RolesTableModel(Sequence<Role> roles) {
            super(COLUMN_IDENTIFIERS);
            this.addRows(roles);
        }

        public Object getValueAt(int row, int column) {
            Role role = (Role)this.getRow(row);
            switch (column) {
                case 0: {
                    return role.getName();
                }
                case 1: {
                    return role.isShared();
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int column) {
            if (((Role)this.getRow(row)).isProcessOwner() && column == 1) {
                MessageDialog.showWarning((Msg)DesignerMsg.PROCESS_OWNER_ROLE_CANNOT_BE_SHARED);
            }
            return column == 1 && !((Role)this.getRow(row)).isProcessOwner();
        }

        public void setValueAt(Object value, int row, int column) {
            Role role = (Role)this.getRow(row);
            switch (column) {
                case 0: {
                    role.setName((String)value);
                }
                case 1: {
                    role.setShared(((Boolean)value).booleanValue());
                }
            }
        }
    }
}

