/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.ProjectObjectNameDialog;
import oracle.bpm.designer.action.organization.NewOrganizationalRoleAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.OrganizationBaseTablePanel;
import oracle.bpm.designer.organization.RolePanel;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.organization.EmptyRoleLabelValidator;
import oracle.bpm.designer.validator.organization.RoleExistenceValidator;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.organization.RoleImpl;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.TableModel;

public class RolesPanel
extends Panel {
    private Organization organization;
    private Panel roleDetailPanel;
    private CardLayout roleDetailPanelCardLayout;
    private RolePanel rolePanel;
    private ModificationListener rolePanelModificationListener;
    private ProjectListener<Role> roleProjectListener;
    private ProviderTableModel<Role> rolesTableModel;
    private RolesTablePanel rolesTablePanel;
    private static final String NO_ROLE_PANEL = "noRolePanel";
    private static final String ROLE_PANEL = "rolePanel";
    private static final int SHARE_ROLE_COLUMN = 1;

    public RolesPanel(UiContainer parent, Organization organization) {
        super(parent);
        this.organization = organization;
        this.buildUi();
        this.addRoleProjectListener();
    }

    public ModificationListener getRolePanelModificationListener() {
        if (this.rolePanelModificationListener == null) {
            this.rolePanelModificationListener = new ModificationListener(){

                public void objectModified(ModificationEvent event) {
                    RolesPanel.this.rolePanel.editorToObject();
                }
            };
        }
        return this.rolePanelModificationListener;
    }

    protected void onDispose() {
        this.organization.removeListener(this.roleProjectListener);
        this.rolePanel.removeProjectListener();
    }

    private void buildUi() {
        this.setLayout((Layout)new MigLayout("fill, gap 5, ins 5, wrap 1"));
        this.rolesTableModel = new RolesTableModel(this.organization.getRoles());
        SplitPane pane = new SplitPane((UiContainer)this, 0);
        this.rolesTablePanel = new RolesTablePanel((UiContainer)pane, (TableModel)this.rolesTableModel);
        Panel roleDetailPanel = this.buildRoleDetailPanel((UiContainer)pane);
        pane.setTopComponent((UiComponent)this.rolesTablePanel);
        pane.setBottomComponent((UiComponent)roleDetailPanel);
        pane.setResizeWeight(0.3);
        this.add((UiComponent)pane, "growx, growy ");
    }

    private void addRoleProjectListener() {
        this.roleProjectListener = new ProjectListenerAdapter<Role>(Role.class){

            public void postObjectAdded(Role role, ProjectObject parent) {
                RolesPanel.this.rolesTableModel.addRow((Object)role);
            }

            public void postObjectRemoved(Role object, ProjectObject parent) {
                int rowIndex = RolesPanel.this.rolesTableModel.getRowIndex((Object)object);
                RolesPanel.this.rolesTableModel.removeRow(rowIndex);
            }
        };
        this.organization.addListener(this.roleProjectListener);
    }

    private Panel buildRoleDetailPanel(UiContainer parent) {
        this.roleDetailPanel = new Panel(parent);
        this.roleDetailPanelCardLayout = new CardLayout();
        this.roleDetailPanel.setLayout((Layout)this.roleDetailPanelCardLayout);
        Label label = Label.createWithNoColon((UiContainer)this.roleDetailPanel, (Msg)DesignerMsg.NO_ROLE_SELECTED);
        label.setHorizontalAlignment(0);
        this.rolePanel = new RolePanel((UiContainer)this.roleDetailPanel, this.organization, null);
        this.rolePanel.addModificationListener(this.getRolePanelModificationListener());
        this.roleDetailPanel.add((UiComponent)label, (Object)NO_ROLE_PANEL);
        this.roleDetailPanel.add((UiComponent)this.rolePanel, (Object)ROLE_PANEL);
        this.roleDetailPanelCardLayout.show((UiContainer)this.roleDetailPanel, NO_ROLE_PANEL);
        return this.roleDetailPanel;
    }

    private class RolesTablePanel
    extends OrganizationBaseTablePanel {
        public RolesTablePanel(UiContainer parent, TableModel tableModel) {
            super(parent, DesignerMsg.ROLES, tableModel);
            TableColumn shareRoleColumn = this.getTable().getColumn(1);
            shareRoleColumn.setToolTip(DesignerMsg.SHARE_ROLE_TOOL_TIP.getString());
            this.getTable().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    int[] selectedRows = RolesTablePanel.this.getTable().getSelectedRows();
                    if (selectedRows.length == 1) {
                        RolesPanel.this.rolePanel.removeModificationListener(RolesPanel.this.getRolePanelModificationListener());
                        Role role = (Role)RolesTablePanel.this.getModel().getRow(selectedRows[0]);
                        RolesPanel.this.rolePanel.setProjectObject(role);
                        RolesPanel.this.rolePanel.objectToEditor();
                        RolesPanel.this.roleDetailPanelCardLayout.show((UiContainer)RolesPanel.this.roleDetailPanel, RolesPanel.ROLE_PANEL);
                        RolesPanel.this.rolePanel.addModificationListener(RolesPanel.this.getRolePanelModificationListener());
                    } else {
                        RolesPanel.this.roleDetailPanelCardLayout.show((UiContainer)RolesPanel.this.roleDetailPanel, RolesPanel.NO_ROLE_PANEL);
                    }
                }
            });
        }

        protected void addAction() {
            NewOrganizationalRoleAction newRoleAction = new NewOrganizationalRoleAction(RolesPanel.this.organization, false);
            newRoleAction.run();
        }

        protected void selectionChanged(int[] selectedRows) {
            boolean enabled = true;
            for (int row : this.getTable().getSelectedRows()) {
                Role selectedRole = (Role)((RolesTableModel)this.getModel()).getRow(row);
                if (!selectedRole.isProcessOwner()) continue;
                enabled = false;
                break;
            }
            this.getRemoveAction().setEnabled(this.getTable().isEnabled() && selectedRows.length > 0 && enabled);
            this.getEditAction().setEnabled(this.getTable().isEnabled() && selectedRows.length == 1 && enabled);
        }

        protected void deleteAction() {
            try {
                int[] selectedRows = this.getTable().getSelectedRows();
                List roleList = RolesPanel.this.rolesTableModel.getRows(selectedRows);
                for (Role selectedRole : roleList) {
                    this.checkLanelUsages(selectedRole);
                    RolesPanel.this.organization.removeChild((ProjectObject)selectedRole);
                }
                this.updateSelection(selectedRows);
            }
            catch (ProjectException e) {
                MessageDialog.showError((Msg)e.getMsg());
            }
        }

        protected boolean showEditAction() {
            return true;
        }

        protected void editAction() {
            RolesTableModel roleTableModel = (RolesTableModel)this.getModel();
            Role selectedRole = (Role)roleTableModel.getRow(this.getTable().getSelectedRow());
            if (selectedRole.isProcessOwner()) {
                MessageDialog.showWarning((Msg)DesignerMsg.UNEDITABLE_ROLE);
            } else {
                String oldName = selectedRole.getName();
                ProjectObjectNameDialog roleNameDialog = new ProjectObjectNameDialog(this.getParentWindow(), ProjectObjectType.ORGANIZATION_ROLE, oldName);
                roleNameDialog.setVisible(true);
                if (roleNameDialog.userAccepted()) {
                    String newName;
                    while (!oldName.equals(newName = roleNameDialog.getObjectName())) {
                        RoleImpl role = new RoleImpl(RolesPanel.this.organization, selectedRole.getId(), newName);
                        Msg msg = this.getRoleNameValidator().validate((Role)role);
                        if (msg == null) {
                            RolesPanel.this.rolePanel.setRoleName(newName);
                            RolesPanel.this.rolesTableModel.updateRow(roleTableModel.getRowIndex(selectedRole), (Object)selectedRole);
                            break;
                        }
                        MessageDialog.showError((Msg)msg);
                        roleNameDialog.setVisible(true);
                        if (roleNameDialog.userAccepted()) continue;
                    }
                    roleNameDialog.setVisible(false);
                }
            }
        }

        private void checkLanelUsages(Role selectedRole) throws ProjectException {
            for (Process process : RolesPanel.this.organization.getProject().getProcesses()) {
                for (Lane lane : process.getLanes()) {
                    if (!lane.getRole().equals(selectedRole.getId())) continue;
                    throw new ProjectException((ProjectObject)selectedRole, DesignerMsg.ROLE_HAS_USAGES(selectedRole.getId(), process.getName()));
                }
            }
        }

        private CompositeValidator<Role> getRoleNameValidator() {
            CompositeValidator<Role> compositeValidator = new CompositeValidator<Role>();
            compositeValidator.addValidator(new EmptyRoleLabelValidator(RolesPanel.this.organization.getProject()));
            compositeValidator.addValidator(new RoleExistenceValidator(RolesPanel.this.organization.getProject()));
            return compositeValidator;
        }
    }

    private class RolesTableModel
    extends ProviderTableModel<Role> {
        public RolesTableModel(Sequence<Role> roles) {
            super(MsgList.create(DesignerMsg.NAME, DesignerMsg.SHARE_ROLE));
            this.addRows(roles);
        }

        public Object getValueAt(int row, int column) {
            Role role = (Role)this.getRow(row);
            switch (column) {
                case 0: {
                    return role.getName();
                }
                case 1: {
                    return role.isShared();
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int column) {
            if (((Role)this.getRow(row)).isProcessOwner() && column == 1) {
                MessageDialog.showWarning((Msg)DesignerMsg.PROCESS_OWNER_ROLE_CANNOT_BE_SHARED);
            }
            return column == 1 && !((Role)this.getRow(row)).isProcessOwner();
        }

        public void setValueAt(Object value, int row, int column) {
            Role role = (Role)this.getRow(row);
            switch (column) {
                case 0: {
                    role.setName((String)value);
                    return;
                }
                case 1: {
                    role.setShared(((Boolean)value).booleanValue());
                    return;
                }
            }
        }
    }
}

