/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.identity.LookupMembersService;
import oracle.bpm.designer.identity.MembersLabelProvider;
import oracle.bpm.designer.identity.MembersPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.CalendarRuleAssignmentsPanel;
import oracle.bpm.designer.organization.OrgRolesDialog;
import oracle.bpm.designer.organization.OrganizationBasePanel;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.project.identity.ApplicationRoleImpl;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.identity.ApplicationRole;
import oracle.bpm.project.model.identity.Member;
import oracle.bpm.project.model.identity.MemberContainer;
import oracle.bpm.project.model.identity.MemberType;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.PotentialAssignee;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.organization.RoleEscalation;
import oracle.bpm.project.organization.PotentialAssigneeImpl;
import oracle.bpm.project.organization.RoleEscalationImpl;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.CompositeButton;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.action.DropDownAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RolePanel
extends OrganizationBasePanel<Role> {
    private CalendarRuleAssignmentsPanel calendarRuleAssignmentsTablePanel;
    private TextField escalationPathField;
    private CompositeButton escPathAppRolesBrowseCompButton;
    private Button escPathMembersBrowseButton;
    private ComboBox<MemberType> memberTypeCombo;
    private TextField nameField;
    private TextField potentialAssigneeField;
    private MembersPanel roleMembersPanel;

    public RolePanel(UiContainer parent, @NotNull Organization organization, Role role) {
        super(parent, organization, role, Role.class);
    }

    public Image getIcon() {
        return Image.create((Msg)DesignerMsg.ROLE);
    }

    public Role getRole() {
        return (Role)this.getProjectObject();
    }

    public EditorType getEditorType() {
        return EditorType.ROLE;
    }

    @Override
    public void buildUI(UiContainer parent) {
        this.setLayout((Layout)new MigLayout("fill"));
        Panel panel = new Panel(parent);
        Label nameLabel = Label.create((UiContainer)panel, (Msg)ProjectDrawMsg.NAME);
        this.nameField = new TextField((UiContainer)panel, LENGTH_TEXT);
        panel.setLayout((Layout)new MigLayout("wrap 2"));
        Panel escPathPanel = new Panel((UiContainer)panel);
        escPathPanel.setLayout((Layout)new MigLayout("fill, ins 0, gap 5"));
        this.memberTypeCombo = UiFactory.createComboBox((UiContainer)escPathPanel, (Object[])MemberType.values());
        this.memberTypeCombo.setLabelProvider((LabelProvider)new MembersLabelProvider());
        this.memberTypeCombo.setSelectedIndex(0);
        this.memberTypeCombo.addItemListener(this.getMemberTypeItemListener());
        this.escalationPathField = new TextField((UiContainer)escPathPanel);
        this.escPathMembersBrowseButton = Button.createBrowse((UiContainer)escPathPanel);
        this.escPathMembersBrowseButton.addActionListener(this.getBrowseMembersAction());
        this.escPathAppRolesBrowseCompButton = CompositeButton.createCompositeButton((UiContainer)escPathPanel);
        DropDownAction escPathDropDownAction = this.createApplicationRolesDropDownAction(this.escalationPathField, DesignerMsg.ADD_ESCALATION_PATH_ROLE, false);
        this.escPathAppRolesBrowseCompButton.setIcon(UIMsg.BROWSE);
        this.escPathAppRolesBrowseCompButton.setAction(this.getDefaultBrowseAction(this.escalationPathField));
        this.escPathAppRolesBrowseCompButton.setDropDownAction((BaseAction)escPathDropDownAction);
        this.escPathAppRolesBrowseCompButton.setEnabled(true);
        escPathPanel.add(this.memberTypeCombo);
        escPathPanel.add((UiComponent)this.escalationPathField);
        escPathPanel.add((UiComponent)this.escPathMembersBrowseButton, (Object)"hidemode 3");
        escPathPanel.add((UiComponent)this.escPathAppRolesBrowseCompButton, (Object)"hidemode 3");
        Panel potAssigneeFieldPanel = new Panel((UiContainer)panel);
        this.potentialAssigneeField = new TextField((UiContainer)potAssigneeFieldPanel);
        potAssigneeFieldPanel.setLayout((Layout)new MigLayout());
        potAssigneeFieldPanel.add((UiComponent)this.potentialAssigneeField);
        CompositeButton potAssigBrowseCompButton = CompositeButton.createCompositeButton((UiContainer)potAssigneeFieldPanel);
        DropDownAction potAssigDropDownAction = this.createApplicationRolesDropDownAction(this.potentialAssigneeField, DesignerMsg.ADD_POTENTIAL_ASSIGNEE_ROLE, true);
        potAssigBrowseCompButton.setIcon(UIMsg.BROWSE);
        potAssigBrowseCompButton.setAction(this.getDefaultBrowseAction(this.potentialAssigneeField));
        potAssigBrowseCompButton.setDropDownAction((BaseAction)potAssigDropDownAction);
        potAssigneeFieldPanel.add((UiComponent)potAssigBrowseCompButton);
        potAssigBrowseCompButton.setEnabled(true);
        panel.add((UiComponent)nameLabel, (Object)"");
        panel.add((UiComponent)this.nameField, (Object)"");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.ROLE_ESCALATION), (Object)"");
        panel.add((UiComponent)escPathPanel, (Object)"");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.POTENTIAL_ASSIGNEE), (Object)"");
        panel.add((UiComponent)potAssigneeFieldPanel);
        Panel memberMainPanel = new Panel(parent, DesignerMsg.MEMBERS);
        memberMainPanel.setLayout((Layout)new BorderLayout());
        this.roleMembersPanel = new MembersPanel((UiContainer)memberMainPanel);
        memberMainPanel.add((UiComponent)this.roleMembersPanel, (Object)"Center");
        Panel calendarsPanel = new Panel(parent, DesignerMsg.CALENDARS);
        calendarsPanel.setLayout((Layout)new BorderLayout());
        this.calendarRuleAssignmentsTablePanel = new CalendarRuleAssignmentsPanel(parent, this.getOrganization());
        calendarsPanel.add((UiComponent)this.calendarRuleAssignmentsTablePanel, (Object)"Center");
        this.add((UiComponent)panel, "spanx, wrap, grow");
        this.add((UiComponent)memberMainPanel, "spanx, wrap, grow, height 150");
        this.add((UiComponent)calendarsPanel, "spanx, wrap, grow, height 150");
    }

    public void editorToObject() {
        Role role = this.getRole();
        role.setName(this.getRoleName());
        try {
            String escalationRoleMember = this.escalationPathField.getText();
            if (!Str.isEmpty(escalationRoleMember)) {
                RoleEscalation roleEscalation = role.getRoleEscalation();
                if (roleEscalation == null) {
                    roleEscalation = new RoleEscalationImpl(this.getProject());
                    roleEscalation.setCreatedDate(new Date());
                } else {
                    roleEscalation.setLastUpdatedDate(new Date());
                    roleEscalation.removeChild(roleEscalation.getChildAt(0));
                }
                Member member = roleEscalation.createMember((MemberType)this.memberTypeCombo.getSelectedItem(), escalationRoleMember);
                roleEscalation.addMember(member);
                this.getRole().setRoleEscalation(roleEscalation);
            } else {
                this.getRole().setRoleEscalation(null);
            }
            String potentialAssigneeAppRole = this.potentialAssigneeField.getText();
            if (!Str.isEmpty(potentialAssigneeAppRole)) {
                try {
                    PotentialAssignee potentialAssignee = role.getPotentialAssignee();
                    if (potentialAssignee == null) {
                        potentialAssignee = new PotentialAssigneeImpl(this.getProject());
                        potentialAssignee.setCreatedDate(new Date());
                    } else {
                        potentialAssignee.setLastUpdatedDate(new Date());
                        potentialAssignee.removeChild(potentialAssignee.getChildAt(0));
                    }
                    ApplicationRoleImpl applicationRole = new ApplicationRoleImpl(potentialAssigneeAppRole, (ProjectObject)potentialAssignee);
                    potentialAssignee.addChild((ProjectObject)applicationRole);
                    this.getRole().setPotentialAssignee(potentialAssignee);
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                    MessageDialog.showError((Throwable)e);
                }
            } else {
                this.getRole().setPotentialAssignee(null);
            }
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
        }
        Collection<CalendarRuleAssignment> calendarRuleAssignments = this.calendarRuleAssignmentsTablePanel.getCalendarRulesAssignments();
        this.getRole().setCalendarRuleAssignment(calendarRuleAssignments);
    }

    @Override
    public String getTitle() {
        return this.getRole().getName();
    }

    public void setRoleName(String roleName) {
        this.nameField.setText(roleName);
    }

    public void removeProjectListener() {
        this.calendarRuleAssignmentsTablePanel.removeProjectListener();
    }

    protected void objectToEditor() {
        Role role = (Role)this.getProjectObject();
        this.nameField.setText(role.getName());
        this.nameField.setEnabled(false);
        if (role.getRoleEscalation() != null) {
            Member member = (Member)role.getRoleEscalation().getChildAt(0);
            this.escalationPathField.setText(member.getName());
            this.memberTypeCombo.setSelectedItem((Object)member.getType());
        } else {
            this.escalationPathField.setText("");
            this.memberTypeCombo.setSelectedIndex(0);
        }
        boolean isAppRoleSelected = this.memberTypeCombo.getSelectedItem() == MemberType.APPROLE;
        this.escPathAppRolesBrowseCompButton.setVisible(isAppRoleSelected);
        this.escPathMembersBrowseButton.setVisible(!isAppRoleSelected);
        if (role.getPotentialAssignee() != null) {
            ApplicationRole applicationRole = (ApplicationRole)role.getPotentialAssignee().getChildAt(0);
            this.potentialAssigneeField.setText(applicationRole.getName());
        } else {
            this.potentialAssigneeField.setText("");
        }
        this.roleMembersPanel.setMemberContainer((MemberContainer)role);
        this.calendarRuleAssignmentsTablePanel.setRole(role);
    }

    private BaseAction getDefaultBrowseAction(final TextField textField) {
        return new BaseAction(UIMsg.BROWSE){

            public void run() {
                RolePanel.this.getBrowseAppRolesFromIdentityManagerAction(textField).run();
            }
        };
    }

    private DropDownAction createApplicationRolesDropDownAction(TextField appRoleField, Msg browseDialogTitle, boolean includeCurrentRole) {
        ActionGroup actionGroup = new ActionGroup(UIMsg.BROWSE);
        actionGroup.add(this.getBrowseAppRolesFromIdentityManagerAction(appRoleField));
        actionGroup.add(this.getBrowseAppRolesFromOrganizationAction(appRoleField, browseDialogTitle, includeCurrentRole));
        return new DropDownAction(actionGroup);
    }

    private BaseAction getBrowseAppRolesFromOrganizationAction(final TextField appRoleField, final Msg browseDialogTitle, final boolean includeCurrentRole) {
        return new BaseAction(DesignerMsg.FROM_ORGANIZATION){

            public void run() {
                OrgRolesDialog orgRolesDialog = new OrgRolesDialog(Ui.getRoot(), RolePanel.this.getAvailableRoles(includeCurrentRole), browseDialogTitle);
                orgRolesDialog.setVisible(true);
                if (orgRolesDialog.userAccepted()) {
                    appRoleField.setText(orgRolesDialog.getSelectedRole().getName());
                }
            }
        };
    }

    private List<Role> getAvailableRoles(final boolean includeCurrentRole) {
        Sequence<Role> roleSequence = CollectionUtils.select(this.getOrganization().getRoles(), new Predicate<Role>(){

            @Override
            public boolean check(@Nullable Role value) {
                return includeCurrentRole && value.equals(RolePanel.this.getRole()) || !value.equals(RolePanel.this.getRole());
            }
        });
        return CollectionUtils.toList(roleSequence);
    }

    private BaseAction getBrowseAppRolesFromIdentityManagerAction(final TextField appRoleField) {
        return new BaseAction(DesignerMsg.FROM_IDENTITY_MANAGER){

            public void run() {
                LookupMembersService service = AbstractStudioWorkbench.getInstance().getLookupMembersService();
                if (service != null) {
                    Collection<Member> memberCollection = service.findMembers((MemberContainer)RolePanel.this.getProjectObject(), MemberType.APPROLE);
                    if (memberCollection.size() > 1) {
                        MessageDialog.showWarning((Msg)DesignerMsg.MORE_THAN_ONE_MEMBER_HAS_BEEN_CHOSEN);
                    }
                    if (memberCollection.size() == 1) {
                        Member member = memberCollection.iterator().next();
                        appRoleField.setText(member.getName());
                    }
                }
            }
        };
    }

    private ItemListener getMemberTypeItemListener() {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean isAppRoleSelected = RolePanel.this.memberTypeCombo.getSelectedItem() == MemberType.APPROLE;
                RolePanel.this.escPathAppRolesBrowseCompButton.setVisible(isAppRoleSelected);
                RolePanel.this.escPathMembersBrowseButton.setVisible(!isAppRoleSelected);
            }
        };
    }

    private ActionListener getBrowseMembersAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LookupMembersService service = AbstractStudioWorkbench.getInstance().getLookupMembersService();
                if (service != null) {
                    Collection<Member> memberCollection = service.findMembers((MemberContainer)RolePanel.this.getProjectObject(), (MemberType)RolePanel.this.memberTypeCombo.getSelectedItem());
                    if (memberCollection.size() > 1) {
                        MessageDialog.showWarning((Msg)DesignerMsg.MORE_THAN_ONE_MEMBER_HAS_BEEN_CHOSEN);
                    }
                    if (memberCollection.size() == 1) {
                        Member member = memberCollection.iterator().next();
                        RolePanel.this.escalationPathField.setText(member.getName());
                    }
                }
            }
        };
    }

    private String getRoleName() {
        return this.nameField.getText();
    }
}

