/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.ArrayList;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.ItemListener;

public class RoleDynamicName {
    private boolean includeAutomatic;
    private Process process;
    private ComboBox<String> rolesComboBox;

    public RoleDynamicName(UiContainer parent, Process project, boolean includeAutomatic) {
        this.process = project;
        this.includeAutomatic = includeAutomatic;
        this.rolesComboBox = UiFactory.createComboBox((UiContainer)parent, this.getRoleIds());
        LabelProvider.Default<String> labelProvider = new LabelProvider.Default<String>(){

            public String getText(String roleId) {
                Project project;
                Role role;
                String result = roleId;
                if (!LaneImpl.getAutomaticHandlerDisplayName().equals(roleId) && (role = (project = RoleDynamicName.this.getModel().getProject()).getOrganization().findRoleById(roleId)) != null) {
                    result = role.getName();
                }
                return result;
            }
        };
        this.rolesComboBox.setLabelProvider((LabelProvider)labelProvider);
    }

    public void addItemListener(ItemListener listener) {
        this.rolesComboBox.addItemListener(listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.rolesComboBox.removeItemListener(listener);
    }

    public void updateNames(String roleName) {
        this.rolesComboBox.removeAllItems();
        ArrayList<String> roleIds = this.getRoleIds();
        this.rolesComboBox.addItems(roleIds);
        this.rolesComboBox.setSelectedItem((Object)roleName);
    }

    public Process getModel() {
        return this.process;
    }

    public String getName() {
        String result = null;
        Object selectedItem = this.rolesComboBox.getSelectedItem();
        if (selectedItem != null) {
            result = LaneImpl.getAutomaticHandlerDisplayName().equals(selectedItem) ? "AutomaticHandler" : selectedItem.toString();
        }
        return result;
    }

    public UiComponent getUiComponent() {
        return this.rolesComboBox;
    }

    UiComponent getComponent() {
        return this.rolesComboBox;
    }

    void setEnabled(boolean enabled) {
        this.rolesComboBox.setEnabled(enabled);
    }

    void setText(final String text) {
        UiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                RoleDynamicName.this.rolesComboBox.setText(text);
            }
        });
    }

    void requestFocus() {
        this.rolesComboBox.requestFocus();
    }

    private ArrayList<String> getRoleIds() {
        ArrayList<String> roleIds = new ArrayList<String>();
        if (this.includeAutomatic) {
            roleIds.add(LaneImpl.getAutomaticHandlerDisplayName());
        }
        for (Role role : this.getModel().getProject().getOrganization().getRoles()) {
            roleIds.add(role.getId());
        }
        return roleIds;
    }
}

