/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.OrganizationalChartTreePanel;
import oracle.bpm.designer.organization.OrganizationalUnitMappingPanel;
import oracle.bpm.designer.organization.OrganizationalUnitPanel;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.tree.TreeNode;

public class OrganizationalUnitsPanel
extends Panel {
    private Organization organization;
    private OrganizationalChartTreePanel organizationalChartTreePanel;
    private Panel ouDetailPanel;
    private CardLayout ouDetailPanelCardLayout;
    private OrganizationalUnitMappingPanel ouMappingPanel;
    private OrganizationalUnitPanel ouPanel;
    private ModificationListener ouPanelModificationListener;
    private static final String NO_OU_PANEL = "noOuPanel";
    private static final String OU_PANEL = "ouPanel";

    public OrganizationalUnitsPanel(UiContainer parent, Organization organization) {
        super(parent);
        this.organization = organization;
        this.buildUi();
    }

    protected void onDispose() {
        this.organizationalChartTreePanel.setVisible(false);
        this.ouPanel.removeProjectListener();
        this.ouMappingPanel.removeProjectListener();
    }

    private void buildUi() {
        this.setLayout((Layout)new MigLayout("fill, gap 5, ins 5, wrap 1, hidemode 3"));
        SplitPane pane = new SplitPane((UiContainer)this, 0);
        Panel organizationalUnitsPanel = this.buildOrganizationalUnitsPanel((UiContainer)pane);
        Panel organizationalUnitDetailPanel = this.buildOrganizationalUnitDetailPanel((UiContainer)pane);
        pane.setTopComponent((UiComponent)organizationalUnitsPanel);
        pane.setBottomComponent((UiComponent)organizationalUnitDetailPanel);
        pane.setResizeWeight(0.3);
        this.add((UiComponent)pane, "growx, growy ");
    }

    private Panel buildOrganizationalUnitsPanel(UiContainer parent) {
        Panel ousPanel = new Panel(parent);
        ousPanel.setLayout((Layout)new MigLayout("fill, gap 5, ins 5, wrap 1, hidemode 3"));
        OrganizationalChart organizationalChart = this.organization.getOrganizationalChart();
        this.ouMappingPanel = new OrganizationalUnitMappingPanel((UiContainer)ousPanel, this.organization, organizationalChart);
        this.organizationalChartTreePanel = new OrganizationalChartTreePanel((UiContainer)ousPanel, null, organizationalChart);
        ousPanel.add((UiComponent)this.ouMappingPanel, (Object)"growx");
        ousPanel.add((UiComponent)this.organizationalChartTreePanel, (Object)"grow");
        return ousPanel;
    }

    private Panel buildOrganizationalUnitDetailPanel(UiContainer parent) {
        this.ouDetailPanel = new Panel(parent);
        this.ouDetailPanelCardLayout = new CardLayout();
        this.ouDetailPanel.setLayout((Layout)this.ouDetailPanelCardLayout);
        Label label = Label.createWithNoColon((UiContainer)this.ouDetailPanel, (Msg)DesignerMsg.NO_OU_SELECTED);
        label.setHorizontalAlignment(0);
        ScrollPane scroll = new ScrollPane((UiContainer)this.ouDetailPanel);
        this.ouPanel = new OrganizationalUnitPanel((UiContainer)scroll, this.organization, null);
        this.ouPanel.addModificationListener(this.getOuPanelModificationListener());
        scroll.setView((UiComponent)this.ouPanel);
        this.ouDetailPanel.add((UiComponent)label, (Object)NO_OU_PANEL);
        this.ouDetailPanel.add((UiComponent)scroll, (Object)OU_PANEL);
        this.ouDetailPanelCardLayout.show((UiContainer)this.ouDetailPanel, NO_OU_PANEL);
        this.organizationalChartTreePanel.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreeNode[] selectedNodes = OrganizationalUnitsPanel.this.organizationalChartTreePanel.getSelectedNode();
                if (selectedNodes.length == 1 && !selectedNodes[0].isRoot() && !((OrganizationalUnit)selectedNodes[0].getUserObject()).isRoot()) {
                    OrganizationalUnitsPanel.this.ouPanel.removeModificationListener(OrganizationalUnitsPanel.this.getOuPanelModificationListener());
                    OrganizationalUnitsPanel.this.ouPanel.setProjectObject((OrganizationalUnit)selectedNodes[0].getUserObject());
                    OrganizationalUnitsPanel.this.ouPanel.objectToEditor();
                    OrganizationalUnitsPanel.this.ouDetailPanelCardLayout.show((UiContainer)OrganizationalUnitsPanel.this.ouDetailPanel, OrganizationalUnitsPanel.OU_PANEL);
                    OrganizationalUnitsPanel.this.ouPanel.addModificationListener(OrganizationalUnitsPanel.this.getOuPanelModificationListener());
                } else {
                    OrganizationalUnitsPanel.this.ouDetailPanelCardLayout.show((UiContainer)OrganizationalUnitsPanel.this.ouDetailPanel, OrganizationalUnitsPanel.NO_OU_PANEL);
                }
            }
        });
        return this.ouDetailPanel;
    }

    private ModificationListener getOuPanelModificationListener() {
        if (this.ouPanelModificationListener == null) {
            this.ouPanelModificationListener = new ModificationListener(){

                public void objectModified(ModificationEvent event) {
                    if (OrganizationalUnitsPanel.this.ouPanel != null) {
                        OrganizationalUnitsPanel.this.ouPanel.editorToObject();
                    }
                }
            };
        }
        return this.ouPanelModificationListener;
    }
}

