/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.identity.MembersPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.OrganizationBasePanel;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.identity.MemberContainer;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.ui.events.UiProjectAdapter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class OrganizationalUnitPanel
extends OrganizationBasePanel<OrganizationalUnit> {
    private ComboBox<String> calendarComboBox;
    private UiProjectAdapter<CalendarRule> calendarRuleUiProjectListener;
    private TextArea descriptionArea;
    private MembersPanel membersPanel;
    private TextField nameField;

    public OrganizationalUnitPanel(UiContainer parent, @NotNull Organization organization, OrganizationalUnit ou) {
        super(parent, organization, ou, OrganizationalUnit.class);
        this.addCalendarRuleProjectListener();
    }

    public Image getIcon() {
        return Image.create((Msg)DesignerMsg.OUS);
    }

    public EditorType getEditorType() {
        return EditorType.ORGANIZATIONAL_UNIT;
    }

    public void removeProjectListener() {
        this.getOrganization().removeListener(this.calendarRuleUiProjectListener);
    }

    protected void editorToObject() {
        try {
            OrganizationalUnit.Mutable ou = ((OrganizationalUnit)this.getProjectObject()).asMutable();
            ou.setName(this.nameField.getText());
            ou.setDescription(this.descriptionArea.getText());
            String calendarId = (String)this.calendarComboBox.getSelectedItem();
            ou.asMutable().removeCalendarRuleAssignment();
            if (!CoreMsg.NONE.getString().equals(calendarId) && calendarId != null) {
                CalendarRule calendarRule = ou.getOrganization().findCalendarRule(calendarId);
                CalendarRuleAssignment.Mutable calendarRuleAssignment = ou.createCalendarRuleAssignment();
                if (calendarRule != null) {
                    calendarRuleAssignment.setCalendarRule(calendarRule);
                    calendarRuleAssignment.addRelation();
                } else {
                    calendarRuleAssignment.setCalendarRule(calendarId);
                    ou.addCalendarRuleAssignment((CalendarRuleAssignment)calendarRuleAssignment);
                }
            }
        }
        catch (Throwable t) {
            MessageDialog.showError((Throwable)t.getCause());
        }
    }

    protected void objectToEditor() {
        OrganizationalUnit ou = (OrganizationalUnit)this.getProjectObject();
        if (ou == null) {
            return;
        }
        this.nameField.setText(ou.getName());
        this.descriptionArea.setText(ou.getDescription());
        this.descriptionArea.requestFocus();
        String selectedItem = ou.getCalendarRuleAssignment() != null ? (ou.getCalendarRuleAssignment().getCalendarRule() != null ? ou.getCalendarRuleAssignment().getCalendarRule().getId() : ou.getCalendarRuleAssignment().getCalendarRuleId()) : CoreMsg.NONE.getString();
        this.calendarComboBox.setSelectedItem((Object)selectedItem);
        this.membersPanel.setMemberContainer((MemberContainer)ou);
    }

    @Override
    protected void buildUI(UiContainer parent) {
        Label nameLabel = Label.create((UiContainer)parent, (Msg)ProjectDrawMsg.NAME);
        this.nameField = new TextField(parent, LENGTH_TEXT);
        Label descriptionLabel = Label.create((UiContainer)parent, (Msg)DesignerMsg.DESCRIPTION);
        this.descriptionArea = new TextArea(parent, ScrollPolicy.AS_NEEDED, ScrollPolicy.NEVER);
        this.descriptionArea.setRows(3);
        Label calendarLabel = Label.create((UiContainer)parent, (Msg)DesignerMsg.CALENDAR);
        this.calendarComboBox = UiFactory.createComboBox((UiContainer)parent, this.buildCalendars());
        this.calendarComboBox.setLabelProvider(new LabelProvider(){

            public Image getIcon(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (CoreMsg.NONE.getString().equals(element)) {
                    return (String)element;
                }
                return OrganizationalUnitPanel.this.getOrganization().findCalendarRule((String)element).getName();
            }
        });
        Panel membersMainPanel = new Panel(parent, DesignerMsg.MEMBERS);
        membersMainPanel.setLayout((Layout)new BorderLayout());
        this.membersPanel = new MembersPanel((UiContainer)membersMainPanel);
        membersMainPanel.add((UiComponent)this.membersPanel, (Object)"Center");
        this.appendRow(nameLabel, (UiComponent)this.nameField);
        this.add((UiComponent)descriptionLabel, "wrap");
        this.add((UiComponent)this.descriptionArea, "spanx, wrap, growx");
        this.appendRow(calendarLabel, (UiComponent)this.calendarComboBox);
        this.add((UiComponent)membersMainPanel, "spanx, height 150, wrap, grow");
    }

    private void addCalendarRuleProjectListener() {
        ProjectListenerAdapter<CalendarRule> projectAdapter = new ProjectListenerAdapter<CalendarRule>(CalendarRule.class){

            public void postObjectAdded(CalendarRule calendarRule, ProjectObject parent) {
                OrganizationalUnitPanel.this.calendarComboBox.addItem((Object)calendarRule.getId());
            }

            public void postObjectRemoved(CalendarRule calendarRule, ProjectObject parent) {
                boolean selected = ((String)OrganizationalUnitPanel.this.calendarComboBox.getSelectedItem()).equals(calendarRule.getId());
                OrganizationalUnitPanel.this.calendarComboBox.removeItem((Object)calendarRule.getId());
                if (selected) {
                    OrganizationalUnitPanel.this.calendarComboBox.setSelectedItem((Object)CoreMsg.NONE.getString());
                }
            }
        };
        this.calendarRuleUiProjectListener = new UiProjectAdapter((ProjectListener)projectAdapter);
        this.getOrganization().addListener(this.calendarRuleUiProjectListener);
    }

    private List<String> buildCalendars() {
        TreeSet<String> list = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s, String s1) {
                if (CoreMsg.NONE.getString().equals(s)) {
                    return -1;
                }
                if (CoreMsg.NONE.getString().equals(s1)) {
                    return 1;
                }
                return OrganizationalUnitPanel.this.getOrganization().findCalendarRule(s).getName().compareTo(OrganizationalUnitPanel.this.getOrganization().findCalendarRule(s1).getName());
            }
        });
        list.add(CoreMsg.NONE.getString());
        for (CalendarRule rule : this.getOrganization().getCalendarRules()) {
            list.add(rule.getId());
        }
        if (this.getProjectObject() != null && ((OrganizationalUnit)this.getProjectObject()).getCalendarRuleAssignment() != null && ((OrganizationalUnit)this.getProjectObject()).getCalendarRuleAssignment().getCalendarRule() == null) {
            list.add(((OrganizationalUnit)this.getProjectObject()).getCalendarRuleAssignment().getCalendarRuleId());
        }
        return new ArrayList<String>(list);
    }
}

