/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MutableListListModel;
import oracle.bpm.ui.MutableListModel;
import oracle.bpm.ui.MutableListModelComboBoxModel;
import oracle.bpm.ui.UiContainer;

public class OrganizationalUnitCombo
extends ComboBox<OrganizationalUnit> {
    private Project project;

    public OrganizationalUnitCombo(UiContainer parent, Project project) {
        super(parent, false);
        this.project = project;
        this.init();
    }

    public void setSelectedOu(OrganizationalUnit ou) {
        this.setSelectedOu(ou.getId());
    }

    public void setSelectedOu(String ouId) {
        int index = -1;
        String ou = ouId;
        if (ou == null || ou.trim().length() == 0) {
            ou = "";
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            OrganizationalUnit unit = (OrganizationalUnit)this.getItemAt(i);
            if (!ou.equals(unit.getId())) continue;
            index = i;
            break;
        }
        this.setSelectedIndex(index);
    }

    public OrganizationalUnit getOu() {
        return (OrganizationalUnit)this.getSelectedItem();
    }

    private void init() {
        MutableListListModel mut = new MutableListListModel(new ArrayList());
        MutableListModelComboBoxModel model = new MutableListModelComboBoxModel((MutableListModel)mut);
        this.setModel((ComboBoxModel)model);
        this.listListModel = mut;
        this.setLabelProvider(this.getOuLabelProvider());
        TreeSet<OrganizationalUnit> ouList = new TreeSet<OrganizationalUnit>(new OuComparator());
        for (OrganizationalUnit organizationalUnit : this.project.getOrganization().getOrganizationalUnits()) {
            ouList.add(organizationalUnit);
        }
        ouList.add(this.project.getOrganization().getRootOrganizationalUnit());
        for (OrganizationalUnit ou : ouList) {
            assert (ou != null) : "Attempt to add a null organization unit!";
            model.addElement((Object)ou);
        }
    }

    private LabelProvider<OrganizationalUnit> getOuLabelProvider() {
        return new LabelProvider.Default<OrganizationalUnit>(){

            public String getText(OrganizationalUnit ou) {
                return ou != null ? ou.getInternalPath() : "";
            }
        };
    }

    private class OuComparator
    implements Comparator<OrganizationalUnit> {
        private OuComparator() {
        }

        @Override
        public int compare(OrganizationalUnit ou1, OrganizationalUnit ou2) {
            return ou1.getKey().compareTo((Object)ou2.getKey());
        }
    }
}

