/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.Comparator;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.action.organization.NewOrganizationalUnitAction;
import oracle.bpm.designer.organization.OrganizationalUnitFilter;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.tree.TreeBasePanel;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class OrganizationalChartTreePanel
extends TreeBasePanel {
    private OrganizationalChart organizationalChart;
    private ProjectListener ouProjectListener;

    public OrganizationalChartTreePanel(UiContainer parent, Msg title, OrganizationalChart organizationalChart) {
        super(parent, title, TreeBasePanel.Style.TOOLBAR_TOP);
        this.organizationalChart = organizationalChart;
        this.addOuProjectListener();
        this.init();
    }

    protected void onDispose() {
        this.getOrganization().removeListener(this.ouProjectListener);
    }

    protected void addAction(@NotNull TreeNode selectedNode) {
        OrganizationalUnit parentOu = selectedNode.isRoot() ? null : (OrganizationalUnit)selectedNode.getUserObject();
        NewOrganizationalUnitAction newOuAction = new NewOrganizationalUnitAction(this.organizationalChart.getOrganization(), parentOu, false);
        newOuAction.run();
    }

    protected void deleteAction(@NotNull TreeNode selectedNode) {
        try {
            OrganizationalUnit ou = (OrganizationalUnit)selectedNode.getUserObject();
            if (ou.getParent() == null) {
                this.organizationalChart.removeChild((ProjectObject)ou);
            } else {
                ou.getParent().removeChild((ProjectObject)ou);
            }
        }
        catch (Throwable t) {
            MessageDialog.showError((Throwable)t);
        }
    }

    protected boolean isAddableSelection() {
        return super.isAddableSelection() && (this.getSelectedTreeNode() == this.getRoot() && !this.getSelectedTreeNode().hasChildren() || this.getSelectedTreeNode() != this.getRoot());
    }

    private void addOuProjectListener() {
        this.ouProjectListener = new ProjectListenerAdapter<OrganizationalUnit>(OrganizationalUnit.class){

            public void postObjectAdded(OrganizationalUnit ou, ProjectObject parent) {
                TreeNode parentNode = OrganizationalChartTreePanel.this.findNodeByUserObject(parent);
                if (parentNode != null) {
                    TreeNode nodeAded = parentNode.addDynamic((Object)ou, (Comparator)ProjectObjectTreeNode.getComparator());
                    nodeAded.select();
                }
            }

            public void objectChanged(OrganizationalUnit projectObject, ProjectEvent event) {
                OrganizationalChartTreePanel.this.getSelectedTreeNode().nodeChanged();
            }

            public void postObjectRemoved(OrganizationalUnit object, ProjectObject parent) {
                TreeNode node = OrganizationalChartTreePanel.this.findNodeByUserObject(object);
                if (node != null) {
                    TreeNode parentNode = node.getParent();
                    int nodeIndex = parentNode.getIndex(node) - 1;
                    node.removeFromParent();
                    if (nodeIndex > -1) {
                        parentNode.getChildAt(nodeIndex).select();
                    } else {
                        parentNode.select();
                    }
                }
            }
        };
        this.getOrganization().addListener(this.ouProjectListener);
    }

    private void init() {
        ProjectObjectTreeNode projectObjectTreeNode = (ProjectObjectTreeNode)TreeNode.createDynamic((Object)this.organizationalChart);
        projectObjectTreeNode.setFilter(OrganizationalUnitFilter.getInstance());
        this.setRoot(projectObjectTreeNode);
    }

    private Organization getOrganization() {
        return this.organizationalChart.getOrganization();
    }
}

