/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.List;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TitlePanel;
import oracle.bpm.ui.TreePanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;

abstract class OrganizationBaseSheet<E>
extends TreePanel.Sheet {
    private BaseAction copyAction;
    private BaseAction deleteAction;
    private Project project;
    private BaseAction propertiesAction;
    protected static int MAX_PARTICIPANTS = 1000;

    OrganizationBaseSheet(TreePanel.Sheet parentSheet, Msg msg, Project project) {
        super(parentSheet, msg, null);
        this.project = project;
        UiContainer container = parentSheet.getParentProvider().createParent();
        Panel editor = this.buildEditorPanel(container);
        ((TitlePanel)container).addContent((UiComponent)editor);
        this.setEditor((UiComponent)editor);
    }

    protected abstract E getSelectedObject();

    protected abstract List<E> getSelectedObjects();

    protected abstract void addAction();

    protected abstract UiComponent buildEditor(UiContainer var1);

    protected abstract void copyAction(E var1);

    protected abstract void deleteAction(List<E> var1);

    protected abstract void refresh();

    protected abstract void updateAction(E var1);

    protected Project getProject() {
        return this.project;
    }

    protected BaseAction[] getUserActions() {
        return new BaseAction[0];
    }

    protected void enableDeleteAction(boolean enabled) {
        this.deleteAction.setEnabled(enabled);
    }

    protected void updateActions(int rows) {
        this.copyAction.setEnabled(rows == 1);
        this.propertiesAction.setEnabled(rows == 1);
        this.deleteAction.setEnabled(rows >= 1);
    }

    private Panel buildEditorPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new BorderLayout());
        UiComponent options = this.buildOptions((UiContainer)panel);
        UiComponent editor = this.buildEditor((UiContainer)panel);
        panel.add(editor, (Object)"Center");
        panel.add(options, (Object)"East");
        return panel;
    }

    private UiComponent buildOptions(UiContainer parent) {
        BaseAction newAction = new BaseAction(UIMsg.MENU_NEW){

            public void run() {
                OrganizationBaseSheet.this.addAction();
            }
        };
        this.copyAction = new BaseAction(UIMsg.COPY){

            public void run() {
                OrganizationBaseSheet.this.copyAction(OrganizationBaseSheet.this.getSelectedObject());
            }
        };
        this.propertiesAction = new BaseAction(DesignerMsg.PROPERTIES){

            public void run() {
                OrganizationBaseSheet.this.updateAction(OrganizationBaseSheet.this.getSelectedObject());
            }
        };
        this.propertiesAction.setEnabled(false);
        this.deleteAction = new BaseAction(UIMsg.MENU_DELETE){

            public void run() {
                OrganizationBaseSheet.this.deleteAction(OrganizationBaseSheet.this.getSelectedObjects());
            }
        };
        this.deleteAction.setEnabled(false);
        BaseAction[] actions = this.getUserActions();
        Panel container = new Panel(parent);
        String colSpecs = "5dlu, pref:grow, 5dlu";
        String rowSpecs = "3dlu, pref, 3dlu, pref, 3dlu, pref";
        FormLayout layout = new FormLayout("5dlu, pref:grow, 5dlu", "3dlu, pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder builder = layout.createBuilder(container);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)new Button((UiContainer)container, newAction, true), cc.xy(2, 2));
        builder.add((UiComponent)new Button((UiContainer)container, this.propertiesAction), cc.xy(2, 4));
        builder.add((UiComponent)new Button((UiContainer)container, this.deleteAction), cc.xy(2, 6));
        for (int i = 0; i < actions.length; ++i) {
            layout.appendRow("3dlu");
            layout.appendRow("pref");
            builder.add((UiComponent)new Button((UiContainer)container, actions[i]), cc.xy(2, 8 + i));
        }
        return container;
    }
}

