/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.List;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.EscalateOrgRolesTablePanel;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;

public class OrgRolesDialog
extends OkCancelDialog {
    private List<Role> availableRoles;
    private EscalateOrgRolesTablePanel escalateOrgRolesTablePanel;

    public OrgRolesDialog(UiWindow parent, List<Role> availableRoles) {
        this(parent, availableRoles, DesignerMsg.ROLES);
    }

    public OrgRolesDialog(UiWindow parent, List<Role> availableRoles, Msg title) {
        super(parent, title);
        this.availableRoles = availableRoles;
        this.buildUi();
    }

    public Role getSelectedRole() {
        return this.escalateOrgRolesTablePanel.getSelectedRole();
    }

    public void ok() {
        if (this.escalateOrgRolesTablePanel != null) {
            if (this.getSelectedRole() == null) {
                MessageDialog.showError((Msg)DesignerMsg.NOT_SELECTED(DesignerMsg.ROLE.getString()));
            } else {
                this.setVisible(false);
            }
        }
    }

    private void buildUi() {
        UiContainer mainPanel = this.getContentPane();
        if (this.availableRoles.isEmpty()) {
            mainPanel.add((UiComponent)Label.createWithNoColon((UiContainer)mainPanel, (Msg)DesignerMsg.NO_ROLES_TO_ASSIGN));
        } else {
            this.escalateOrgRolesTablePanel = new EscalateOrgRolesTablePanel(mainPanel, this.availableRoles);
            mainPanel.add((UiComponent)this.escalateOrgRolesTablePanel);
        }
        this.setLocationRelativeTo((UiComponent)this.getParent());
        this.pack();
        this.setSize(300, 220);
    }
}

