/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.List;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.action.organization.NewHolidayRuleAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.HolidayPanel;
import oracle.bpm.designer.organization.OrganizationBaseTablePanel;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.TableModel;

public class HolidayRulesPanel
extends Panel {
    private HolidayPanel holidayPanel;
    private Panel holidayRuleDetailPanel;
    private ModificationListener holidayRulePanelModificationListener;
    private ProjectListener<HolidayRule> holidayRulesProjectListener;
    private ProviderTableModel<HolidayRule> holidayRulesTableModel;
    private CardLayout hrDetailPanelCardLayout;
    private Organization organization;
    private static final String NO_HOLIDAY_RULE_PANEL = "noHolidayRulePanel";
    private static final String HOLIDAY_PANEL = "holidayPanel";

    public HolidayRulesPanel(UiContainer parent, Organization organization) {
        super(parent);
        this.organization = organization;
        this.buildUi();
        this.addHolidayRulesProjectListener();
    }

    protected void onDispose() {
        this.organization.removeListener(this.holidayRulesProjectListener);
    }

    private void addHolidayRulesProjectListener() {
        this.holidayRulesProjectListener = new ProjectListenerAdapter<HolidayRule>(HolidayRule.class){

            public void postObjectAdded(HolidayRule object, ProjectObject parent) {
                HolidayRulesPanel.this.holidayRulesTableModel.addRow((Object)object);
            }

            public void postObjectRemoved(HolidayRule object, ProjectObject parent) {
                int rowIndex = HolidayRulesPanel.this.holidayRulesTableModel.getRowIndex((Object)object);
                HolidayRulesPanel.this.holidayRulesTableModel.removeRow(rowIndex);
            }
        };
        this.organization.addListener(this.holidayRulesProjectListener);
    }

    private void buildUi() {
        this.setLayout((Layout)new MigLayout("fill, gap 5, ins 5, wrap 1"));
        this.holidayRulesTableModel = new HolidayRulesTableModel(this.organization.getHolidayRules());
        SplitPane pane = new SplitPane((UiContainer)this, 0);
        HolidayRulesTablePanel holidayRulesTablePanel = new HolidayRulesTablePanel((UiContainer)pane, this.holidayRulesTableModel);
        Panel holidayRulePanel = this.buildHolidayRuleDetailPanel((UiContainer)pane);
        pane.setTopComponent((UiComponent)holidayRulesTablePanel);
        pane.setBottomComponent((UiComponent)holidayRulePanel);
        pane.setResizeWeight(0.3);
        this.add((UiComponent)pane, "growx, growy ");
    }

    private Panel buildHolidayRuleDetailPanel(UiContainer parent) {
        this.holidayRuleDetailPanel = new Panel(parent);
        this.hrDetailPanelCardLayout = new CardLayout();
        this.holidayRuleDetailPanel.setLayout((Layout)this.hrDetailPanelCardLayout);
        Label label = Label.createWithNoColon((UiContainer)this.holidayRuleDetailPanel, (Msg)DesignerMsg.NO_HOLIDAY_RULE_SELECTED);
        label.setHorizontalAlignment(0);
        ScrollPane scroll = new ScrollPane((UiContainer)this.holidayRuleDetailPanel);
        this.holidayPanel = new HolidayPanel((UiContainer)scroll, this.organization, null);
        this.holidayPanel.addModificationListener(this.getHolidayPanelModificationListener());
        scroll.setView((UiComponent)this.holidayPanel);
        this.holidayRuleDetailPanel.add((UiComponent)label, (Object)NO_HOLIDAY_RULE_PANEL);
        this.holidayRuleDetailPanel.add((UiComponent)scroll, (Object)HOLIDAY_PANEL);
        this.hrDetailPanelCardLayout.show((UiContainer)this.holidayRuleDetailPanel, NO_HOLIDAY_RULE_PANEL);
        return this.holidayRuleDetailPanel;
    }

    private ModificationListener getHolidayPanelModificationListener() {
        if (this.holidayRulePanelModificationListener == null) {
            this.holidayRulePanelModificationListener = new ModificationListener(){

                public void objectModified(ModificationEvent event) {
                    HolidayRulesPanel.this.holidayPanel.editorToObject();
                }
            };
        }
        return this.holidayRulePanelModificationListener;
    }

    private class HolidayRulesTablePanel
    extends OrganizationBaseTablePanel {
        public HolidayRulesTablePanel(UiContainer parent, ProviderTableModel<HolidayRule> tableModel) {
            super(parent, DesignerMsg.HOLIDAY_RULES, (TableModel)tableModel);
            this.getTable().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    int[] selectedRows = HolidayRulesTablePanel.this.getTable().getSelectedRows();
                    if (selectedRows.length == 1) {
                        HolidayRulesPanel.this.holidayPanel.removeModificationListener(HolidayRulesPanel.this.getHolidayPanelModificationListener());
                        HolidayRule holidayRule = (HolidayRule)HolidayRulesTablePanel.this.getModel().getRow(selectedRows[0]);
                        HolidayRulesPanel.this.holidayPanel.setProjectObject(holidayRule);
                        HolidayRulesPanel.this.holidayPanel.objectToEditor();
                        HolidayRulesPanel.this.hrDetailPanelCardLayout.show((UiContainer)HolidayRulesPanel.this.holidayRuleDetailPanel, HolidayRulesPanel.HOLIDAY_PANEL);
                        HolidayRulesPanel.this.holidayPanel.addModificationListener(HolidayRulesPanel.this.getHolidayPanelModificationListener());
                    } else {
                        HolidayRulesPanel.this.hrDetailPanelCardLayout.show((UiContainer)HolidayRulesPanel.this.holidayRuleDetailPanel, HolidayRulesPanel.NO_HOLIDAY_RULE_PANEL);
                    }
                }
            });
        }

        protected void addAction() {
            NewHolidayRuleAction newHolidayRuleAction = new NewHolidayRuleAction(HolidayRulesPanel.this.organization, false);
            newHolidayRuleAction.run();
        }

        protected void deleteAction() {
            try {
                int[] selectedRows = this.getTable().getSelectedRows();
                List selectedHolidayRules = HolidayRulesPanel.this.holidayRulesTableModel.getRows(selectedRows);
                for (HolidayRule holidayRule : selectedHolidayRules) {
                    HolidayRulesPanel.this.organization.removeChild((ProjectObject)holidayRule);
                }
                this.updateSelection(selectedRows);
            }
            catch (ProjectException e) {
                e.printStackTrace();
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    private class HolidayRulesTableModel
    extends ProviderTableModel<HolidayRule> {
        public HolidayRulesTableModel(Iterable<HolidayRule> holidayRules) {
            super(MsgList.create(DesignerMsg.HOLIDAYS));
            this.addRows(holidayRules);
        }

        public Object getValueAt(int row, int column) {
            return ((HolidayRule)this.getRow(row)).getName();
        }
    }
}

