/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.Collection;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.CalendarRuleAssignmentDialog;
import oracle.bpm.designer.organization.OrganizationBaseTablePanel;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.table.ProviderTableModel;
import org.jetbrains.annotations.NotNull;

public class CalendarRuleAssignmentsPanel
extends OrganizationBaseTablePanel {
    private ProjectListenerAdapter<CalendarRule> calendarRuleListener;
    private Organization organization;
    private ProjectListener<OrganizationalUnit> ouListener;
    private Role role;
    private static final int CALENDAR_COLUMN = 0;
    private static final int OU_COLUMN = 1;

    public CalendarRuleAssignmentsPanel(UiContainer parent, @NotNull Organization organization) {
        this(parent, new CalendarRuleAssignmentsTableModel(), organization);
    }

    public CalendarRuleAssignmentsPanel(UiContainer parent, @NotNull ProviderTableModel tableModel, @NotNull Organization organization) {
        super(parent, DesignerMsg.CALENDARS);
        this.setModel(tableModel);
        this.organization = organization;
        this.addCalendarRuleListener();
        this.addOuListener();
    }

    public Collection<CalendarRuleAssignment> getCalendarRulesAssignments() {
        return this.getModel().getData();
    }

    public void setRole(Role role) {
        this.role = role;
        this.getModel().removeAllElements();
        this.getModel().addRows(role.getCalendarRuleAssignment());
    }

    public void removeProjectListener() {
        this.organization.removeListener(this.calendarRuleListener);
        this.organization.removeListener(this.ouListener);
    }

    protected void addAction() {
        CalendarRuleAssignment.Mutable calendarRuleAssignment = this.role.createCalendarRuleAssignment();
        CalendarRuleAssignmentDialog calendarRuleAssignmentDialog = new CalendarRuleAssignmentDialog(Ui.getRoot(), (CalendarRuleAssignment)calendarRuleAssignment, this.getCalendarRulesAssignments());
        calendarRuleAssignmentDialog.setVisible(true);
        if (calendarRuleAssignmentDialog.userAccepted()) {
            calendarRuleAssignment.setCalendarRule(calendarRuleAssignmentDialog.getCalendarRuleSelected());
            calendarRuleAssignment.setOrganizationalUnit(calendarRuleAssignmentDialog.getOuSelected());
            this.getModel().addRow((Object)calendarRuleAssignment);
        }
    }

    protected void editAction() {
        CalendarRuleAssignment.Mutable calendarRuleAssignment = (CalendarRuleAssignment.Mutable)this.getModel().getRow(this.getTable().getSelectedRow());
        CalendarRuleAssignmentDialog calendarRuleAssignmentDialog = new CalendarRuleAssignmentDialog(Ui.getRoot(), (CalendarRuleAssignment)calendarRuleAssignment, this.getCalendarRulesAssignments());
        calendarRuleAssignmentDialog.setVisible(true);
        if (calendarRuleAssignmentDialog.userAccepted()) {
            calendarRuleAssignment.setCalendarRule(calendarRuleAssignmentDialog.getCalendarRuleSelected());
            calendarRuleAssignment.setOrganizationalUnit(calendarRuleAssignmentDialog.getOuSelected());
            this.getModel().replaceRow(this.getTable().getSelectedRow(), (Object)calendarRuleAssignment);
        }
    }

    protected boolean showEditAction() {
        return true;
    }

    private void addOuListener() {
        this.ouListener = new ProjectListenerAdapter<OrganizationalUnit>(OrganizationalUnit.class){

            public void postObjectRemoved(OrganizationalUnit object, ProjectObject parent) {
                Sequence descendants = object.getDescendants(OrganizationalUnit.class);
                for (int i = CalendarRuleAssignmentsPanel.this.getModel().getRowCount() - 1; i >= 0; --i) {
                    CalendarRuleAssignment calendarRuleAssignment = (CalendarRuleAssignment)CalendarRuleAssignmentsPanel.this.getModel().getRow(i);
                    if (!descendants.contains(calendarRuleAssignment.getOrganizationalUnit()) && !object.equals(calendarRuleAssignment.getOrganizationalUnit())) continue;
                    CalendarRuleAssignmentsPanel.this.getModel().removeRow(CalendarRuleAssignmentsPanel.this.getModel().getRowIndex((Object)calendarRuleAssignment));
                }
            }
        };
        this.organization.addListener(this.ouListener);
    }

    private void addCalendarRuleListener() {
        this.calendarRuleListener = new ProjectListenerAdapter<CalendarRule>(CalendarRule.class){

            public void postObjectRemoved(CalendarRule object, ProjectObject parent) {
                for (int i = CalendarRuleAssignmentsPanel.this.getModel().getRowCount() - 1; i >= 0; --i) {
                    CalendarRuleAssignment calendarRuleAssignment = (CalendarRuleAssignment)CalendarRuleAssignmentsPanel.this.getModel().getRow(i);
                    if (!calendarRuleAssignment.getCalendarRule().equals(object)) continue;
                    CalendarRuleAssignmentsPanel.this.getModel().removeRow(i);
                }
            }
        };
        this.organization.addListener(this.calendarRuleListener);
    }

    public static class CalendarRuleAssignmentsTableModel
    extends ProviderTableModel<CalendarRuleAssignment> {
        public CalendarRuleAssignmentsTableModel() {
            super(MsgList.create(DesignerMsg.CALENDAR, DesignerMsg.OU));
        }

        public Object getValueAt(int row, int column) {
            CalendarRuleAssignment calendarRuleAssignment = (CalendarRuleAssignment)this.getRow(row);
            switch (column) {
                case 0: {
                    CalendarRule calendarRule = calendarRuleAssignment.getCalendarRule();
                    return calendarRule != null ? calendarRule.getName() : calendarRuleAssignment.getCalendarRuleId();
                }
                case 1: {
                    OrganizationalUnit organizationalUnit = calendarRuleAssignment.getOrganizationalUnit();
                    return organizationalUnit != null ? organizationalUnit.getInternalPath() : calendarRuleAssignment.getOrganizationalUnitId();
                }
            }
            return "";
        }
    }
}

