/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.Collection;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.designer.action.organization.NewCalendarRuleAction;
import oracle.bpm.designer.action.organization.NewOrganizationalUnitAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.CalendarRuleLabelProvider;
import oracle.bpm.designer.organization.OrganizationalUnitLabelProvider;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class CalendarRuleAssignmentDialog
extends OkCancelDialog {
    private CalendarRuleAssignment calendarRuleAssignment;
    private ComboBox<CalendarRule> calendarRulesCombo;
    private ProjectListener calendarRuleProjectListener = this.createCalendarRuleListener();
    private Collection<CalendarRuleAssignment> currentCalendars;
    private ComboBox<OrganizationalUnit> ousCombo;
    private ProjectListener ouProjectListener = this.createOuProjectListener();

    public CalendarRuleAssignmentDialog(UiWindow parent, @NotNull CalendarRuleAssignment calendarRuleAssignment, Collection<CalendarRuleAssignment> currentCalendars) {
        super(parent, DesignerMsg.SELECT_CALENDAR_RULE, true);
        this.calendarRuleAssignment = calendarRuleAssignment;
        this.currentCalendars = currentCalendars;
        this.buildUi();
        this.getProject().addListener(this.calendarRuleProjectListener);
        this.getProject().addListener(this.ouProjectListener);
    }

    public void ok() {
        Msg errorMsg = this.check();
        if (errorMsg != null) {
            MessageDialog.showError((Msg)errorMsg);
            this.setVisible(true);
        } else {
            this.cleanListeners();
            this.setVisible(false);
        }
    }

    public CalendarRule getCalendarRuleSelected() {
        return (CalendarRule)this.calendarRulesCombo.getSelectedItem();
    }

    public OrganizationalUnit getOuSelected() {
        return (OrganizationalUnit)this.ousCombo.getSelectedItem();
    }

    private ProjectListener createOuProjectListener() {
        return new ProjectListenerAdapter<OrganizationalUnit>(OrganizationalUnit.class){

            public void postObjectAdded(OrganizationalUnit ou, ProjectObject parent) {
                CalendarRuleAssignmentDialog.this.ousCombo.addItem((Object)ou);
            }
        };
    }

    private Project getProject() {
        return this.getOrganization().getProject();
    }

    private ProjectListener createCalendarRuleListener() {
        return new ProjectListenerAdapter<CalendarRule>(CalendarRule.class){

            public void postObjectAdded(CalendarRule calendarRule, ProjectObject parent) {
                CalendarRuleAssignmentDialog.this.calendarRulesCombo.addItem((Object)calendarRule);
            }
        };
    }

    private void cleanListeners() {
        this.getProject().removeListener(this.calendarRuleProjectListener);
        this.getProject().removeListener(this.ouProjectListener);
    }

    private void buildUi() {
        Panel calendarsPanel = new Panel(this.getContentPane());
        calendarsPanel.setLayout((Layout)new MigLayout("fillx"));
        Label calendarRulesLabel = Label.create((UiContainer)calendarsPanel, (Msg)DesignerMsg.CALENDAR_RULE);
        this.calendarRulesCombo = UiFactory.createComboBox((UiContainer)calendarsPanel, this.getCalendarRules());
        this.calendarRulesCombo.setLabelProvider((LabelProvider)CalendarRuleLabelProvider.create());
        this.calendarRulesCombo.setPrototypeDisplayValue("CalendarXXXLabelAguanteRiver");
        if (this.calendarRuleAssignment.getCalendarRule() != null) {
            this.calendarRulesCombo.setSelectedItem((Object)this.calendarRuleAssignment.getCalendarRule());
        }
        Button addCalendarRuleButton = Button.createIconic((UiContainer)calendarsPanel, (Msg)DesignerMsg.ADD);
        addCalendarRuleButton.addActionListener(this.getAddCalendarRuleActionListener());
        Label ouLabel = Label.create((UiContainer)calendarsPanel, (Msg)DesignerMsg.OU);
        this.ousCombo = UiFactory.createComboBox((UiContainer)calendarsPanel, this.getOus());
        this.ousCombo.setLabelProvider((LabelProvider)OrganizationalUnitLabelProvider.create());
        if (this.calendarRuleAssignment.getOrganizationalUnit() != null) {
            this.ousCombo.setSelectedItem((Object)this.calendarRuleAssignment.getOrganizationalUnit());
        }
        Button addOuButton = Button.createIconic((UiContainer)calendarsPanel, (Msg)DesignerMsg.ADD);
        addOuButton.addActionListener(this.getAddOuActionListener());
        calendarsPanel.add((UiComponent)calendarRulesLabel);
        calendarsPanel.add(this.calendarRulesCombo, (Object)"growx");
        calendarsPanel.add((UiComponent)addCalendarRuleButton, (Object)"wrap");
        calendarsPanel.add((UiComponent)ouLabel);
        calendarsPanel.add(this.ousCombo, (Object)"growx");
        calendarsPanel.add((UiComponent)addOuButton, (Object)"wrap");
        this.getContentPane().add((UiComponent)calendarsPanel, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private ActionListener getAddOuActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewOrganizationalUnitAction ouAction = new NewOrganizationalUnitAction(CalendarRuleAssignmentDialog.this.getOrganization(), (OrganizationalUnit)CalendarRuleAssignmentDialog.this.ousCombo.getSelectedItem(), false);
                ouAction.doIt();
                CalendarRuleAssignmentDialog.this.ousCombo.setSelectedItem(ouAction.getObjectAdded());
            }
        };
    }

    private ActionListener getAddCalendarRuleActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewCalendarRuleAction calendarRuleAction = new NewCalendarRuleAction(CalendarRuleAssignmentDialog.this.getOrganization(), false);
                calendarRuleAction.doIt();
                CalendarRuleAssignmentDialog.this.calendarRulesCombo.setSelectedItem(calendarRuleAction.getObjectAdded());
            }
        };
    }

    private Msg check() {
        Role role = this.calendarRuleAssignment.getRole();
        CalendarRuleAssignment.Mutable newCalendarRuleAssignment = role.createCalendarRuleAssignment();
        if (this.getCalendarRuleSelected() == null) {
            return DesignerMsg.CALENDAR_RULE_MUST_BE_SELECTED;
        }
        newCalendarRuleAssignment.setCalendarRule(this.getCalendarRuleSelected());
        if (this.getOuSelected() == null || this.getOuSelected().isRoot()) {
            return DesignerMsg.OU_RULE_MUST_BE_SELECTED;
        }
        newCalendarRuleAssignment.setOrganizationalUnit(this.getOuSelected());
        if (this.currentCalendars.contains(newCalendarRuleAssignment)) {
            return DesignerMsg.CALENDAR_ALREADY_EXISTS;
        }
        return null;
    }

    private Collection<OrganizationalUnit> getOus() {
        return CollectionUtils.createCopy(this.getOrganization().getOrganizationalUnits());
    }

    private Collection<CalendarRule> getCalendarRules() {
        return CollectionUtils.createCopy(this.getOrganization().getCalendarRules());
    }

    private Organization getOrganization() {
        return this.calendarRuleAssignment.getRole().getOrganization();
    }
}

