/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.OrganizationBasePanel;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.WorkDaySchedule;
import oracle.bpm.lang.WorkWeek;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.model.organization.HolidayRuleAssignment;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.events.UiProjectAdapter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.FuegoJob;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.util.TimeZoneItem;
import oracle.bpm.util.TimeZones;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CalendarPanel
extends OrganizationBasePanel<CalendarRule> {
    private ComboBox<String> holidayComboBox;
    private UiProjectAdapter<HolidayRule> holidayRuleProjectListener;
    private TextField nameField;
    private ComboBox<TimeZoneItem> timeZoneComboBox;
    private WorkingDays workingDays;

    public CalendarPanel(UiContainer parent, @NotNull Organization organization, @Nullable CalendarRule calendarRule) {
        super(parent, organization, calendarRule, CalendarRule.class);
        this.addHolidayRuleProjectListener();
    }

    public TextField getKeyTextField() {
        return this.nameField;
    }

    public CalendarRule getCalendarRule() {
        if (this.getProjectObject() == null) {
            return null;
        }
        return (CalendarRule)this.getProjectObject();
    }

    public Image getIcon() {
        return Image.create((Msg)DesignerMsg.CALENDARS_ICON);
    }

    public EditorType getEditorType() {
        return EditorType.CALENDAR_RULE;
    }

    public void removeListener() {
        this.getOrganization().removeListener(this.holidayRuleProjectListener);
    }

    protected void editorToObject() {
        try {
            String timeZone = this.getTimeZoneID();
            String holidayRuleId = (String)this.holidayComboBox.getSelectedItem();
            WorkWeek workWeek = this.workingDays.getWorkWeek();
            CalendarRule.Mutable calendarRule = this.getCalendarRule().asMutable();
            calendarRule.setTimeZone(timeZone);
            HolidayRuleAssignment holidayRuleAssignment = calendarRule.getHolidayRuleAssignment();
            if (holidayRuleAssignment != null && holidayRuleAssignment.getHolidayRule() != null) {
                holidayRuleAssignment.removeRelation();
            } else {
                calendarRule.removeHolidayRuleAssignment(holidayRuleAssignment);
            }
            if (!ProjectMsg.NONE.getString().equals(holidayRuleId) && holidayRuleId != null) {
                HolidayRule holidayRule = calendarRule.getOrganization().findHolidayRule(holidayRuleId);
                HolidayRuleAssignment.Mutable mutableHolidayRuleAssignment = calendarRule.createHolidayRuleAssignment();
                if (holidayRule != null) {
                    mutableHolidayRuleAssignment.setHolidayRule(holidayRule);
                    mutableHolidayRuleAssignment.addRelation();
                } else {
                    mutableHolidayRuleAssignment.setHolidayRule(holidayRuleId);
                    calendarRule.addHolidayRuleAssignment((HolidayRuleAssignment)mutableHolidayRuleAssignment);
                }
            }
            calendarRule.setName(this.nameField.getText());
            calendarRule.setWorkWeek(workWeek);
        }
        catch (Throwable t) {
            MessageDialog.showError((Throwable)t.getCause());
        }
    }

    protected void objectToEditor() {
        CalendarRule calendarRule = (CalendarRule)this.getProjectObject();
        if (calendarRule == null) {
            return;
        }
        this.nameField.setText(calendarRule.getName());
        String tzID = calendarRule.getTimeZone();
        this.timeZoneComboBox.setSelectedItem((Object)TimeZones.getNearestTimeZoneItem(tzID));
        HolidayRuleAssignment holidayRuleAssignment = calendarRule.getHolidayRuleAssignment();
        String selectedItem = holidayRuleAssignment != null ? (holidayRuleAssignment.getHolidayRule() != null ? holidayRuleAssignment.getHolidayRule().getId() : holidayRuleAssignment.getHolidayRuleId()) : CoreMsg.NONE.getString();
        this.holidayComboBox.setSelectedItem((Object)selectedItem);
        this.workingDays.setWorkWeek(calendarRule.getWorkWeek());
    }

    @Override
    protected void buildUI(UiContainer parent) {
        Label nameLabel = Label.create((UiContainer)parent, (Msg)ProjectDrawMsg.NAME);
        this.nameField = new TextField(parent, LENGTH_TEXT);
        Label timeZoneLabel = Label.create((UiContainer)parent, (Msg)DesignerMsg.TIMEZONE);
        Object[] zones = CalendarPanel.buildZones();
        this.timeZoneComboBox = UiFactory.createComboBox((UiContainer)parent, (Object[])zones);
        this.timeZoneComboBox.setSelectedIndex(0);
        Label holidayLabel = Label.create((UiContainer)parent, (Msg)DesignerMsg.HOLIDAYS);
        this.holidayComboBox = UiFactory.createComboBox((UiContainer)parent, this.buildHolidays());
        this.holidayComboBox.setLabelProvider(new LabelProvider(){

            public Image getIcon(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (CoreMsg.NONE.getString().equals(element)) {
                    return (String)element;
                }
                return CalendarPanel.this.getOrganization().findHolidayRule((String)element).getName();
            }
        });
        Panel workingDays = this.buildWorkingDaysPanel(parent);
        Panel p = new Panel((UiContainer)this);
        p.setLayout((Layout)new MigLayout("ins 5, gap 5, hidemode 3"));
        p.add((UiComponent)nameLabel);
        p.add((UiComponent)this.nameField, (Object)"wrap");
        p.add((UiComponent)timeZoneLabel);
        p.add(this.timeZoneComboBox, (Object)"wrap");
        p.add((UiComponent)holidayLabel);
        p.add(this.holidayComboBox);
        this.add((UiComponent)p, "wrap");
        this.add((UiComponent)workingDays, "spanx, wrap, grow");
    }

    private static void copySchedule(WorkDaySchedule schedule, WorkingDay.Range range1, WorkingDay.Range range2) {
        range1.setSelected(true);
        range2.setSelected(true);
        if (schedule != null) {
            range1.setStart(schedule.getStartTime(0));
            range1.setFinish(schedule.getFinishTime(0));
            if (schedule.hasShift(1)) {
                range2.setStart(schedule.getStartTime(1));
                range2.setFinish(schedule.getFinishTime(1));
            } else {
                range2.setSelected(false);
            }
        } else {
            range1.setSelected(false);
            range2.setSelected(false);
        }
    }

    private static TimeZoneItem[] buildZones() {
        return (TimeZoneItem[])FuegoWorker.post((FuegoJob)new FuegoJob<TimeZoneItem[]>(){

            public TimeZoneItem[] run() {
                return TimeZones.getSortedTimeZonesItems();
            }
        });
    }

    private void addHolidayRuleProjectListener() {
        this.holidayRuleProjectListener = new UiProjectAdapter((ProjectListener)new ProjectListenerAdapter<HolidayRule>(HolidayRule.class){

            public void postObjectAdded(HolidayRule holidayRule, ProjectObject parent) {
                CalendarPanel.this.holidayComboBox.addItem((Object)holidayRule.getId());
            }

            public void postObjectRemoved(HolidayRule object, ProjectObject parent) {
                boolean selected = ((String)CalendarPanel.this.holidayComboBox.getSelectedItem()).equals(object.getId());
                CalendarPanel.this.holidayComboBox.removeItem((Object)object.getId());
                if (selected) {
                    CalendarPanel.this.holidayComboBox.setSelectedItem((Object)CoreMsg.NONE.getString());
                }
            }
        });
        this.getOrganization().addListener(this.holidayRuleProjectListener);
    }

    private String getTimeZoneID() {
        return ((TimeZoneItem)this.timeZoneComboBox.getSelectedItem()).getID();
    }

    private List<String> buildHolidays() {
        TreeSet<String> result = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s, String s1) {
                if (CoreMsg.NONE.getString().equals(s)) {
                    return -1;
                }
                if (CoreMsg.NONE.getString().equals(s1)) {
                    return 1;
                }
                return CalendarPanel.this.getOrganization().findHolidayRule(s).getName().compareTo(CalendarPanel.this.getOrganization().findHolidayRule(s1).getName());
            }
        });
        result.add(CoreMsg.NONE.getString());
        for (HolidayRule holiday : this.getOrganization().getHolidayRules()) {
            result.add(holiday.getId());
        }
        return new ArrayList<String>(result);
    }

    private Panel buildWorkingDaysPanel(UiContainer parent) {
        Panel panel = new Panel(parent, DesignerMsg.WORKINGDAYS);
        String columns = "7dlu, min, 5dlu,  max(90px;pref), 5dlu,  max(90px;pref), 7dlu, min, 5dlu,  max(90px;pref), 5dlu,  max(90px;pref), 5dlu";
        String rows = "0dlu, pref, 10dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        CellConstraints cellConst = new CellConstraints();
        panel.setLayout((Layout)new FormLayout(columns, rows));
        Label startLabel1 = Label.create((UiContainer)panel, (Msg)DesignerMsg.STARTING_TIME);
        Label endLabel1 = Label.create((UiContainer)panel, (Msg)DesignerMsg.FINISHING_TIME);
        Label startLabel2 = Label.create((UiContainer)panel, (Msg)DesignerMsg.STARTING_TIME);
        Label endLabel2 = Label.create((UiContainer)panel, (Msg)DesignerMsg.FINISHING_TIME);
        panel.add((UiComponent)startLabel1, (Object)cellConst.xy(4, 2));
        panel.add((UiComponent)endLabel1, (Object)cellConst.xy(6, 2));
        panel.add((UiComponent)startLabel2, (Object)cellConst.xy(10, 2));
        panel.add((UiComponent)endLabel2, (Object)cellConst.xy(12, 2));
        this.workingDays = new WorkingDays((UiContainer)panel);
        WorkingDay[] workingDay = this.workingDays.getWorkingDay();
        for (int i = 0; i < workingDay.length; ++i) {
            UiComponent[] comp = workingDay[i].getComponents();
            for (int j = 0; j < comp.length; ++j) {
                panel.add(comp[j], (Object)cellConst.xy(j + (j + 2), i + (i + 4)));
            }
        }
        return panel;
    }

    private static class WorkingDays {
        private WorkingDay[] workingDay;

        WorkingDays(UiContainer parent) {
            Msg[] dayMsg = DesignerMsg.dayMsg;
            this.workingDay = new WorkingDay[dayMsg.length];
            for (int i = 0; i < dayMsg.length; ++i) {
                this.workingDay[i] = new WorkingDay(parent, dayMsg[i]);
            }
        }

        public boolean isValid() {
            boolean isValid = false;
            for (int i = 0; i < this.workingDay.length && !isValid; ++i) {
                WorkingDay day = this.workingDay[i];
                isValid = day.isSelected();
            }
            return isValid;
        }

        public void setWorkWeek(WorkWeek workWeek) {
            if (workWeek == null) {
                return;
            }
            try {
                for (int i = 0; i < this.workingDay.length; ++i) {
                    WorkingDay day = this.workingDay[i];
                    WorkDaySchedule schedule = workWeek.getSchedule(WorkWeek.dayOfWeek[i]);
                    WorkingDay.Range range1 = day.getRange1();
                    WorkingDay.Range range2 = day.getRange2();
                    CalendarPanel.copySchedule(schedule, range1, range2);
                }
            }
            catch (Exception e) {
                MessageDialog.showError((Msg)DesignerMsg.ERROR_LOADING_WORKSCHED);
            }
        }

        public WorkWeek getWorkWeek() {
            WorkWeek workWeek = new WorkWeek();
            for (int i = 0; i < this.workingDay.length; ++i) {
                WorkingDay day = this.workingDay[i];
                if (!day.isSelected()) continue;
                WorkDaySchedule schedule = new WorkDaySchedule();
                WorkingDay.Range range1 = day.getRange1();
                schedule.setShift(0, range1.getStart(), range1.getFinish());
                WorkingDay.Range range2 = day.getRange2();
                if (range2.isSelected()) {
                    schedule.setShift(1, range2.getStart(), range2.getFinish());
                }
                workWeek.setSchedule(WorkWeek.dayOfWeek[i], schedule);
            }
            return workWeek;
        }

        public WorkingDay[] getWorkingDay() {
            return this.workingDay;
        }
    }

    private static class WorkingDay {
        private Range range1;
        private Range range2;

        WorkingDay(UiContainer parent, Msg day) {
            this.range1 = new Range(parent, day);
            this.range2 = new Range(parent);
            CalendarPanel.copySchedule(WorkDaySchedule.DEFAULT, this.range1, this.range2);
            this.range1.addChangeListener(new Range.ChangeListener(){

                @Override
                public void changeSelection(boolean selected) {
                    WorkingDay.this.range2.setEnabled(selected);
                    WorkingDay.this.range2.setSelected(selected);
                }
            });
        }

        public UiComponent[] getComponents() {
            UiComponent[] c1 = this.getRange1().getComponents();
            UiComponent[] c2 = this.getRange2().getComponents();
            UiComponent[] components = new UiComponent[c1.length + c2.length];
            int j = 0;
            for (UiComponent aC1 : c1) {
                components[j++] = aC1;
            }
            for (UiComponent aC2 : c2) {
                components[j++] = aC2;
            }
            return components;
        }

        public Range getRange1() {
            return this.range1;
        }

        public Range getRange2() {
            return this.range2;
        }

        public boolean isSelected() {
            return this.range1.isSelected();
        }

        private static class Range {
            private List<ChangeListener> changeListener;
            private CheckBox checkBox;
            private TimeField finish;
            private TimeField start;

            Range(UiContainer parent) {
                this(parent, null);
            }

            Range(UiContainer parent, Msg msg) {
                this.init(parent, msg);
            }

            public UiComponent[] getComponents() {
                UiComponent[] components = new UiComponent[]{this.checkBox, UiComponent.get((Object)this.start), UiComponent.get((Object)this.finish)};
                return components;
            }

            public void setFinish(Time time) {
                this.finish.setTime(time);
            }

            public Time getFinish() {
                return this.finish.getTime();
            }

            public void setSelected(boolean selected) {
                this.checkBox.setSelected(selected);
                this.setTimeEnabled(selected);
                this.changeSelectedEvent(selected);
            }

            public boolean isSelected() {
                return this.checkBox.isSelected();
            }

            public void setStart(Time time) {
                this.start.setTime(time);
            }

            public Time getStart() {
                return this.start.getTime();
            }

            public void addChangeListener(ChangeListener listener) {
                if (this.changeListener == null) {
                    this.changeListener = new ArrayList<ChangeListener>();
                }
                this.changeListener.add(listener);
            }

            private static TimeField buildSpinner(UiContainer parent) {
                TimeField spinner = new TimeField(parent, TimeField.Style.TIME, "hh:mm a");
                spinner.setTime(Time.now());
                return spinner;
            }

            private void setEnabled(boolean enable) {
                this.checkBox.setEnabled(enable);
                this.setTimeEnabled(enable);
            }

            private void setTimeEnabled(boolean enable) {
                this.start.setEnabled(enable && this.isSelected());
                this.finish.setEnabled(enable && this.isSelected());
            }

            private void changeSelectedEvent(boolean selected) {
                if (this.changeListener != null) {
                    for (ChangeListener listener : this.changeListener) {
                        listener.changeSelection(selected);
                    }
                }
            }

            private void init(UiContainer parent, Msg msg) {
                this.checkBox = msg != null ? CheckBox.create((UiContainer)parent, (Msg)msg) : new CheckBox(parent);
                this.start = Range.buildSpinner(parent);
                this.finish = Range.buildSpinner(parent);
                this.setTimeEnabled(false);
                this.checkBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Range.this.setSelected(Range.this.checkBox.isSelected());
                    }
                });
            }

            private static interface ChangeListener {
                public void changeSelection(boolean var1);
            }
        }
    }
}

