/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.DynamicEditor;
import oracle.bpm.designer.organization.OrganizationBasePanel;
import oracle.bpm.designer.types.CILTypeComboBox;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.designer.types.TypeItemFactory;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.variables.BusinessParameter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.text.TextField;

public class BusinessParameterPanel
extends OrganizationBasePanel<BusinessParameter> {
    private DynamicEditor defaultValueEditor;
    private TextField idField;
    private CILTypeComboBox typeCombo;
    static CatalogType DEFAULT_TYPE = CatalogType.Default.getString();

    public BusinessParameterPanel(UiContainer parent, BusinessParameter var) {
        super(parent, var.getProject().getOrganization(), var, BusinessParameter.class);
    }

    public EditorType getEditorType() {
        return EditorType.BUSINESS_PARAMETER;
    }

    public Image getIcon() {
        return Image.create((Msg)DesignerMsg.BUSINESS_PARAMETER);
    }

    protected void editorToObject() {
        try {
            CatalogType type = this.getTypeDescription();
            String defaultValue = this.defaultValueEditor.getValue();
            BusinessParameter.Mutable businessParameter = ((BusinessParameter)this.getProjectObject()).asMutable();
            businessParameter.setTypeDescription(type);
            businessParameter.setDefaultValue((Object)defaultValue);
        }
        catch (Throwable t) {
            MessageDialog.showError((Throwable)t);
        }
    }

    protected void objectToEditor() {
        this.idField.setText(((BusinessParameter)this.getProjectObject()).getId());
        this.idField.setEditable(false);
        BusinessParameter var = (BusinessParameter)this.getProjectObject();
        CatalogType type = var.getTypeDescription();
        this.setTypeDescription(type);
        this.defaultValueEditor.setKind(type.getKind());
        this.defaultValueEditor.setValue(var.getDefaultValue() != null ? var.getDefaultValue().toString() : null);
    }

    @Override
    protected void buildUI(UiContainer parent) {
        this.idField = new TextField(parent, "");
        this.idField.setColumns(35);
        this.typeCombo = new CILTypeComboBox(parent){

            @Override
            protected void addTypes() {
                for (TypeItem type : TypeItemFactory.createProjectVariableValidTypes()) {
                    this.addType(type);
                }
            }
        };
        this.typeCombo.setSelectedItem(DEFAULT_TYPE);
        this.defaultValueEditor = new DynamicEditor(parent, DEFAULT_TYPE.getKind());
        this.appendRow(Label.create((UiContainer)parent, (Msg)ProjectDrawMsg.NAME), (UiComponent)this.idField);
        this.appendRow(Label.create((UiContainer)parent, (Msg)CoreMsg.TYPE), (UiComponent)this.typeCombo);
        this.appendRow(Label.create((UiContainer)parent, (Msg)DesignerMsg.ORGANIZATION_VALUE), (UiComponent)this.defaultValueEditor);
        this.typeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CatalogType typeRef;
                if (e.isStateSelected() && (typeRef = ((TypeItem)BusinessParameterPanel.this.typeCombo.getSelectedItem()).getRef()) != null) {
                    BusinessParameterPanel.this.defaultValueEditor.setKind(typeRef.getKind());
                }
            }
        });
    }

    private CatalogType getTypeDescription() {
        return ((TypeItem)this.typeCombo.getSelectedItem()).getRef();
    }

    private void setTypeDescription(CatalogType type) {
        this.typeCombo.setSelectedItem(type);
    }
}

