/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.Collection;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;

class AssignedValues
extends BaseTablePanel {
    AssignedValues(UiContainer parent) {
        super(parent, DesignerMsg.VALUES, DesignerMsg.ASSIGN_VALUE_TO_ROLE);
        this.setModel(new TableValueModel());
        this.setEnabled(false);
    }

    protected void addAction() {
        String value;
        do {
            String s;
            if ((s = MessageDialog.showInput((UiWindow)this.getOwnerWindow(), (Msg)DesignerMsg.VALUE, (Msg)DesignerMsg.VALUE)) == null) {
                return;
            }
            value = s.trim();
            if (!this.wasAlreadyAdded(value)) continue;
            MessageDialog.showError((Msg)DesignerMsg.VALUE, (Msg)DesignerMsg.PARAMETRIC_VALUE_DUPLICATE);
        } while (this.wasAlreadyAdded(value));
        if (value == null || value.length() == 0) {
            return;
        }
        this.getModel().insertRow(value);
    }

    protected TableValueModel getModel() {
        return (TableValueModel)super.getModel();
    }

    void setValues(Collection<String> values) {
        this.getModel().setValues(values);
    }

    Collection<String> getValues() {
        return this.getModel().getValues();
    }

    private boolean wasAlreadyAdded(String value) {
        return this.getModel().getRowIndex(value.toLowerCase()) > -1 || this.getModel().getRowIndex(value.toUpperCase()) > -1;
    }

    public static class TableValueModel
    extends ProviderTableModel<String> {
        TableValueModel() {
            this(null);
        }

        TableValueModel(Collection<String> values) {
            super(MsgList.create(DesignerMsg.VALUE));
            this.setValues(values);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Object getValueAt(int row, int column) {
            return this.getRow(row);
        }

        Collection<String> getValues() {
            return this.getData();
        }

        void insertRow(String value) {
            this.addRow(value);
        }

        private void setValues(Collection<String> values) {
            this.removeAllElements();
            if (values == null) {
                return;
            }
            for (String value : values) {
                this.insertRow(value);
            }
        }
    }
}

