/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import fuego.directory.DirHumanParticipant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.AssignableToRole;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.organization.RoleAssignment;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.editors.TableCellEditor;

class AssignedRoles
extends BaseTablePanel {
    private AssignableToRole assignedObject;

    AssignedRoles(UiContainer parent, Msg description, AssignableToRole assignedObject) {
        super(parent, LibMsg.ROLES, description);
        this.assignedObject = assignedObject;
        this.init();
    }

    public AssignableToRole addRolesAssigned(AssignableToRole assignableToRole) {
        AssignableToRole.Mutable mutableAssignableToRole = (AssignableToRole.Mutable)assignableToRole;
        ArrayList<RoleAssignment> origRoleAssignment = new ArrayList<RoleAssignment>();
        origRoleAssignment.addAll(mutableAssignableToRole.getRoleAssignments());
        this.cleanPreviousRoleAssignments(origRoleAssignment);
        for (RoleAssignment roleAssignment : this.getRoleAssignments()) {
            if (roleAssignment.getRole() != null) {
                roleAssignment.addRelation();
                continue;
            }
            mutableAssignableToRole.addRoleAssignment(roleAssignment);
        }
        return mutableAssignableToRole;
    }

    protected TableRoleModel getModel() {
        return (TableRoleModel)super.getModel();
    }

    protected void addAction() {
        TableRoleModel model = this.getModel();
        Collection<Role> availableRoles = this.getAvailableRoles();
        if (availableRoles.size() == 0) {
            MessageDialog.showNotice((Msg)DesignerMsg.NO_ROLES_TO_ASSIGN);
            return;
        }
        Object[] availables = availableRoles.toArray();
        Object defaultSelection = availables.length == 1 ? availables[0] : null;
        LabelProvider.Default<Role> roleLabelProvider = new LabelProvider.Default<Role>(){

            public String getText(Role role) {
                return role.getDefaultLabel();
            }
        };
        Object[] roles = DialogFactory.showInputDialog((UiWindow)this.getParentWindow(), (Msg)LibMsg.ROLES, (Msg)LibMsg.ROLES, (Object[])availables, (Object)defaultSelection, (boolean)true, (LabelProvider)roleLabelProvider);
        if (roles == null) {
            return;
        }
        String allPermissions = "";
        String[] temp = DirHumanParticipant.getPossiblePermissions();
        for (String aTemp : temp) {
            allPermissions = allPermissions + aTemp;
        }
        for (Object role1 : roles) {
            Role role = (Role)role1;
            String value = "";
            RoleAssignment.Mutable assign = ((AssignableToRole.Mutable)this.assignedObject.asMutable()).createRoleAssignment();
            assign.setRole(role);
            assign.setParametricValue(value);
            assign.setPermissions(DirHumanParticipant.castPermissionFrom(allPermissions));
            model.insertRow((RoleAssignment)assign);
        }
    }

    protected void deleteAction() {
        this.stopCellEditor();
        super.deleteAction();
    }

    void setRoleAssignment(Collection<RoleAssignment> assignedRoles) {
        this.stopCellEditor();
        this.getModel().setRoleAssignment(assignedRoles);
    }

    Collection<RoleAssignment> getRoleAssignments() {
        this.stopCellEditor();
        return this.getModel().getRoleAssignments();
    }

    private void cleanPreviousRoleAssignments(ArrayList<RoleAssignment> origRoleAssignment) {
        for (RoleAssignment roleAssignment : origRoleAssignment) {
            if (roleAssignment.getRole() != null) {
                roleAssignment.removeRelation();
                continue;
            }
            ((AssignableToRole.Mutable)roleAssignment.getAssignedObject().asMutable()).removeRoleAssignment(roleAssignment);
        }
    }

    private Collection<Role> getAvailableRoles() {
        Sequence allRoles = this.assignedObject.getOrganization().getRoles();
        TreeSet<Role> availableRoles = new TreeSet<Role>();
        for (Role role : allRoles) {
            if (this.wasSelected(role)) continue;
            availableRoles.add(role);
        }
        return availableRoles;
    }

    private boolean wasSelected(Role role) {
        TableRoleModel model = this.getModel();
        for (int j = 0; j < model.getRowCount(); ++j) {
            Role roleSelected = ((RoleAssignment)model.getRow(j)).getRole();
            if (!roleSelected.equals(role)) continue;
            return true;
        }
        return false;
    }

    private String[] getParameterOptionsFor(int row) {
        return null;
    }

    private String getSelectedParameter(int row) {
        return ((RoleAssignment)this.getModel().getRow(row)).getParametricValue();
    }

    private void init() {
        final Organization organization = this.assignedObject.getOrganization();
        this.setModel(new TableRoleModel());
        LabelProvider.Default<String> labelProvider = new LabelProvider.Default<String>(){

            public String getText(String roleId) {
                Role role = organization.findRoleById(roleId);
                return role != null ? role.getDefaultLabel() : roleId;
            }
        };
        this.getTable().getColumn(0).setLabelProvider((LabelProvider)labelProvider);
        this.getTable().getColumn(1).setCellEditor((TableCellEditor)new ParameterEditor());
    }

    private class ParameterEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ComboBox<String> combo;

        private ParameterEditor() {
        }

        public UiComponent getTableCellEditor(Table table, Object value, boolean isSelected, int row, int column) {
            this.combo = UiFactory.createComboBox((UiContainer)table, (Object[])AssignedRoles.this.getParameterOptionsFor(row));
            if (this.combo.getItemCount() > 0) {
                if (AssignedRoles.this.getSelectedParameter(row) != null) {
                    this.combo.setSelectedItem((Object)AssignedRoles.this.getSelectedParameter(row));
                } else {
                    this.combo.setSelectedIndex(0);
                }
            }
            return this.combo;
        }

        public Object getCellEditorValue() {
            return this.combo.getSelectedItem();
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            return null;
        }
    }

    private static class TableRoleModel
    extends ProviderTableModel<RoleAssignment> {
        private static final MsgList titles = MsgList.create(LibMsg.ROLE, DesignerMsg.PARAMETER);
        private static final int ROLE_COLUMN = 0;
        private static final int PARAMETER_COLUMN = 1;

        public TableRoleModel() {
            super(titles);
        }

        public boolean isCellEditable(int row, int column) {
            Role role;
            if (column == 1 && (role = ((RoleAssignment)this.getRow(row)).getRole()) != null) {
                return false;
            }
            return false;
        }

        public void setValueAt(Object value, int row, int column) {
            RoleAssignment ra = (RoleAssignment)this.getRow(row);
            if (column == 1) {
                ra.asMutable().setParametricValue(value != null ? value.toString() : null);
            }
        }

        public Object getValueAt(int row, int column) {
            RoleAssignment roleAssignment = (RoleAssignment)this.getRow(row);
            if (roleAssignment != null) {
                return column == 0 ? roleAssignment.getRoleId() : roleAssignment.getParametricValue();
            }
            return null;
        }

        void setRoleAssignment(Collection<RoleAssignment> assignedRoles) {
            this.removeAllElements();
            if (assignedRoles == null) {
                return;
            }
            for (RoleAssignment roleAssignment : assignedRoles) {
                this.insertRow(roleAssignment);
            }
        }

        Collection<RoleAssignment> getRoleAssignments() {
            return this.getData();
        }

        void insertRow(RoleAssignment assign) {
            this.addRow(assign);
        }
    }
}

