/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.BusinessParameterPanel;
import oracle.bpm.designer.organization.DynamicEditor;
import oracle.bpm.designer.organization.OrganizationalUnitLabelProvider;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Kind;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.variables.BusinessParameter;
import oracle.bpm.project.model.variables.DefaultValueAssignment;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.editors.TableCellEditor;

class AssignedOrganizationalUnits
extends BaseTablePanel {
    private BusinessParameter assignedObject;
    private DynamicEditor.CellEditor cellEditor;

    AssignedOrganizationalUnits(UiContainer parent, BusinessParameter businessParameter) {
        super(parent, DesignerMsg.OUS);
        this.assignedObject = businessParameter;
        this.init();
    }

    protected void addAction() {
        this.stoptCellEditor();
        List<OrganizationalUnit> unassignedOUs = this.getUnassignedOUs();
        if (unassignedOUs.size() == 0) {
            MessageDialog.showNotice((Msg)DesignerMsg.NO_OU_TO_ASSIGN);
            return;
        }
        OrganizationalUnit selection = unassignedOUs.size() == 1 ? unassignedOUs.get(0) : null;
        Object[] ous = DialogFactory.showInputDialog((UiWindow)this.getParentWindow(), (Msg)DesignerMsg.OUS, (Msg)DesignerMsg.OUS, (Object[])unassignedOUs.toArray(), (Object)selection, (boolean)true, (LabelProvider)OrganizationalUnitLabelProvider.create());
        if (ous.length == 0) {
            return;
        }
        TableOUModel model = this.getModel();
        for (int i = 0; i < ous.length; ++i) {
            DefaultValueAssignment.Mutable defaultValueAssignment = this.assignedObject.asMutable().createDefaultValueAssignment();
            defaultValueAssignment.setOrganizationalUnit((OrganizationalUnit)ous[i]);
            model.insertRow((DefaultValueAssignment)defaultValueAssignment);
        }
    }

    protected TableOUModel getModel() {
        return (TableOUModel)((Object)Cast.force(super.getModel()));
    }

    protected void deleteAction() {
        this.stoptCellEditor();
        super.deleteAction();
    }

    void setKind(int kind) {
        this.getModel().setKind(kind);
        this.cellEditor.setKind(kind);
    }

    int getKind() {
        return this.getModel().getKind();
    }

    void setOUAssignment(List<DefaultValueAssignment> assignment) {
        this.getModel().setOUAssignment(assignment);
    }

    List<DefaultValueAssignment> getOUAssignment() {
        this.stoptCellEditor();
        return this.getModel().getOUAssignment();
    }

    private Organization getOrganization() {
        return this.assignedObject.getProject().getOrganization();
    }

    private List<OrganizationalUnit> getUnassignedOUs() {
        TableOUModel model = this.getModel();
        ArrayList<OrganizationalUnit> availableOUs = new ArrayList<OrganizationalUnit>();
        for (OrganizationalUnit ou : this.getOrganization().getOrganizationalUnits()) {
            if (ou.isRoot() || model.existOu(ou)) continue;
            availableOUs.add(ou);
        }
        return availableOUs;
    }

    private void init() {
        this.setModel(new TableOUModel());
        this.cellEditor = new DynamicEditor.CellEditor();
        this.getTable().getColumn(1).setCellEditor((TableCellEditor)this.cellEditor);
    }

    private void stoptCellEditor() {
        TableCellEditor editor = this.getTable().getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    private static class TableOUModel
    extends ProviderTableModel<DefaultValueAssignment> {
        private int kind;
        private static final MsgList titles = MsgList.create(LibMsg.OU, DesignerMsg.VALUES);
        private static final int OU_COLUMN = 0;
        private static final int VALUE_COLUMN = 1;

        public TableOUModel() {
            super(titles);
            this.setKind(BusinessParameterPanel.DEFAULT_TYPE.getKind());
        }

        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        public void setKind(int kind) {
            this.kind = kind;
            this.resetValues();
        }

        public int getKind() {
            return this.kind;
        }

        public void setValueAt(Object value, int row, int column) {
            DefaultValueAssignment.Mutable entry = ((DefaultValueAssignment)this.getRow(row)).asMutable();
            if (column == 1) {
                entry.setDefaultValue(value);
            }
            this.fireTableDataChanged();
        }

        public Object getValueAt(int row, int column) {
            DefaultValueAssignment entry = (DefaultValueAssignment)this.getRow(row);
            return column == 0 ? entry.getOrganizationalUnit().getInternalPath() : entry.getDefaultValue();
        }

        public boolean existOu(OrganizationalUnit ou) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                DefaultValueAssignment entry = (DefaultValueAssignment)i$.next();
                if (!entry.getOrganizationalUnit().equals(ou)) continue;
                return true;
            }
            return false;
        }

        void setOUAssignment(List<DefaultValueAssignment> assignment) {
            this.removeAllElements();
            if (assignment == null) {
                return;
            }
            for (DefaultValueAssignment entry : assignment) {
                this.insertRow(entry);
            }
        }

        List<DefaultValueAssignment> getOUAssignment() {
            ArrayList<DefaultValueAssignment> list = new ArrayList<DefaultValueAssignment>();
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                DefaultValueAssignment entry = (DefaultValueAssignment)i$.next();
                list.add(entry);
            }
            return list;
        }

        void insertRow(DefaultValueAssignment entry) {
            this.addRow(entry);
        }

        private void resetValues() {
            int kind = this.getKind();
            for (int i = 0; i < this.getRowCount(); ++i) {
                String value = Kind.getInitialValue(kind);
                this.setValueAt(value, i, 1);
            }
        }
    }
}

