/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.holidays.FixedHoliday;
import oracle.bpm.holidays.Holiday;
import oracle.bpm.holidays.HolidayCalendar;
import oracle.bpm.holidays.HolidayType;
import oracle.bpm.holidays.YearApplicableHoliday;
import oracle.bpm.lang.Month;
import oracle.bpm.lang.Time;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.util.DateFormatSymbolUtils;

class AssignedHolidays
extends BaseTablePanel {
    private HolidayRule holidayRule;

    AssignedHolidays(UiContainer parent) {
        super(parent, DesignerMsg.HOLIDAYS, DesignerMsg.ASSIGN_HOLIDAY_TO_HOLIDAY_RULE, (TableModel)new TableHolidayModel(), BaseTablePanel.Style.TOOLBAR_TOP);
    }

    public void setHolidayRule(HolidayRule holidayRule) {
        this.holidayRule = holidayRule;
    }

    protected void addAction() {
        InputHolidayRuleDialog dialog = new InputHolidayRuleDialog(this, null);
        dialog.setVisible(true);
        while (dialog.userAccepted()) {
            Holiday holiday = dialog.getHolidayItem();
            HolidayCalendar holidayCalendar = this.getHolidayCalendar();
            if (this.contains(holidayCalendar, holiday)) {
                MessageDialog.showError((Msg)DesignerMsg.OBJECT_ALREADY_EXISTS(DesignerMsg.HOLIDAY, holiday.getDescription()));
                dialog.setVisible(true);
                continue;
            }
            this.getTableHolidayModel().insertRow(holiday);
            this.holidayRule.asMutable().setHolidayCalendar(this.getHolidayCalendar());
            break;
        }
    }

    protected void deleteAction() {
        super.deleteAction();
        this.holidayRule.asMutable().setHolidayCalendar(this.getHolidayCalendar());
    }

    protected boolean showEditAction() {
        return true;
    }

    protected void editAction() {
        int selectedItem = this.getTable().getSelectedRow();
        Holiday holiday1 = (Holiday)this.getTableHolidayModel().getRow(selectedItem);
        InputHolidayRuleDialog dialog = new InputHolidayRuleDialog(this, holiday1);
        String oldDescription = holiday1.getDescription();
        dialog.setVisible(true);
        while (dialog.userAccepted()) {
            Holiday holiday = dialog.getHolidayItem();
            String newDescription = holiday.getDescription();
            HolidayCalendar holidayCalendar = this.getHolidayCalendar();
            if (!oldDescription.equals(newDescription) && this.contains(holidayCalendar, holiday)) {
                MessageDialog.showError((Msg)DesignerMsg.OBJECT_ALREADY_EXISTS(DesignerMsg.HOLIDAY, holiday.getDescription()));
                dialog.setVisible(true);
                continue;
            }
            this.getTableHolidayModel().updateRow(selectedItem, holiday);
            this.holidayRule.asMutable().setHolidayCalendar(this.getHolidayCalendar());
            break;
        }
    }

    HolidayCalendar getHolidayCalendar() {
        return this.getTableHolidayModel().getHolidayCalendar();
    }

    void setItems(Holiday[] items) {
        this.getTableHolidayModel().setItems(items);
    }

    void clearItems() {
        this.getTableHolidayModel().removeAllElements();
    }

    private boolean contains(HolidayCalendar holidayCalendar, Holiday holiday) {
        return this.existsByDescription(holidayCalendar, holiday) || this.getHolidayCalendar().contains(holiday);
    }

    private boolean existsByDescription(HolidayCalendar holidayCalendar, Holiday holiday) {
        for (Holiday holidayItem : holidayCalendar.getHolidays()) {
            if (holiday == null || !holidayItem.getDescription().equals(holiday.getDescription())) continue;
            return true;
        }
        return false;
    }

    private TableHolidayModel getTableHolidayModel() {
        return (TableHolidayModel)super.getModel();
    }

    private static class TableHolidayModel
    extends ProviderTableModel<Holiday> {
        private static final MsgList titles = MsgList.create(DesignerMsg.DESCRIPTION, CoreMsg.TYPE, DesignerMsg.DATE);

        TableHolidayModel() {
            this(null);
        }

        TableHolidayModel(Holiday[] items) {
            super(titles);
            this.setItems(items);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Object getValueAt(int row, int column) {
            Holiday holiday = (Holiday)this.getRow(row);
            switch (column) {
                case 0: {
                    return holiday.getDescription();
                }
                case 1: {
                    return holiday.getType() == HolidayType.YEAR_APPLICABLE ? DesignerMsg.FIXED : DesignerMsg.COMMON;
                }
                case 2: {
                    return holiday.getDisplayValue();
                }
            }
            return "";
        }

        public void editRow(Holiday holidayItem) {
            this.updateRow(this.getRowIndex(holidayItem), holidayItem);
        }

        HolidayCalendar getHolidayCalendar() {
            Holiday[] items = new Holiday[this.getRowCount()];
            for (int i = 0; i < this.getRowCount(); ++i) {
                items[i] = (Holiday)this.getRow(i);
            }
            return new HolidayCalendar(items);
        }

        void insertRow(Holiday item) {
            this.addRow(item);
        }

        private void setItems(Holiday[] items) {
            this.removeAllElements();
            if (items != null) {
                for (Holiday item : items) {
                    this.insertRow(item);
                }
            }
        }
    }

    private static class InputHolidayRuleDialog
    extends OkCancelDialog {
        private TimeField dateField;
        private TextField descriptionField;
        private Holiday item;
        private ComboBox<Msg> typeComboBox;
        private static final String MONTH_DAY_PATTERN;
        private static final String YEAR_MONTH_DAY_PATTERN;
        private static final int COMMON = 0;

        InputHolidayRuleDialog(AssignedHolidays parent, Holiday holiday) {
            super(Ui.getRoot(), DesignerMsg.HOLIDAY, true);
            this.init();
            if (holiday != null) {
                this.descriptionField.setText(holiday.getDescription());
                this.typeComboBox.setSelectedItem((Object)(HolidayType.FIXED.equals(holiday.getType()) ? DesignerMsg.COMMON : DesignerMsg.FIXED));
                this.populateDateField(holiday);
            }
        }

        public void populateDateField(Holiday holiday) {
            if (holiday instanceof FixedHoliday) {
                this.dateField.setTime(((FixedHoliday)holiday).getDate());
            } else if (holiday instanceof YearApplicableHoliday) {
                this.dateField.setTime(((YearApplicableHoliday)holiday).getDate());
            } else {
                this.dateField.setText(holiday.getDisplayValue());
            }
        }

        public Holiday getHolidayItem() {
            return this.item;
        }

        public void ok() {
            this.item = this.buildHolidayItem();
            this.setUserAccepted(true);
            this.close();
        }

        private static void splitPattern(CharSequence datePattern, List<Character> kinds, List<StringBuilder> parts) {
            int state = 0;
            char lastKind = '\u0000';
            StringBuilder elem = null;
            int len = datePattern.length();
            for (int i = 0; i < len; ++i) {
                char c = datePattern.charAt(i);
                char kind = '-';
                switch (state) {
                    case 0: {
                        if (c == '\'') {
                            state = 1;
                            break;
                        }
                        if ((c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) break;
                        kind = c;
                        break;
                    }
                    case 1: {
                        if (c != '\'') break;
                        state = 0;
                    }
                }
                if (kind != lastKind) {
                    elem = new StringBuilder();
                    parts.add(elem);
                    kinds.add(Character.valueOf(kind));
                    lastKind = kind;
                }
                elem.append(c);
            }
        }

        private static String getMonthDayPattern(CharSequence datePattern) {
            ArrayList<Character> kinds = new ArrayList<Character>();
            ArrayList<StringBuilder> parts = new ArrayList<StringBuilder>();
            InputHolidayRuleDialog.splitPattern(datePattern, kinds, parts);
            int i = 0;
            int len = kinds.size();
            while (i < len) {
                Character kind = (Character)kinds.get(i);
                if (kind.charValue() == 'y' || kind.charValue() == 'G') {
                    kinds.remove(i);
                    parts.remove(i);
                    if (i > 0 && ((Character)kinds.get(i - 1)).charValue() == '-' && (i == --len || ((Character)kinds.get(i)).charValue() == '-')) {
                        kinds.remove(i - 1);
                        parts.remove(i - 1);
                        --len;
                        continue;
                    }
                    if (i != 0 || ((Character)kinds.get(0)).charValue() != '-') continue;
                    kinds.remove(0);
                    parts.remove(0);
                    --len;
                    continue;
                }
                ++i;
            }
            StringBuilder result = new StringBuilder();
            int len2 = kinds.size();
            for (int i2 = 0; i2 < len2; ++i2) {
                result.append((CharSequence)parts.get(i2));
            }
            return result.toString();
        }

        private UiComponent buildEditorPanel(UiContainer parent) {
            Panel panel = Panel.createPanelWithBorder((UiContainer)parent);
            FormLayout layout = new FormLayout("5dlu,pref,5dlu,fill:pref:grow,5dlu", "5dlu,pref,5dlu,pref,5dlu,pref,5dlu");
            panel.setLayout((Layout)layout);
            Label descriptionLabel = Label.create((UiContainer)panel, (Msg)DesignerMsg.DESCRIPTION);
            this.descriptionField = new TextField((UiContainer)panel, 30);
            this.descriptionField.requestFocus();
            this.descriptionField.addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    this.enableOk();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.enableOk();
                }

                public void changedUpdate(DocumentEvent e) {
                    this.enableOk();
                }

                private void enableOk() {
                    InputHolidayRuleDialog.this.enableOk(InputHolidayRuleDialog.this.descriptionField.getText().trim().length() > 0);
                }
            });
            Label typeLabel = Label.create((UiContainer)panel, (Msg)CoreMsg.TYPE);
            this.typeComboBox = UiFactory.createComboBox((UiContainer)panel, (Object[])new Msg[]{DesignerMsg.COMMON, DesignerMsg.FIXED});
            this.typeComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ComboBox cb = (ComboBox)e.getSource();
                    int type = cb.getSelectedIndex();
                    switch (type) {
                        case 0: {
                            InputHolidayRuleDialog.this.dateField.setPattern(MONTH_DAY_PATTERN);
                            break;
                        }
                        case 1: {
                            InputHolidayRuleDialog.this.dateField.setPattern(YEAR_MONTH_DAY_PATTERN);
                        }
                    }
                }
            });
            Label dateLabel = Label.create((UiContainer)panel, (Msg)DesignerMsg.DATE);
            this.dateField = new TimeField((UiContainer)panel, TimeField.Style.DATE, MONTH_DAY_PATTERN);
            CellConstraints cc = new CellConstraints();
            panel.add((UiComponent)descriptionLabel, (Object)cc.xy(2, 2));
            panel.add((UiComponent)this.descriptionField, (Object)cc.xy(4, 2));
            panel.add((UiComponent)typeLabel, (Object)cc.xy(2, 4));
            panel.add(this.typeComboBox, (Object)cc.xy(4, 4));
            panel.add((UiComponent)dateLabel, (Object)cc.xy(2, 6));
            panel.add((UiComponent)this.dateField, (Object)cc.xy(4, 6));
            return panel;
        }

        private Holiday buildHolidayItem() {
            String description = this.descriptionField.getText().trim();
            Time time = this.dateField.getTime();
            return this.typeComboBox.getSelectedIndex() != 0 ? YearApplicableHoliday.valueOf(time, description) : FixedHoliday.valueOf(time.getDay(), Month.valueOf(time.getMonth()), description);
        }

        private void init() {
            UiComponent editorPanel = this.buildEditorPanel(this.getContentPane());
            this.getContentPane().add(editorPanel, (Object)"Center");
            this.enableOk(false);
            this.pack();
            this.setLocationRelativeTo((UiComponent)this.getParent());
        }

        static {
            DateFormat df = DateFormat.getDateInstance(2);
            YEAR_MONTH_DAY_PATTERN = df instanceof SimpleDateFormat ? new SimpleDateFormat(DateFormatSymbolUtils.getSimpleFuegoDatePattern(Locale.getDefault())).toPattern() : "yyyy/MM/dd";
            MONTH_DAY_PATTERN = InputHolidayRuleDialog.getMonthDayPattern(YEAR_MONTH_DAY_PATTERN);
        }
    }
}

