/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.AssignableToGroup;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.GroupAssignment;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;

class AssignedGroups
extends BaseTablePanel {
    private String group;
    private Organization organization;

    AssignedGroups(UiContainer parent, Msg description, Organization organization) {
        this(parent, null, description, organization);
    }

    AssignedGroups(UiContainer parent, String group, Msg description, Organization organization) {
        super(parent, DesignerMsg.GROUPS, description);
        this.setModel(new TableGroupModel());
        this.group = group;
        this.organization = organization;
    }

    public AssignableToGroup addGroupsAssigned(AssignableToGroup assignableToGroup) {
        AssignableToGroup.Mutable mutableAssignableToGroup = (AssignableToGroup.Mutable)assignableToGroup;
        ArrayList origGroupAssignment = new ArrayList();
        origGroupAssignment.addAll(mutableAssignableToGroup.getGroupAssignments());
        for (GroupAssignment groupAssignment : origGroupAssignment) {
            if (groupAssignment.getGroup() != null) {
                groupAssignment.removeRelation();
                continue;
            }
            ((AssignableToGroup.Mutable)groupAssignment.getAssignedObject().asMutable()).removeGroupAssignment(groupAssignment);
        }
        for (String group : this.getGroupAssignments()) {
            Group assignedGroup = mutableAssignableToGroup.getOrganization().findGroup(group);
            GroupAssignment.Mutable groupAssignment = mutableAssignableToGroup.createGroupAssignment();
            if (assignedGroup != null) {
                groupAssignment.setGroup(assignedGroup);
                groupAssignment.addRelation();
                continue;
            }
            groupAssignment.setGroupId(group);
            mutableAssignableToGroup.addGroupAssignment((GroupAssignment)groupAssignment);
        }
        return assignableToGroup;
    }

    protected void addAction() {
        List<String> availableGroups = this.getAvailableGroups();
        if (availableGroups.size() == 0) {
            MessageDialog.showNotice((Msg)DesignerMsg.NO_GROUPS_TO_ASSIGN);
            return;
        }
        Object[] availables = availableGroups.toArray();
        Object defaultSelection = availables.length == 1 ? availables[0] : null;
        Object[] groups = DialogFactory.showInputDialog((UiWindow)this.getParentWindow(), (Msg)DesignerMsg.GROUPS, (Msg)DesignerMsg.GROUPS, (Object[])availables, (Object)defaultSelection, (boolean)true);
        if (groups == null) {
            return;
        }
        TableGroupModel model = this.getModel();
        for (int i = 0; i < groups.length; ++i) {
            String idGroup = (String)groups[i];
            model.insertRow(idGroup);
        }
    }

    protected TableGroupModel getModel() {
        return (TableGroupModel)this.getTable().getModel();
    }

    void setGroupAssignment(Collection<GroupAssignment> assignedGroups) {
        this.getModel().setGroupAssignment(assignedGroups);
    }

    String[] getGroupAssignments() {
        return this.getModel().getGroupAssignments();
    }

    private List<String> getAvailableGroups() {
        TableGroupModel model = this.getModel();
        StringList availableGroups = StringList.create();
        for (Group group : this.organization.getGroups()) {
            boolean exist = model.getRowIndex(group.getId()) > -1;
            if (exist || this.isCurrentGroup(group.getId())) continue;
            availableGroups.add(group.getId());
        }
        return availableGroups;
    }

    private boolean isCurrentGroup(String group) {
        return this.group != null && this.group.equals(group);
    }

    private static class TableGroupModel
    extends ProviderTableModel<String> {
        public TableGroupModel() {
            super(MsgList.create(ProjectDrawMsg.NAME));
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.getRow(rowIndex);
        }

        void setGroupAssignment(Collection<GroupAssignment> assignedGroups) {
            this.removeAllElements();
            if (assignedGroups == null) {
                return;
            }
            for (GroupAssignment groupAssignment : assignedGroups) {
                this.insertRow(groupAssignment.getGroup() != null ? groupAssignment.getGroup().getId() : groupAssignment.getGroupId());
            }
        }

        String[] getGroupAssignments() {
            String[] assign = new String[this.getRowCount()];
            for (int i = 0; i < this.getRowCount(); ++i) {
                assign[i] = (String)this.getValueAt(i, 0);
            }
            return assign;
        }

        void insertRow(String group) {
            this.addRow(group);
        }
    }
}

