/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.notification;

import oracle.bpm.designer.expression.ExpressionContainerListener;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.identity.LookupDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.notification.NotificationDefinitionPanel;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.notification.NotificationDefinition;
import oracle.bpm.project.model.processes.notification.VoiceNotificationDefinition;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

class VoiceNotificationDefinitionPanel
extends NotificationDefinitionPanel {
    private ExpressionPanel bodyExpressionPanel;
    private ExpressionPanel mimeTypeExpressionPanel;
    private ExpressionPanel toExpressionPanel;
    private static String DEFAULT_MIME_TYPE = "text/plain";

    protected VoiceNotificationDefinitionPanel(@NotNull UiContainer parent, @NotNull VoiceNotificationDefinition voiceNotificationDefinition) {
        super(parent, (NotificationDefinition)voiceNotificationDefinition);
        this.init();
    }

    @Override
    public boolean isValid() {
        return this.toExpressionPanel.isExpressionValid() && this.bodyExpressionPanel.isExpressionValid() && this.mimeTypeExpressionPanel.isExpressionValid();
    }

    protected VoiceNotificationDefinition getNotificationDefinition() {
        return (VoiceNotificationDefinition)super.getNotificationDefinition();
    }

    private void init() {
        this.setLayout((Layout)new BorderLayout());
        TabbedPane tabbedPane = new TabbedPane((UiContainer)this);
        this.add((UiComponent)tabbedPane, "Center");
        Panel generalPanel = new Panel((UiContainer)tabbedPane);
        generalPanel.setLayout((Layout)new MigLayout("ins 10, gap 0, fillx"));
        ExpressionContext toExpressionContext = new ExpressionContext(this.getExpressionContext(), VoiceNotificationDefinition.ResultType.getTo());
        this.toExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.TO_NUMBER, toExpressionContext, this.getNotificationDefinition().getTo(), false, LookupDialog.LookupDialogType.PHONE_NUMBER);
        this.toExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                VoiceNotificationDefinitionPanel.this.getNotificationDefinition().setTo(VoiceNotificationDefinitionPanel.this.toExpressionPanel.getExpression());
            }
        });
        ExpressionContext mimeTypeExpressionContext = new ExpressionContext(this.getExpressionContext(), VoiceNotificationDefinition.ResultType.getMimeType());
        this.mimeTypeExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.MIME_TYPE, mimeTypeExpressionContext, this.getNotificationDefinition().getMimeType(), false, null);
        this.mimeTypeExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                VoiceNotificationDefinitionPanel.this.getNotificationDefinition().setMimeType(VoiceNotificationDefinitionPanel.this.mimeTypeExpressionPanel.getExpression());
            }
        });
        if (this.mimeTypeExpressionPanel.getExpression() == null) {
            Expression mimeTypeExpression = ExpressionHelper.createTextExpression((String)DEFAULT_MIME_TYPE);
            this.mimeTypeExpressionPanel.setExpression(mimeTypeExpression);
        }
        ExpressionContext messageExpressionContext = new ExpressionContext(this.getExpressionContext(), VoiceNotificationDefinition.ResultType.getBody());
        this.bodyExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.BODY, messageExpressionContext, this.getNotificationDefinition().getBody(), true, null);
        this.bodyExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                VoiceNotificationDefinitionPanel.this.getNotificationDefinition().setBody(VoiceNotificationDefinitionPanel.this.bodyExpressionPanel.getExpression());
            }
        });
        tabbedPane.addTab(DesignerMsg.GENERAL.getString(), (UiComponent)generalPanel);
    }
}

