/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.notification;

import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.notification.UserNotificationDefinition;
import oracle.bpm.project.model.processes.notification.UserNotificationProperty;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.ObjectEditorDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UserNotificationPropertyDialog
extends ObjectEditorDialog<UserNotificationProperty> {
    private DataDeclarationContainer context;
    private ExpressionPanel headerExpressionPanel;
    private UserNotificationDefinition userNotificationDefinition;
    private ExpressionPanel valueExpressionPanel;

    public UserNotificationPropertyDialog(@NotNull UiWindow parent, @Nullable UserNotificationProperty property, @NotNull UserNotificationDefinition userNotificationDefinition, @NotNull DataDeclarationContainer context) {
        super(parent, DesignerMsg.PROPERTY, (Object)property);
        this.userNotificationDefinition = userNotificationDefinition;
        this.context = context;
    }

    protected void setObjectFromEditor(@NotNull UserNotificationProperty object) {
        throw new UnsupportedOperationException("Cannot edit a user notification property. Must delete and create a new one");
    }

    protected UserNotificationProperty createObjectFromEditor() {
        return this.userNotificationDefinition.createProperty(this.headerExpressionPanel.getExpression(), this.valueExpressionPanel.getExpression());
    }

    protected void setEditorFromObject(@NotNull UserNotificationProperty object) {
        this.headerExpressionPanel.setExpression(object.getHeader());
        this.valueExpressionPanel.setExpression(object.getValue());
    }

    protected void setEditorDefaultValues() {
    }

    protected Msg validateInput() {
        if (this.headerExpressionPanel.getExpression() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(ProjectModelMsg.HEADER);
        }
        if (!this.headerExpressionPanel.isExpressionValid()) {
            return DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(ProjectModelMsg.HEADER.getString());
        }
        if (this.valueExpressionPanel.getExpression() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.VALUE);
        }
        if (!this.valueExpressionPanel.isExpressionValid()) {
            return DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(DesignerMsg.VALUE.getString());
        }
        return null;
    }

    protected void layoutControls(@NotNull UiContainer container) {
        container.setLayout((Layout)new MigLayout("ins 5, gap 5, fill"));
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.NAME));
        ExpressionContext nameExpressionContext = this.createExpressionContext(this.context, UserNotificationProperty.ResultType.getHeader());
        this.headerExpressionPanel = ExpressionPanelFactory.createUserNotificationPropertyPanel(container, nameExpressionContext);
        container.add(this.headerExpressionPanel.getUiComponent(), (Object)"growx, wrap");
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.VALUE), (Object)"gapy 5, aligny top");
        ExpressionContext valueExpressionContext = this.createExpressionContext(this.context, UserNotificationProperty.ResultType.getValue());
        this.valueExpressionPanel = ExpressionPanelFactory.createNotificationPropertyPanel(container, valueExpressionContext, true);
        container.add(this.valueExpressionPanel.getUiComponent(), (Object)"grow, wrap");
        this.setSize(400, 200);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    protected boolean mustCreateAlways() {
        return true;
    }

    private ExpressionContext createExpressionContext(@NotNull DataDeclarationContainer context, @NotNull CatalogType resultType) {
        return new ExpressionContext(context, resultType);
    }
}

