/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.notification;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.notification.UserNotificationPropertyDialog;
import oracle.bpm.draw.Color;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.notification.UserNotificationDefinition;
import oracle.bpm.project.model.processes.notification.UserNotificationProperty;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.TableColorProvider;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.TableModel;
import org.jetbrains.annotations.NotNull;

class UserNotificationPropertiesTable
extends BaseTablePanel {
    private DataDeclarationContainer context;
    private UserNotificationDefinition userNotificationDefinition;

    public UserNotificationPropertiesTable(@NotNull UiContainer parent, @NotNull UserNotificationDefinition userNotificationDefinition, @NotNull DataDeclarationContainer context) {
        super(parent, Msg.QUOTE(""), DesignerMsg.PROPERTIES, (TableModel)new UserNotificationPropertiesTableModel(context), BaseTablePanel.Style.TOOLBAR_TOP);
        this.userNotificationDefinition = userNotificationDefinition;
        this.context = context;
        this.setWithColons(true);
        this.init();
    }

    public boolean isValid() {
        for (UserNotificationProperty property : this.getProperties()) {
            ExpressionContext headerContext = new ExpressionContext(this.context, UserNotificationProperty.ResultType.getHeader());
            if (!ExpressionHelper.isExpressionValid((Expression)property.getHeader(), (ExpressionContext)headerContext)) {
                return false;
            }
            ExpressionContext valueContext = new ExpressionContext(this.context, UserNotificationProperty.ResultType.getValue());
            if (ExpressionHelper.isExpressionValid((Expression)property.getValue(), (ExpressionContext)valueContext)) continue;
            return false;
        }
        return true;
    }

    protected boolean showEditAction() {
        return true;
    }

    protected void addAction() {
        UserNotificationPropertyDialog dialog = new UserNotificationPropertyDialog(this.getOwnerWindow(), null, this.userNotificationDefinition, this.context);
        if (dialog.display()) {
            UserNotificationProperty property = (UserNotificationProperty)dialog.getObject();
            this.getModel().addRow(property);
            this.updateProperties();
        }
    }

    protected void editAction() {
        UserNotificationProperty oldProperty = (UserNotificationProperty)this.getModel().getRow(this.getTable().getSelectedRow());
        UserNotificationPropertyDialog dialog = new UserNotificationPropertyDialog(this.getOwnerWindow(), oldProperty, this.userNotificationDefinition, this.context);
        if (dialog.display()) {
            UserNotificationProperty newProperty = (UserNotificationProperty)dialog.getObject();
            this.getModel().updateRow(this.getTable().getSelectedRow(), newProperty);
            this.updateProperties();
        }
    }

    protected void deleteAction() {
        super.deleteAction();
        this.updateProperties();
    }

    protected UserNotificationPropertiesTableModel getModel() {
        return (UserNotificationPropertiesTableModel)super.getModel();
    }

    private Sequence<UserNotificationProperty> getProperties() {
        return CollectionUtils.asSequence(this.getModel().getData());
    }

    private void updateProperties() {
        this.userNotificationDefinition.clearProperties();
        for (UserNotificationProperty property : this.getProperties()) {
            this.userNotificationDefinition.addProperty(property);
        }
    }

    private void init() {
        this.getTable().getColumn(0).setColorProvider((ColorProvider)new TableColorProvider.Default(){

            public Color getForeground(Object element) {
                return !UserNotificationPropertiesTable.this.getModel().isValid(0, this.getRow()) ? Color.RED : null;
            }

            public Color getBackground(Object element) {
                return Color.WHITE;
            }
        });
        this.getTable().getColumn(1).setColorProvider((ColorProvider)new TableColorProvider.Default(){

            public Color getForeground(Object element) {
                return !UserNotificationPropertiesTable.this.getModel().isValid(1, this.getRow()) ? Color.RED : null;
            }

            public Color getBackground(Object element) {
                return Color.WHITE;
            }
        });
        for (UserNotificationProperty item : this.userNotificationDefinition.getProperties()) {
            this.getModel().addRow(item);
        }
    }

    private static class UserNotificationPropertiesTableModel
    extends ProviderTableModel<UserNotificationProperty> {
        private DataDeclarationContainer context;
        private static final MsgList titles = MsgList.create(ProjectModelMsg.HEADER, DesignerMsg.VALUE);

        public UserNotificationPropertiesTableModel(@NotNull DataDeclarationContainer context) {
            super(titles);
            this.context = context;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Object getValueAt(int row, int column) {
            return this.getExpressionText(row, column);
        }

        public boolean isValid(int column, int row) {
            Expression expression = this.getExpression(column, row);
            ExpressionContext expressionContext = this.getExpressionContext(column);
            return ExpressionHelper.isExpressionValid((Expression)expression, (ExpressionContext)expressionContext);
        }

        private Expression getExpression(int column, int row) {
            Expression result = null;
            UserNotificationProperty property = (UserNotificationProperty)this.getRow(row);
            switch (column) {
                case 0: {
                    result = property.getHeader();
                    break;
                }
                case 1: {
                    result = property.getValue();
                }
            }
            return result;
        }

        private String getExpressionText(int row, int column) {
            Expression expression = this.getExpression(column, row);
            ExpressionContext expressionContext = this.getExpressionContext(column);
            return ExpressionHelper.getText((Expression)expression, (ExpressionContext)expressionContext);
        }

        private ExpressionContext getExpressionContext(int column) {
            CatalogType resultType = null;
            switch (column) {
                case 0: {
                    resultType = UserNotificationProperty.ResultType.getHeader();
                    break;
                }
                case 1: {
                    resultType = UserNotificationProperty.ResultType.getValue();
                }
            }
            return new ExpressionContext(this.context, resultType);
        }
    }
}

