/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.notification;

import oracle.bpm.designer.expression.ExpressionContainerListener;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.identity.LookupDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.notification.NotificationDefinitionPanel;
import oracle.bpm.designer.notification.UserNotificationPropertiesTable;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.notification.NotificationDefinition;
import oracle.bpm.project.model.processes.notification.UserNotificationDefinition;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

class UserNotificationDefinitionPanel
extends NotificationDefinitionPanel {
    private ExpressionPanel messageExpressionPanel;
    private UserNotificationPropertiesTable propertiesTable;
    private ExpressionPanel subjectExpressionPanel;
    private ExpressionPanel toExpressionPanel;

    protected UserNotificationDefinitionPanel(@NotNull UiContainer parent, @NotNull UserNotificationDefinition userNotificationDefinition) {
        super(parent, (NotificationDefinition)userNotificationDefinition);
        this.init();
    }

    @Override
    public boolean isValid() {
        return this.toExpressionPanel.isExpressionValid() && this.subjectExpressionPanel.isExpressionValid() && this.messageExpressionPanel.isExpressionValid() && this.propertiesTable.isValid();
    }

    protected UserNotificationDefinition getNotificationDefinition() {
        return (UserNotificationDefinition)super.getNotificationDefinition();
    }

    private void init() {
        this.setLayout((Layout)new BorderLayout());
        TabbedPane tabbedPane = new TabbedPane((UiContainer)this);
        this.add((UiComponent)tabbedPane, "Center");
        Panel generalPanel = new Panel((UiContainer)tabbedPane);
        generalPanel.setLayout((Layout)new MigLayout("ins 10, gap 0, fillx"));
        ExpressionContext toExpressionContext = new ExpressionContext(this.getExpressionContext(), UserNotificationDefinition.ResultType.getTo());
        this.toExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.TO, toExpressionContext, this.getNotificationDefinition().getTo(), false, LookupDialog.LookupDialogType.USER);
        this.toExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                UserNotificationDefinitionPanel.this.getNotificationDefinition().setTo(UserNotificationDefinitionPanel.this.toExpressionPanel.getExpression());
            }
        });
        ExpressionContext subjectExpressionContext = new ExpressionContext(this.getExpressionContext(), UserNotificationDefinition.ResultType.getSubject());
        this.subjectExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.SUBJECT, subjectExpressionContext, this.getNotificationDefinition().getSubject(), false, null);
        this.subjectExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                UserNotificationDefinitionPanel.this.getNotificationDefinition().setSubject(UserNotificationDefinitionPanel.this.subjectExpressionPanel.getExpression());
            }
        });
        ExpressionContext messageExpressionContext = new ExpressionContext(this.getExpressionContext(), UserNotificationDefinition.ResultType.getMessage());
        this.messageExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.MESSAGE, messageExpressionContext, this.getNotificationDefinition().getMessage(), true, null);
        this.messageExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                UserNotificationDefinitionPanel.this.getNotificationDefinition().setMessage(UserNotificationDefinitionPanel.this.messageExpressionPanel.getExpression());
            }
        });
        tabbedPane.addTab(DesignerMsg.GENERAL.getString(), (UiComponent)generalPanel);
        Panel propetiesPanel = new Panel((UiContainer)tabbedPane);
        propetiesPanel.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        this.propertiesTable = new UserNotificationPropertiesTable((UiContainer)propetiesPanel, this.getNotificationDefinition(), this.getExpressionContext());
        propetiesPanel.add((UiComponent)this.propertiesTable, (Object)"grow");
        tabbedPane.addTab(DesignerMsg.PROPERTIES.getString(), (UiComponent)propetiesPanel);
    }
}

