/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.notification;

import oracle.bpm.designer.expression.ExpressionContainerListener;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.identity.LookupDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.notification.NotificationDefinitionPanel;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.notification.NotificationDefinition;
import oracle.bpm.project.model.processes.notification.SMSNotificationDefinition;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

class SMSNotificationDefinitionPanel
extends NotificationDefinitionPanel {
    private ExpressionPanel bodyExpressionPanel;
    private ExpressionPanel fromExpressionPanel;
    private ExpressionPanel subjectExpressionPanel;
    private ExpressionPanel toExpressionPanel;

    protected SMSNotificationDefinitionPanel(@NotNull UiContainer parent, @NotNull SMSNotificationDefinition smsNotificationDefinition) {
        super(parent, (NotificationDefinition)smsNotificationDefinition);
        this.init();
    }

    @Override
    public boolean isValid() {
        return this.fromExpressionPanel.isExpressionValid() && this.toExpressionPanel.isExpressionValid() && this.subjectExpressionPanel.isExpressionValid() && this.bodyExpressionPanel.isExpressionValid();
    }

    protected SMSNotificationDefinition getNotificationDefinition() {
        return (SMSNotificationDefinition)super.getNotificationDefinition();
    }

    private void init() {
        this.setLayout((Layout)new BorderLayout());
        TabbedPane tabbedPane = new TabbedPane((UiContainer)this);
        this.add((UiComponent)tabbedPane, "Center");
        Panel generalPanel = new Panel((UiContainer)tabbedPane);
        generalPanel.setLayout((Layout)new MigLayout("ins 10, gap 0, fillx"));
        ExpressionContext fromExpressionContext = new ExpressionContext(this.getExpressionContext(), SMSNotificationDefinition.ResultType.getFrom());
        this.fromExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.FROM_NUMBER, fromExpressionContext, this.getNotificationDefinition().getFrom(), false, null);
        this.fromExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                SMSNotificationDefinitionPanel.this.getNotificationDefinition().setFrom(SMSNotificationDefinitionPanel.this.fromExpressionPanel.getExpression());
            }
        });
        ExpressionContext toExpressionContext = new ExpressionContext(this.getExpressionContext(), SMSNotificationDefinition.ResultType.getTo());
        this.toExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.TO_NUMBER, toExpressionContext, this.getNotificationDefinition().getTo(), false, LookupDialog.LookupDialogType.PHONE_NUMBER);
        this.toExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                SMSNotificationDefinitionPanel.this.getNotificationDefinition().setTo(SMSNotificationDefinitionPanel.this.toExpressionPanel.getExpression());
            }
        });
        ExpressionContext subjectExpressionContext = new ExpressionContext(this.getExpressionContext(), SMSNotificationDefinition.ResultType.getSubject());
        this.subjectExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.SUBJECT, subjectExpressionContext, this.getNotificationDefinition().getSubject(), false, null);
        this.subjectExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                SMSNotificationDefinitionPanel.this.getNotificationDefinition().setSubject(SMSNotificationDefinitionPanel.this.subjectExpressionPanel.getExpression());
            }
        });
        ExpressionContext messageExpressionContext = new ExpressionContext(this.getExpressionContext(), SMSNotificationDefinition.ResultType.getBody());
        this.bodyExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.BODY, messageExpressionContext, this.getNotificationDefinition().getBody(), true, null);
        this.bodyExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                SMSNotificationDefinitionPanel.this.getNotificationDefinition().setBody(SMSNotificationDefinitionPanel.this.bodyExpressionPanel.getExpression());
            }
        });
        tabbedPane.addTab(DesignerMsg.GENERAL.getString(), (UiComponent)generalPanel);
    }
}

