/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.notification;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.notification.IMNotificationDefinitionPanel;
import oracle.bpm.designer.notification.MailNotificationDefinitionPanel;
import oracle.bpm.designer.notification.NotificationDefinitionPanel;
import oracle.bpm.designer.notification.SMSNotificationDefinitionPanel;
import oracle.bpm.designer.notification.UserNotificationDefinitionPanel;
import oracle.bpm.designer.notification.VoiceNotificationDefinitionPanel;
import oracle.bpm.designer.selectorpanel.ComboBoxSelectorPanel;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.notification.IMNotificationDefinition;
import oracle.bpm.project.model.processes.notification.MailNotificationDefinition;
import oracle.bpm.project.model.processes.notification.NotificationTask;
import oracle.bpm.project.model.processes.notification.NotificationType;
import oracle.bpm.project.model.processes.notification.SMSNotificationDefinition;
import oracle.bpm.project.model.processes.notification.UserNotificationDefinition;
import oracle.bpm.project.model.processes.notification.VoiceNotificationDefinition;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class NotificationTaskPanel
extends ComboBoxSelectorPanel<NotificationType> {
    private NotificationTask notificationTask;

    public NotificationTaskPanel(@NotNull UiContainer parent, @NotNull NotificationTask notificationTask) {
        super(parent, DesignerMsg.NOTIFICATION, DesignerMsg.NOTIFICATION_TYPE, 5);
        this.notificationTask = notificationTask;
        this.init();
    }

    public void validateEditor() throws ProjectException {
        if (!this.getInnerPanel().isValid()) {
            throw new ProjectException((ProjectObject)this.notificationTask, DesignerMsg.DYNAMIC_ONE_OR_MORE_INVALID(DesignerMsg.EXPRESSION));
        }
    }

    @Override
    public NotificationDefinitionPanel getInnerPanel() {
        return (NotificationDefinitionPanel)super.getInnerPanel();
    }

    @Override
    protected void applySelectionChanges() {
        NotificationType type = (NotificationType)this.getSelectedOption();
        this.notificationTask.setNotificationType(type);
    }

    @Override
    protected Panel createInnerPanel(@NotNull UiContainer container, @NotNull NotificationType selectedItem) {
        NotificationDefinitionPanel result = null;
        if (selectedItem == NotificationType.MAIL) {
            MailNotificationDefinition definition = (MailNotificationDefinition)this.notificationTask.getNotificationDefinition().as(MailNotificationDefinition.class);
            result = new MailNotificationDefinitionPanel(container, definition);
        } else if (selectedItem == NotificationType.USER) {
            UserNotificationDefinition definition = (UserNotificationDefinition)this.notificationTask.getNotificationDefinition().as(UserNotificationDefinition.class);
            result = new UserNotificationDefinitionPanel(container, definition);
        } else if (selectedItem == NotificationType.SMS) {
            SMSNotificationDefinition definition = (SMSNotificationDefinition)this.notificationTask.getNotificationDefinition().as(SMSNotificationDefinition.class);
            result = new SMSNotificationDefinitionPanel(container, definition);
        } else if (selectedItem == NotificationType.VOICE) {
            VoiceNotificationDefinition definition = (VoiceNotificationDefinition)this.notificationTask.getNotificationDefinition().as(VoiceNotificationDefinition.class);
            result = new VoiceNotificationDefinitionPanel(container, definition);
        } else if (selectedItem == NotificationType.IM) {
            IMNotificationDefinition definition = (IMNotificationDefinition)this.notificationTask.getNotificationDefinition().as(IMNotificationDefinition.class);
            result = new IMNotificationDefinitionPanel(container, definition);
        }
        return result;
    }

    private void init() {
        NotificationType type = this.notificationTask.getNotificationType();
        this.addOption(NotificationType.MAIL);
        this.addOption(NotificationType.USER);
        this.addOption(NotificationType.SMS);
        this.addOption(NotificationType.VOICE);
        this.addOption(NotificationType.IM);
        this.setSelectedOption(type);
        this.setLabelProvider(new LabelProvider<NotificationType>(){

            public Image getIcon(NotificationType element) {
                return Image.create((Msg)element.getMsg());
            }

            public String getText(NotificationType element) {
                return element.getMsg().getString();
            }
        });
    }
}

