/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.notification;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.identity.LookupDialog;
import oracle.bpm.designer.identity.LookupService;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItemEndpoint;
import oracle.bpm.project.model.processes.notification.NotificationDefinition;
import oracle.bpm.project.model.processes.notification.NotificationTask;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class NotificationDefinitionPanel
extends Panel {
    private NotificationDefinition notificationDefinition;

    public NotificationDefinitionPanel(@NotNull UiContainer parent, @NotNull NotificationDefinition notificationDefinition) {
        super(parent);
        this.notificationDefinition = notificationDefinition;
    }

    public abstract boolean isValid();

    protected NotificationDefinition getNotificationDefinition() {
        return this.notificationDefinition;
    }

    protected DataDeclarationContainer getExpressionContext() {
        NotificationTask task = this.notificationDefinition.getNotificationTask();
        return task.getInputDataAssociationSet().getDataDeclarationContainer(DataAssignmentItemEndpoint.SOURCE);
    }

    protected ExpressionPanel createAndAddExpressionPanel(@NotNull UiContainer container, @NotNull Msg expressionLabel, @NotNull ExpressionContext context, @Nullable Expression expression, boolean isMultiLine, final @Nullable LookupDialog.LookupDialogType lookupType) {
        Label label = Label.create((UiContainer)container, (Msg)expressionLabel);
        String labelConstraints = isMultiLine ? "gapy 5, aligny top" : "";
        container.add((UiComponent)label, (Object)labelConstraints);
        final ExpressionPanel result = ExpressionPanelFactory.createNotificationPropertyPanel(container, context, isMultiLine);
        result.setExpression(expression);
        String expressionPanelConstraints = "gapx 5, growx" + (isMultiLine ? ", pushy, growy" : "") + (lookupType == null ? ", wrap" : "");
        container.add(result.getUiComponent(), (Object)expressionPanelConstraints);
        if (lookupType != null) {
            Button lookupButton = Button.createBrowse((UiContainer)container, (Msg)DesignerMsg.SEARCH);
            lookupButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LookupDialog dialog;
                    LookupService service = AbstractStudioWorkbench.getInstance().getLookupService();
                    if (service != null && (dialog = service.getDialog(lookupType)).showDialog()) {
                        String value = dialog.getValue();
                        Expression lookupExpression = ExpressionHelper.createTextExpression((String)value);
                        result.setExpression(lookupExpression);
                    }
                }
            });
            container.add((UiComponent)lookupButton, (Object)"gapx, wrap");
        }
        return result;
    }
}

