/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.notification;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.notification.MailNotificationHeaderDialog;
import oracle.bpm.draw.Color;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.notification.MailNotificationDefinition;
import oracle.bpm.project.model.processes.notification.MailNotificationHeader;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.TableColorProvider;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.TableModel;
import org.jetbrains.annotations.NotNull;

class MailNotificationHeadersTable
extends BaseTablePanel {
    private DataDeclarationContainer context;
    private MailNotificationDefinition mailNotificationDefinition;

    public MailNotificationHeadersTable(@NotNull UiContainer parent, @NotNull MailNotificationDefinition mailNotificationDefinition, @NotNull DataDeclarationContainer context) {
        super(parent, Msg.QUOTE(""), ProjectModelMsg.HEADERS, (TableModel)new MailNotificationHeadersTableModel(context), BaseTablePanel.Style.TOOLBAR_TOP);
        this.mailNotificationDefinition = mailNotificationDefinition;
        this.context = context;
        this.setWithColons(true);
        this.init();
    }

    public boolean isValid() {
        for (MailNotificationHeader header : this.getHeaders()) {
            ExpressionContext nameContext = new ExpressionContext(this.context, MailNotificationHeader.ResultType.getName());
            if (!ExpressionHelper.isExpressionValid((Expression)header.getName(), (ExpressionContext)nameContext)) {
                return false;
            }
            ExpressionContext valueContext = new ExpressionContext(this.context, MailNotificationHeader.ResultType.getValue());
            if (ExpressionHelper.isExpressionValid((Expression)header.getValue(), (ExpressionContext)valueContext)) continue;
            return false;
        }
        return true;
    }

    protected boolean showEditAction() {
        return true;
    }

    protected void addAction() {
        MailNotificationHeaderDialog dialog = new MailNotificationHeaderDialog(this.getOwnerWindow(), null, this.mailNotificationDefinition, this.context);
        if (dialog.display()) {
            MailNotificationHeader header = (MailNotificationHeader)dialog.getObject();
            this.getModel().addRow(header);
            this.updateHeaders();
        }
    }

    protected void editAction() {
        MailNotificationHeader oldHeader = (MailNotificationHeader)this.getModel().getRow(this.getTable().getSelectedRow());
        MailNotificationHeaderDialog dialog = new MailNotificationHeaderDialog(this.getOwnerWindow(), oldHeader, this.mailNotificationDefinition, this.context);
        if (dialog.display()) {
            MailNotificationHeader newHeader = (MailNotificationHeader)dialog.getObject();
            this.getModel().updateRow(this.getTable().getSelectedRow(), newHeader);
            this.updateHeaders();
        }
    }

    protected void deleteAction() {
        super.deleteAction();
        this.updateHeaders();
    }

    protected MailNotificationHeadersTableModel getModel() {
        return (MailNotificationHeadersTableModel)super.getModel();
    }

    private Sequence<MailNotificationHeader> getHeaders() {
        return CollectionUtils.asSequence(this.getModel().getData());
    }

    private void updateHeaders() {
        this.mailNotificationDefinition.clearHeaders();
        for (MailNotificationHeader header : this.getHeaders()) {
            this.mailNotificationDefinition.addHeader(header);
        }
    }

    private void init() {
        this.getTable().getColumn(0).setColorProvider((ColorProvider)new TableColorProvider.Default(){

            public Color getForeground(Object element) {
                return !MailNotificationHeadersTable.this.getModel().isValid(0, this.getRow()) ? Color.RED : null;
            }

            public Color getBackground(Object element) {
                return Color.WHITE;
            }
        });
        this.getTable().getColumn(1).setColorProvider((ColorProvider)new TableColorProvider.Default(){

            public Color getForeground(Object element) {
                return !MailNotificationHeadersTable.this.getModel().isValid(1, this.getRow()) ? Color.RED : null;
            }

            public Color getBackground(Object element) {
                return Color.WHITE;
            }
        });
        for (MailNotificationHeader item : this.mailNotificationDefinition.getHeaders()) {
            this.getModel().addRow(item);
        }
    }

    private static class MailNotificationHeadersTableModel
    extends ProviderTableModel<MailNotificationHeader> {
        private DataDeclarationContainer context;
        private static final MsgList titles = MsgList.create(DesignerMsg.NAME, DesignerMsg.VALUE);

        public MailNotificationHeadersTableModel(@NotNull DataDeclarationContainer context) {
            super(titles);
            this.context = context;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Object getValueAt(int row, int column) {
            return this.getExpressionText(row, column);
        }

        public boolean isValid(int column, int row) {
            Expression expression = this.getExpression(column, row);
            ExpressionContext expressionContext = this.getExpressionContext(column);
            return ExpressionHelper.isExpressionValid((Expression)expression, (ExpressionContext)expressionContext);
        }

        private Expression getExpression(int column, int row) {
            Expression result = null;
            MailNotificationHeader header = (MailNotificationHeader)this.getRow(row);
            switch (column) {
                case 0: {
                    result = header.getName();
                    break;
                }
                case 1: {
                    result = header.getValue();
                }
            }
            return result;
        }

        private String getExpressionText(int row, int column) {
            Expression expression = this.getExpression(column, row);
            ExpressionContext expressionContext = this.getExpressionContext(column);
            return ExpressionHelper.getText((Expression)expression, (ExpressionContext)expressionContext);
        }

        private ExpressionContext getExpressionContext(int column) {
            CatalogType resultType = null;
            switch (column) {
                case 0: {
                    resultType = MailNotificationHeader.ResultType.getName();
                    break;
                }
                case 1: {
                    resultType = MailNotificationHeader.ResultType.getValue();
                }
            }
            return new ExpressionContext(this.context, resultType);
        }
    }
}

