/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.notification;

import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.notification.MailNotificationDefinition;
import oracle.bpm.project.model.processes.notification.MailNotificationHeader;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.ObjectEditorDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MailNotificationHeaderDialog
extends ObjectEditorDialog<MailNotificationHeader> {
    private DataDeclarationContainer context;
    private MailNotificationDefinition mailNotificationDefinition;
    private ExpressionPanel nameExpressionPanel;
    private ExpressionPanel valueExpressionPanel;

    public MailNotificationHeaderDialog(@NotNull UiWindow parent, @Nullable MailNotificationHeader header, @NotNull MailNotificationDefinition mailNotificationDefinition, @NotNull DataDeclarationContainer context) {
        super(parent, ProjectModelMsg.HEADER, (Object)header);
        this.mailNotificationDefinition = mailNotificationDefinition;
        this.context = context;
    }

    protected void setObjectFromEditor(@NotNull MailNotificationHeader object) {
        throw new UnsupportedOperationException("Cannot edit a header. Must delete and create a new one");
    }

    protected MailNotificationHeader createObjectFromEditor() {
        return this.mailNotificationDefinition.createHeader(this.nameExpressionPanel.getExpression(), this.valueExpressionPanel.getExpression());
    }

    protected void setEditorFromObject(@NotNull MailNotificationHeader object) {
        this.nameExpressionPanel.setExpression(object.getName());
        this.valueExpressionPanel.setExpression(object.getValue());
    }

    protected void setEditorDefaultValues() {
    }

    protected Msg validateInput() {
        if (this.nameExpressionPanel.getExpression() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.NAME);
        }
        if (!this.nameExpressionPanel.isExpressionValid()) {
            return DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(DesignerMsg.NAME.getString());
        }
        if (this.valueExpressionPanel.getExpression() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.VALUE);
        }
        if (!this.valueExpressionPanel.isExpressionValid()) {
            return DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(DesignerMsg.VALUE.getString());
        }
        return null;
    }

    protected void layoutControls(@NotNull UiContainer container) {
        container.setLayout((Layout)new MigLayout("ins 5, gap 5, fill"));
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.NAME));
        ExpressionContext nameExpressionContext = this.createExpressionContext(this.context, MailNotificationHeader.ResultType.getName());
        this.nameExpressionPanel = ExpressionPanelFactory.createNotificationPropertyPanel(container, nameExpressionContext, false);
        container.add(this.nameExpressionPanel.getUiComponent(), (Object)"growx, wrap");
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.VALUE), (Object)"gapy 5, aligny top");
        ExpressionContext valueExpressionContext = this.createExpressionContext(this.context, MailNotificationHeader.ResultType.getValue());
        this.valueExpressionPanel = ExpressionPanelFactory.createNotificationPropertyPanel(container, valueExpressionContext, true);
        container.add(this.valueExpressionPanel.getUiComponent(), (Object)"grow, wrap");
        this.setSize(400, 200);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    protected boolean mustCreateAlways() {
        return true;
    }

    private ExpressionContext createExpressionContext(@NotNull DataDeclarationContainer context, @NotNull CatalogType resultType) {
        return new ExpressionContext(context, resultType);
    }
}

